/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.main;

import com.ogprover.main.OGPParameters;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.GeoGebraOGPOutputProverProtocol;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.ndgcondition.AlgebraicNDGCondition;
import com.ogprover.utilities.OGPUtilities;
import com.ogprover.utilities.Stopwatch;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.Vector;

public class OGPReport {
    public static final String VERSION_NUM = "1.00";
    private OGPTP thmProtocol = null;

    public void setThmProtocol(OGPTP thmProtocol) {
        this.thmProtocol = thmProtocol;
    }

    public OGPTP getThmProtocol() {
        return this.thmProtocol;
    }

    public OGPReport(OGPTP tp) {
        this.thmProtocol = tp;
    }

    public int openReport() {
        OGPParameters parameters = OpenGeoProver.settings.getParameters();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (parameters.createReport()) {
            String title = "OpenGeoProver Output for conjecture ``" + this.thmProtocol.getTheoremName() + "'' ";
            String author = null;
            if (parameters.getProver() == 0) {
                author = "Wu's method used";
            } else if (parameters.getProver() == 1) {
                author = "Groebner basis method used";
            } else if (parameters.getProver() == 2) {
                author = "Area method used";
            }
            try {
                output.openDocument(null, title, author);
            }
            catch (IOException e) {
                logger.error("Failed to open document.");
                output.close();
                return -1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int printProverResults(int proverRetCode, GeoGebraOGPOutputProverProtocol outputObject) {
        Vector<String> ndgList;
        OGPParameters parameters = OpenGeoProver.settings.getParameters();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        Stopwatch stopwatch = OpenGeoProver.settings.getStopwacth();
        int retCode = 0;
        if (parameters.createReport()) {
            try {
                output.openSection("Prover results");
                output.openEnum("description");
                output.openItemWithDesc("Status:");
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed to write to output file");
                return -1;
            }
        }
        String statusText = "";
        switch (proverRetCode) {
            case 0: {
                statusText = "Theorem has been disproved.";
                outputObject.setOutputResult("proverResult", "false");
                break;
            }
            case 1: {
                statusText = "Theorem has been proved.";
                outputObject.setOutputResult("proverResult", "true");
                break;
            }
            case 2: {
                statusText = "Theorem can't be neither proved nor disproved.";
                outputObject.setOutputResult("proverResult", "unknown");
                break;
            }
            case -1: {
                statusText = "Proving failed - general error occurred.";
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed proving of geometry theorem");
                break;
            }
            case -4: {
                statusText = "Proving failed - Found null object when expected non-null.";
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed proving of geometry theorem");
                break;
            }
            case -3: {
                statusText = "Proving failed - Space limit has been reached.";
                outputObject.setOutputResult("proverMessage", statusText);
                break;
            }
            case -2: {
                statusText = "Proving failed - Time for prover execution has been expired.";
                outputObject.setOutputResult("proverMessage", statusText);
            }
        }
        if (parameters.createReport()) {
            try {
                output.closeItemWithDesc(statusText);
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed to write to output file");
                return -1;
            }
        }
        if (proverRetCode == -1 || proverRetCode == -4) {
            return -1;
        }
        Double timeInSec = OGPUtilities.roundUpToPrecision(stopwatch.getTimeIntSec());
        Double totalTimeOfConversionAndExecution = outputObject.getExecutionTime() + timeInSec;
        outputObject.setOutputResult("time", totalTimeOfConversionAndExecution.toString());
        StringBuilder sb = new StringBuilder();
        sb.append("Time spent by the prover is ");
        sb.append(timeInSec.toString());
        sb.append(" seconds.");
        String timeReportSec = sb.toString();
        Integer maxNumTerms = OpenGeoProver.settings.getMaxNumOfTerms();
        outputObject.setOutputResult("numTerms", maxNumTerms.toString());
        sb = new StringBuilder();
        sb.append("The biggest polynomial obtained during prover execution contains ");
        sb.append(maxNumTerms.toString());
        sb.append(" terms.");
        String spaceReport = sb.toString();
        if (parameters.createReport()) {
            try {
                output.openItemWithDesc("Space Complexity:");
                output.closeItemWithDesc(spaceReport);
                output.openItemWithDesc("Time Complexity:");
                output.closeItemWithDesc(timeReportSec);
                output.closeEnum("description");
                output.closeSection();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed to write to output file");
                return -1;
            }
        }
        if (proverRetCode != 0 && proverRetCode != 1) {
            try {
                output.closeDocument();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed to write to output file");
                return -1;
            }
            return retCode;
        }
        stopwatch.startMeasureTime();
        if (parameters.createReport()) {
            try {
                output.openSection("NDG Conditions");
                output.openSubSection("NDG Conditions in readable form", false);
                output.openEnum("itemize");
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed to write to output file");
                return -1;
            }
        }
        if ((ndgList = this.thmProtocol.exportTranslatedNDGConditions()) == null) {
            try {
                output.openItem();
                output.writePlainText("Failed to translate NDG Conditions to readable form");
                output.closeItem();
                output.closeEnum("itemize");
                output.closeSubSection();
                output.closeSection();
                outputObject.setOutputResult("failureMessage", "Failed to translate NDG conditions");
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                outputObject.setOutputResult("failureMessage", "Failed to write to output file");
            }
            finally {
                output.close();
                outputObject.setOutputResult("success", "false");
            }
            return -1;
        }
        outputObject.setNdgList(ndgList);
        if (this.thmProtocol.getAlgebraicNDGConditions() == null) {
            boolean exceptionCaught = false;
            try {
                output.openItem();
                output.writePlainText("There are no NDG conditions for this theorem");
                output.closeItem();
                output.closeEnum("itemize");
                output.closeSubSection();
                output.closeSection();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed to write to output file");
                exceptionCaught = true;
            }
            finally {
                output.close();
                if (exceptionCaught) {
                    retCode = -1;
                }
            }
            return retCode;
        }
        for (AlgebraicNDGCondition ndgc : this.thmProtocol.getAlgebraicNDGConditions()) {
            String ndgcText = ndgc.getBestDescription();
            try {
                if (ndgcText == null || ndgcText.length() == 0) {
                    output.openItem();
                    output.writePolynomial(ndgc.getPolynomial());
                    output.closeItem();
                    continue;
                }
                output.openItem();
                output.writePlainText(ndgcText);
                output.closeItem();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                outputObject.setOutputResult("success", "false");
                outputObject.setOutputResult("failureMessage", "Failed to write to output file");
                return -1;
            }
        }
        stopwatch.endMeasureTime();
        try {
            output.closeEnum("itemize");
            output.closeSubSection();
            output.openSubSection("Time spent for processing NDG Conditions", false);
            output.openEnum("itemize");
            output.openItem();
            output.writePlainText(OGPUtilities.roundUpToPrecision(stopwatch.getTimeIntSec()) + " seconds");
            output.closeItem();
            output.closeEnum("itemize");
            output.closeSubSection();
            output.closeSection();
            output.closeDocument();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            outputObject.setOutputResult("success", "false");
            outputObject.setOutputResult("failureMessage", "Failed to write to output file");
            return -1;
        }
        return retCode;
    }
}

