/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.main;

import com.ogprover.api.GeoGebraOGPInterface;
import com.ogprover.main.OGPConfigurationSettings;
import com.ogprover.main.OGPParameters;
import com.ogprover.pp.GeoGebraOGPInputProverProtocol;
import com.ogprover.pp.GeoGebraOGPOutputProverProtocol;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.utilities.io.CustomFileReader;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;

public class OpenGeoProver {
    public static final String VERSION_NUM = "1.00";
    public static OGPConfigurationSettings settings = null;

    public static void main(String[] args) {
        String xmlString;
        settings = new OGPConfigurationSettings();
        ILogger logger = settings.getLogger();
        StringBuilder sb = new StringBuilder();
        sb.append("\nOpenGeoProver Version ");
        sb.append(VERSION_NUM);
        sb.append(";\nwritten by Ivan Petrovic and Predrag Janicic, University of Belgrade.\n");
        sb.append("Reimplementation of C++ version 2.00;\nwritten by Goran Predovic and Predrag Janicic, University of Belgrade.\n");
        sb.append("Copyright (c) 2005-2011. Not for commercial use.\n\n");
        sb.append("Type \"-h\" or \"--help\" if necessary, for explanation about correct usage of command line.\n\n");
        System.out.println(sb.toString());
        if (args.length != 1) {
            logger.error("Incorrect number of command line arguments - only one is expected");
            settings.getTimer().cancel();
            return;
        }
        if (args[0].equals("-h") || args[0].equals("--help")) {
            OGPParameters.printHelp();
            settings.getTimer().cancel();
            return;
        }
        logger.info("Parsing command line...");
        String xmlFileName = args[0];
        try {
            CustomFileReader fileReader = new CustomFileReader(xmlFileName);
            StringBuffer sbuff = new StringBuffer();
            String line = null;
            while ((line = fileReader.readLine()) != null) {
                sbuff.append(line);
            }
            fileReader.close();
            xmlString = sbuff.toString();
        }
        catch (IOException e) {
            logger.error("I/O Exception caught: " + e.toString());
            e.printStackTrace();
            return;
        }
        GeoGebraOGPInputProverProtocol inputObject = new GeoGebraOGPInputProverProtocol();
        inputObject.setGeometryTheoremText(xmlString);
        inputObject.setMethod("AREA");
        inputObject.setTimeOut(10.0);
        inputObject.setMaxTerms(10000);
        inputObject.setReportFormat("NONE");
        GeoGebraOGPInterface ogpInterface = new GeoGebraOGPInterface();
        GeoGebraOGPOutputProverProtocol outputObject = (GeoGebraOGPOutputProverProtocol)ogpInterface.prove(inputObject);
        OGPTP tp = settings.getParsedTP();
        if (tp != null) {
            System.out.println("Prover results for theorem \"" + tp.getTheoremName() + "\":");
        } else {
            System.out.println("Prover results");
        }
        System.out.println("success: " + outputObject.getOutputResult("success"));
        System.out.println("failureMessage: " + outputObject.getOutputResult("failureMessage"));
        System.out.println("proverResult: " + outputObject.getOutputResult("proverResult"));
        System.out.println("proverMessage: " + outputObject.getOutputResult("proverMessage"));
        System.out.println("time: " + outputObject.getOutputResult("time"));
        System.out.println("numTerms: " + outputObject.getOutputResult("numTerms"));
        System.out.println();
        System.out.println("NDG conditions");
        for (String ndgCondText : outputObject.getNdgList()) {
            System.out.println(ndgCondText);
        }
    }
}

