/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.UFraction;
import com.ogprover.polynomials.UPolynomial;
import com.ogprover.polynomials.UTerm;
import com.ogprover.polynomials.XPolySystem;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.polynomials.XTerm;
import com.ogprover.utilities.logger.ILogger;
import java.util.Vector;

public class GeoTheorem {
    public static final String VERSION_NUM = "1.00";
    private String name;
    private XPolySystem hypotheses;
    private XPolynomial statement;
    private XPolySystem ndgConditions = null;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setHypotheses(XPolySystem hypotheses) {
        this.hypotheses = hypotheses;
    }

    public XPolySystem getHypotheses() {
        return this.hypotheses;
    }

    public void setStatement(XPolynomial statement) {
        this.statement = statement;
    }

    public XPolynomial getStatement() {
        return this.statement;
    }

    public void setNDGConditions(XPolySystem ndgCond) {
    }

    public XPolySystem getNDGConditions() {
        return this.ndgConditions;
    }

    public GeoTheorem() {
        this(null, null, null);
    }

    public GeoTheorem(String name) {
        this(name, null, null);
    }

    public GeoTheorem(XPolySystem hypotheses, XPolynomial statement) {
        this(null, hypotheses, statement);
    }

    public GeoTheorem(String name, XPolySystem hypotheses, XPolynomial statement) {
        this.name = name;
        this.hypotheses = hypotheses != null ? hypotheses : new XPolySystem();
        this.statement = statement != null ? statement : new XPolynomial();
        this.ndgConditions = new XPolySystem();
    }

    public int fillNDGConditionsForWuProver() {
        Vector<Integer> varList;
        int numOfHypotheses;
        ILogger logger = OpenGeoProver.settings.getLogger();
        XPolynomial one = new XPolynomial(1.0);
        int n = numOfHypotheses = this.hypotheses != null ? this.hypotheses.getPolynomials().size() : 0;
        if (numOfHypotheses == 0) {
            logger.error("System of hypotheses is empty.");
            return -1;
        }
        Vector<Integer> vector = varList = this.hypotheses != null ? this.hypotheses.getVariableList() : null;
        if (varList == null || varList.size() != numOfHypotheses) {
            logger.error("Triangulation is still not called.");
            return -1;
        }
        for (int ii = 0; ii < numOfHypotheses; ++ii) {
            Integer intObj = varList.get(ii);
            XPolynomial leadingCoeffPoly = this.hypotheses.getXPoly(ii).getLeadingCoefficientOfVariable(intObj);
            if (leadingCoeffPoly.equals(one)) continue;
            XPolynomial reducedLCPoly = ((XPolynomial)leadingCoeffPoly.clone()).reduceUTerms(false);
            UTerm commonUFactor = null;
            for (Term t : reducedLCPoly.getTermsAsDescList()) {
                Term xt2 = (XTerm)t;
                for (Term ut2 : ((XTerm)xt2).getUCoeff().getNumerator().getTermsAsDescList()) {
                    if (commonUFactor == null) {
                        commonUFactor = (UTerm)ut2.clone();
                        commonUFactor.setCoeff(1.0);
                        continue;
                    }
                    commonUFactor.gcd(ut2);
                }
            }
            if (commonUFactor == null || commonUFactor.isZero()) {
                logger.error("Failed to extract common u-factor from polynomial form of NDG condition.");
                return -1;
            }
            XPolynomial reducedLCPolyResidum = (XPolynomial)reducedLCPoly.clone();
            for (Term xt2 : reducedLCPolyResidum.getTermsAsDescList()) {
                ((XTerm)xt2).getUCoeff().getNumerator().divideByTerm(commonUFactor);
            }
            for (Power p : commonUFactor.getPowers()) {
                Term ut2;
                UPolynomial up2 = new UPolynomial();
                ut2 = new UTerm(1.0);
                ut2.addPower(p.clone());
                up2.addTerm(ut2);
                XTerm xt2 = new XTerm(new UFraction(up2));
                XPolynomial xp2 = new XPolynomial();
                xp2.addTerm(xt2);
                if (this.ndgConditions.getPolynomials() != null && this.ndgConditions.getPolynomials().contains(xp2)) continue;
                this.ndgConditions.addXPoly(xp2);
            }
            if (reducedLCPolyResidum.equals(one) || this.ndgConditions.getPolynomials() != null && this.ndgConditions.getPolynomials().contains(reducedLCPolyResidum)) continue;
            this.ndgConditions.addXPoly(reducedLCPolyResidum);
        }
        return 0;
    }

    public int fillNDGConditionsForGroebnerBasisProver() {
        return 0;
    }
}

