/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.RationalAlgebraicExpression;
import com.ogprover.polynomials.Term;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public abstract class Polynomial
implements Cloneable,
RationalAlgebraicExpression {
    public static final String VERSION_NUM = "1.00";
    public static final short POLY_TYPE_UPOLY = 1;
    public static final short POLY_TYPE_XPOLY = 2;
    public static final short POLY_TYPE_SYMBOLIC = 3;
    protected TreeMap<Term, Term> terms;

    public abstract int getType();

    public abstract Polynomial clone();

    public TreeMap<Term, Term> getTerms() {
        return this.terms;
    }

    public final boolean isZero() {
        return this.terms.isEmpty();
    }

    public ArrayList<Term> getTermsAsDescList() {
        Collection<Term> col = this.terms.values();
        Iterator<Term> termIT = col.iterator();
        ArrayList<Term> list = new ArrayList<Term>();
        while (termIT.hasNext()) {
            list.add(0, termIT.next());
        }
        return list;
    }

    public int getPolynomialDegree() {
        int maxDegree = 0;
        for (Term t : this.getTermsAsDescList()) {
            int localDegree = 0;
            for (Power p : t.getPowers()) {
                localDegree += p.getExponent();
            }
            if (maxDegree >= localDegree) continue;
            maxDegree = localDegree;
        }
        return maxDegree;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Polynomial)) {
            return false;
        }
        return this.clone().subtractPolynomial((Polynomial)obj).isZero();
    }

    public final Polynomial addTerm(Term t) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (t == null) {
            logger.error("Attempt to add null term.");
            return null;
        }
        if (this.getType() == 1 && t.getType() != 1 || this.getType() == 2 && t.getType() != 2 || this.getType() == 3 && t.getType() != 3) {
            logger.error("Attempt to add term of another type.");
            return null;
        }
        if (t.isZero()) {
            logger.warn("Zero term is not added to collection.");
            return this;
        }
        Term tFromTree = this.terms.get(t);
        if (tFromTree == null) {
            this.terms.put(t, t);
        } else {
            tFromTree.merge(t);
            if (tFromTree.isZero()) {
                this.terms.remove(tFromTree);
            }
        }
        return this;
    }

    public final Polynomial addPolynomial(Polynomial p) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (p == null) {
            logger.error("Attempt to add null polynomial.");
            return null;
        }
        if (this.getType() != p.getType()) {
            logger.error("Attempt to add polynomial of another type.");
            return null;
        }
        if (p.isZero()) {
            return this;
        }
        Collection<Term> col = p.getTerms().values();
        Iterator<Term> termIT = col.iterator();
        while (termIT.hasNext()) {
            this.addTerm(termIT.next().clone());
        }
        return this;
    }

    public final Polynomial subtractPolynomial(Polynomial p) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (p == null) {
            logger.error("Attempt to subtract null polynomial.");
            return null;
        }
        if (this.getType() != p.getType()) {
            logger.error("Attempt to subtract polynomial of another type.");
            return null;
        }
        Collection<Term> col = p.getTerms().values();
        Iterator<Term> termIT = col.iterator();
        while (termIT.hasNext()) {
            this.addTerm(termIT.next().clone().invert());
        }
        return this;
    }

    public final Polynomial multiplyByRealConstant(double d) {
        if (this.isZero()) {
            return this;
        }
        if (d > -1.0E-6 && d < 1.0E-6) {
            this.terms = new TreeMap();
        } else {
            Collection<Term> col = this.terms.values();
            Iterator<Term> termIT = col.iterator();
            while (termIT.hasNext()) {
                termIT.next().mul(d);
            }
        }
        return this;
    }

    public final Polynomial multiplyByTerm(Term t) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (t == null) {
            logger.error("Attempt to multiply by null term.");
            return null;
        }
        if (this.getType() == 1 && t.getType() != 1 || this.getType() == 2 && t.getType() != 2 || this.getType() == 3 && t.getType() != 3) {
            logger.error("Attempt to multiply by term of another type.");
            return null;
        }
        if (this.isZero()) {
            return this;
        }
        Collection<Term> col = this.terms.values();
        Iterator<Term> termIT = col.iterator();
        if (t.isZero()) {
            this.terms = new TreeMap();
        } else {
            while (termIT.hasNext()) {
                termIT.next().mul(t);
            }
        }
        return this;
    }

    public final Polynomial multiplyByPolynomial(Polynomial p) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (p == null) {
            logger.error("Attempt to multiply by null polynomial.");
            return null;
        }
        if (this.getType() != p.getType()) {
            logger.error("Attempt to multiply by polynomial of another type.");
            return null;
        }
        if (this.isZero()) {
            return this;
        }
        Collection<Term> col = this.terms.values();
        Iterator<Term> termIT = col.iterator();
        Collection<Term> colP = p.getTerms().values();
        Iterator<Term> termITP = colP.iterator();
        this.terms = new TreeMap();
        if (!p.isZero()) {
            while (termIT.hasNext()) {
                Term curr = termIT.next();
                while (termITP.hasNext()) {
                    Term currP = termITP.next().clone();
                    currP.mul(curr);
                    this.addTerm(currP);
                }
                termITP = colP.iterator();
            }
        }
        return this;
    }

    public final Polynomial invert() {
        Collection<Term> col = this.terms.values();
        Iterator<Term> termIT = col.iterator();
        while (termIT.hasNext()) {
            termIT.next().invert();
        }
        return this;
    }

    public final Term getLeadingTerm() {
        return this.terms.get(this.terms.lastKey());
    }
}

