/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.RationalAlgebraicExpression;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;

public class Power
implements Comparable<Power>,
Cloneable,
RationalAlgebraicExpression {
    public static final String VERSION_NUM = "1.00";
    protected Variable variable;
    protected int exponent;

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setExponent(int exponent) {
        this.exponent = exponent;
    }

    public int getExponent() {
        return this.exponent;
    }

    public long getIndex() {
        return this.variable.getIndex();
    }

    public short getVarType() {
        return this.variable.getVariableType();
    }

    public Power(Variable var, int exponent) {
        this.variable = var;
        this.exponent = exponent;
    }

    public Power(short varType, long index, int exponent) {
        if (varType == 0 || varType == 1) {
            this.variable = new UXVariable(varType, index);
        } else if (varType == 2 || varType == 3) {
            this.variable = new SymbolicVariable(varType, index);
        }
        this.exponent = exponent;
    }

    public Power clone() {
        Power p = new Power(this.variable.clone(), this.exponent);
        return p;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Power)) {
            return false;
        }
        Power p = (Power)obj;
        return this.variable.equals(p.getVariable()) && this.exponent == p.getExponent();
    }

    public String toString() {
        short varType = this.getVarType();
        if (varType == 2 || varType == 3) {
            SymbolicVariable sv = (SymbolicVariable)this.variable;
            return "[Power object: variable type = " + varType + " label = " + sv.getPointLabel() + " exponent = " + this.exponent + "]";
        }
        return "[Power object: variable type = " + varType + " index = " + this.getIndex() + " exponent = " + this.exponent + "]";
    }

    @Override
    public int compareTo(Power p) {
        int result = 0;
        if (p == null) {
            OpenGeoProver.settings.getLogger().error("Null power passed in.");
            return -2;
        }
        result = this.getVarType() == p.getVarType() ? (this.getIndex() < p.getIndex() ? -1 : (this.getIndex() > p.getIndex() ? 1 : (this.exponent < p.getExponent() ? -1 : (this.exponent > p.getExponent() ? 1 : 0)))) : this.getVarType() - p.getVarType();
        return result;
    }

    public Power mul(Power p) {
        if (p == null) {
            OpenGeoProver.settings.getLogger().error("Null pointer passed in.");
            return null;
        }
        if (this.getVarType() == p.getVarType() && this.getIndex() == p.getIndex()) {
            this.exponent += p.getExponent();
        }
        return this;
    }

    public void addToExponent(int exp) {
        this.exponent += exp;
    }

    @Override
    public String printToLaTeX() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.variable.printToLaTeX());
        if (this.exponent > 1) {
            sb.append("^{");
            sb.append(this.exponent + "");
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public String printToXML() {
        String closingTag;
        StringBuilder sb = new StringBuilder();
        short varType = this.variable.getVariableType();
        if (varType == 0) {
            sb.append("<proof_upow>");
            closingTag = "</proof_upow>";
        } else if (varType == 1) {
            sb.append("<proof_xpow>");
            closingTag = "</proof_xpow>";
        } else {
            sb.append("<proof_pow>");
            closingTag = "</proof_pow>";
        }
        sb.append(this.variable.printToXML());
        sb.append("<proof_exp>");
        if (this.exponent > 1) {
            sb.append(this.exponent + "");
        }
        sb.append("</proof_exp>");
        sb.append(closingTag);
        return sb.toString();
    }

    @Override
    public String print() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.variable.print());
        if (this.exponent > 1) {
            sb.append("^");
            sb.append(this.exponent);
        }
        return sb.toString();
    }
}

