/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Polynomial;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.UTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class SymbolicPolynomial
extends Polynomial {
    public static final String VERSION_NUM = "1.00";
    public static final int FIRST_DERIVATIVE_NUMERATOR = 0;
    public static final int FIRST_DERIVATIVE_DENOMINATOR = 1;

    @Override
    public int getType() {
        return 3;
    }

    public SymbolicPolynomial() {
        this.terms = new TreeMap();
    }

    public SymbolicPolynomial(double cf) {
        SymbolicTerm singleTerm = new SymbolicTerm(cf);
        this.terms = new TreeMap();
        this.terms.put(singleTerm, singleTerm);
    }

    @Override
    public Polynomial clone() {
        Collection col = this.terms.values();
        Iterator termIT = col.iterator();
        SymbolicPolynomial c = new SymbolicPolynomial();
        while (termIT.hasNext()) {
            Term ct = ((Term)termIT.next()).clone();
            c.getTerms().put(ct, ct);
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Term> list = this.getTermsAsDescList();
        int size = list.size();
        if (size == 0) {
            sb.append("[SymbPolynomial object: zero polynomial]");
        } else {
            sb.append("[SymbPolynomial object: <terms in descending order>\n");
            for (int ii = 0; ii < size; ++ii) {
                sb.append("\t" + list.get(ii).toString() + "\n");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String printToLaTeX() {
        StringBuilder sb = new StringBuilder();
        boolean firstTerm = true;
        ArrayList<Term> list = this.getTermsAsDescList();
        int size = list.size();
        int chunkSize = 0;
        int newChunkSize = 0;
        for (int ii = 0; ii < size; ++ii) {
            Term t = list.get(ii);
            String latexTerm = t.printToLaTeX();
            int len = latexTerm.length();
            newChunkSize = chunkSize + len;
            if (latexTerm.startsWith("??")) {
                return "??";
            }
            if (!firstTerm && ((SymbolicTerm)t).getCoeff() > 0.0) {
                sb.append("+");
            }
            if (newChunkSize > 90) {
                if (!firstTerm) {
                    sb.append("$$");
                }
                sb.append(latexTerm);
                chunkSize = len;
            } else {
                sb.append(latexTerm);
                chunkSize = newChunkSize;
            }
            if (!firstTerm) continue;
            firstTerm = false;
        }
        return sb.toString();
    }

    @Override
    public String printToXML() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Term> list = this.getTermsAsDescList();
        if (list.size() > 255) {
            return "??";
        }
        sb.append("<proof_spoly>");
        boolean firstTerm = true;
        int jj = list.size();
        for (int ii = 0; ii < jj; ++ii) {
            SymbolicTerm st = (SymbolicTerm)list.get(ii);
            String xmlTerm = st.printToXML();
            if (xmlTerm.startsWith("??")) {
                return "??";
            }
            if (firstTerm) {
                if (st.getCoeff() >= 0.0) {
                    sb.append(xmlTerm.substring(0, xmlTerm.indexOf("<proof_sign>")));
                    sb.append(xmlTerm.substring(xmlTerm.indexOf("</proof_sign>") + 13));
                } else {
                    sb.append(xmlTerm);
                }
                firstTerm = false;
                continue;
            }
            sb.append(xmlTerm);
        }
        sb.append("</proof_spoly>");
        String xmlText = sb.toString();
        if (xmlText.length() > 50000) {
            return "??";
        }
        return xmlText;
    }

    @Override
    public String print() {
        StringBuilder sb = new StringBuilder();
        boolean firstTerm = true;
        ArrayList<Term> list = this.getTermsAsDescList();
        int size = list.size();
        for (int ii = 0; ii < size; ++ii) {
            Term t = list.get(ii);
            String stringTerm = t.print();
            if (stringTerm.startsWith("...")) {
                return "...";
            }
            if (!firstTerm && ((UTerm)t).getCoeff() > 0.0) {
                sb.append("+");
            }
            sb.append(stringTerm);
            if (!firstTerm) continue;
            firstTerm = false;
        }
        String stringPoly = sb.toString();
        if (stringPoly.length() > 2000) {
            return "...";
        }
        return stringPoly;
    }

    private SymbolicPolynomial simplify(ArrayList<Term> unsortedListOfTerms) {
        this.terms = new TreeMap();
        for (Term symTerm : unsortedListOfTerms) {
            SymbolicTerm newSymTerm = new SymbolicTerm(((SymbolicTerm)symTerm).getCoeff());
            for (Power symPower : symTerm.getPowers()) {
                newSymTerm.addPower(symPower.clone());
            }
            this.addTerm(newSymTerm);
        }
        return this;
    }

    public SymbolicPolynomial substitute(Map<String, String> labelsMap) {
        ArrayList<Term> tempListOfTerms = new ArrayList<Term>();
        for (Term t : this.getTermsAsDescList()) {
            tempListOfTerms.add(t.clone());
        }
        for (Term t : tempListOfTerms) {
            for (Power p : t.getPowers()) {
                SymbolicVariable sv = (SymbolicVariable)p.getVariable();
                String replacementLabel = labelsMap.get(sv.getPointLabel());
                if (replacementLabel != null) {
                    sv.setPointLabel(replacementLabel);
                    continue;
                }
                OpenGeoProver.settings.getLogger().error("Failed to substitute label " + sv.getPointLabel());
                return null;
            }
        }
        return this.simplify(tempListOfTerms);
    }

    public SymbolicPolynomial substitute(String destLabel, String srcLabel) {
        if (destLabel == null || srcLabel == null) {
            OpenGeoProver.settings.getLogger().error("Null label passed in");
            return null;
        }
        ArrayList<Term> tempListOfTerms = new ArrayList<Term>();
        for (Term t : this.getTermsAsDescList()) {
            tempListOfTerms.add(t.clone());
        }
        for (Term t : tempListOfTerms) {
            for (Power p : t.getPowers()) {
                SymbolicVariable sv = (SymbolicVariable)p.getVariable();
                if (!sv.getPointLabel().equals(srcLabel)) continue;
                sv.setPointLabel(destLabel);
            }
        }
        return this.simplify(tempListOfTerms);
    }

    public ArrayList<SymbolicPolynomial> calcFirstDerivativeByPoint(String pointLabel) {
        ArrayList<SymbolicPolynomial> retArr = new ArrayList<SymbolicPolynomial>();
        SymbolicPolynomial numerator = new SymbolicPolynomial();
        SymbolicPolynomial denominator = new SymbolicPolynomial();
        SymbolicTerm numeratorPart = null;
        SymbolicTerm denominatorPart = null;
        SymbolicTerm commonPart = null;
        Power xPower = null;
        Power yPower = null;
        for (Term term : this.getTermsAsDescList()) {
            SymbolicTerm symbTerm = (SymbolicTerm)term;
            commonPart = (SymbolicTerm)symbTerm.clone();
            xPower = null;
            yPower = null;
            for (Power pow : symbTerm.getPowers()) {
                SymbolicVariable symbVar = (SymbolicVariable)pow.getVariable();
                SymbolicTerm tempTerm = null;
                if (!symbVar.getPointLabel().equals(pointLabel)) continue;
                tempTerm = new SymbolicTerm(1.0);
                if (symbVar.getVariableType() == 2) {
                    xPower = pow.clone();
                    tempTerm.addPower(xPower);
                } else if (symbVar.getVariableType() == 3) {
                    yPower = pow.clone();
                    tempTerm.addPower(yPower);
                }
                commonPart.divide(tempTerm);
            }
            if (xPower == null) {
                if (yPower == null) continue;
                int yExp = yPower.getExponent();
                commonPart.mul(yExp);
                if (yExp > 1) {
                    yPower.addToExponent(-1);
                    commonPart.addPower(yPower);
                }
                denominator.addTerm(commonPart);
                continue;
            }
            if (yPower == null) {
                int xExp = xPower.getExponent();
                commonPart.mul(xExp);
                if (xExp > 1) {
                    xPower.addToExponent(-1);
                    commonPart.addPower(xPower);
                }
                numerator.addTerm(commonPart);
                continue;
            }
            Power tempPower = xPower.clone();
            numeratorPart = (SymbolicTerm)commonPart.clone();
            numeratorPart.addPower(yPower.clone());
            int xExp = tempPower.getExponent();
            numeratorPart.mul(xExp);
            if (xExp > 1) {
                tempPower.addToExponent(-1);
                numeratorPart.addPower(tempPower);
            }
            numerator.addTerm(numeratorPart);
            tempPower = yPower.clone();
            denominatorPart = (SymbolicTerm)commonPart.clone();
            denominatorPart.addPower(xPower.clone());
            int yExp = tempPower.getExponent();
            denominatorPart.mul(yExp);
            if (yExp > 1) {
                tempPower.addToExponent(-1);
                denominatorPart.addPower(tempPower);
            }
            denominator.addTerm(denominatorPart);
        }
        numerator.multiplyByRealConstant(-1.0);
        retArr.add(0, numerator);
        retArr.add(1, denominator);
        return retArr;
    }

    public ArrayList<String> getAllPointLabels() {
        HashMap<String, String> allLabelsMap = new HashMap<String, String>();
        for (Term t : this.getTermsAsDescList()) {
            for (Power p : t.getPowers()) {
                SymbolicVariable sv = (SymbolicVariable)p.getVariable().clone();
                allLabelsMap.put(sv.getPointLabel(), sv.getPointLabel());
            }
        }
        return new ArrayList<String>(allLabelsMap.values());
    }
}

