/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.Term;
import com.ogprover.utilities.OGPUtilities;
import java.util.Vector;

public class SymbolicTerm
extends Term {
    public static final String VERSION_NUM = "1.00";
    private double coeff;

    public void setCoeff(double coeff) {
        this.coeff = coeff;
    }

    public double getCoeff() {
        return this.coeff;
    }

    @Override
    public int getType() {
        return 3;
    }

    public SymbolicTerm(double coeff) {
        this.coeff = coeff;
        this.powers = new Vector();
    }

    @Override
    public Term clone() {
        SymbolicTerm c = new SymbolicTerm(this.coeff);
        int size = this.powers.size();
        for (int ii = 0; ii < size; ++ii) {
            c.getPowers().addElement(((Power)this.powers.get(ii)).clone());
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int ii = 0;
        int size = this.powers.size();
        long wholeCoeffPart = 0L;
        double diff = 0.0;
        if (this.coeff > -1.0E-6 && this.coeff < 1.0E-6) {
            return "[SymbTerm object: coefficient = 0]";
        }
        sb.append("[SymbTerm object: coefficient = ");
        wholeCoeffPart = Math.round(this.coeff);
        diff = this.coeff - (double)wholeCoeffPart;
        if (diff > -1.0E-6 && diff < 1.0E-6) {
            sb.append(wholeCoeffPart + "");
        } else {
            sb.append(this.coeff + "");
        }
        sb.append(" vector of powers = [\n");
        while (ii < size) {
            sb.append("\t" + ((Power)this.powers.get(ii)).toString());
            sb.append("\n");
            ++ii;
        }
        sb.append("]]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SymbolicTerm)) {
            return false;
        }
        SymbolicTerm st = (SymbolicTerm)obj;
        return this.compareTo(st) == 0;
    }

    @Override
    public Term merge(Term t) {
        this.coeff += t != null ? ((SymbolicTerm)t).getCoeff() : 0.0;
        return this;
    }

    @Override
    public Term mul(Term t) {
        this.coeff *= t != null ? ((SymbolicTerm)t).getCoeff() : 0.0;
        this.mergePowers(t, true);
        return this;
    }

    @Override
    public Term mul(double r) {
        this.coeff *= r;
        return this;
    }

    @Override
    public Term divide(Term t) {
        double d;
        double d2 = d = t != null ? ((SymbolicTerm)t).getCoeff() : 0.0;
        if (d < 1.0E-6 && d > -1.0E-6) {
            return null;
        }
        this.coeff /= d;
        this.mergePowers(t, false);
        return this;
    }

    @Override
    public Term invert() {
        this.coeff *= -1.0;
        return this;
    }

    @Override
    public boolean isZero() {
        return this.coeff > -1.0E-6 && this.coeff < 1.0E-6;
    }

    @Override
    public String printToLaTeX() {
        int size = this.powers.size();
        int ii = 0;
        StringBuilder sb = new StringBuilder();
        double coeffSqr = this.coeff * this.coeff;
        double decrCoeffSqr = coeffSqr - 1.0;
        double incrCoeff = this.coeff + 1.0;
        long wholeCoeffPart = 0L;
        double diff = 0.0;
        if (this.coeff > -1.0E-6 && this.coeff < 1.0E-6) {
            return "";
        }
        if (size == 0 || decrCoeffSqr <= -1.0E-6 || decrCoeffSqr >= 1.0E-6) {
            wholeCoeffPart = Math.round(this.coeff);
            diff = this.coeff - (double)wholeCoeffPart;
            if (diff > -1.0E-6 && diff < 1.0E-6) {
                sb.append(wholeCoeffPart + "");
            } else {
                sb.append(OGPUtilities.roundUpToPrecision(this.coeff) + "");
            }
        } else if (incrCoeff > -1.0E-6 && incrCoeff < 1.0E-6) {
            sb.append("-");
        }
        while (ii < size) {
            sb.append(((Power)this.powers.get(ii)).printToLaTeX());
            ++ii;
        }
        String latexTerm = sb.toString();
        if (latexTerm.length() > 90) {
            return "??";
        }
        return latexTerm;
    }

    @Override
    public String printToXML() {
        int size = this.powers.size();
        int ii = 0;
        StringBuilder sb = new StringBuilder();
        double coeffSqr = this.coeff * this.coeff;
        double decrCoeffSqr = coeffSqr - 1.0;
        long wholeCoeffPart = 0L;
        double diff = 0.0;
        if (this.coeff > -1.0E-6 && this.coeff < 1.0E-6) {
            return "";
        }
        sb.append("<proof_sterm>");
        if (this.coeff < 0.0) {
            sb.append("<proof_sign> - </proof_sign>");
        } else {
            sb.append("<proof_sign> + </proof_sign>");
        }
        if (size == 0 || decrCoeffSqr <= -1.0E-6 || decrCoeffSqr >= 1.0E-6) {
            sb.append("<proof_coeff>");
            double absCoeff = Math.abs(this.coeff);
            wholeCoeffPart = Math.round(absCoeff);
            diff = absCoeff - (double)wholeCoeffPart;
            if (diff > -1.0E-6 && diff < 1.0E-6) {
                sb.append(wholeCoeffPart + "");
            } else {
                sb.append(OGPUtilities.roundUpToPrecision(absCoeff) + "");
            }
            sb.append("</proof_coeff>");
        }
        while (ii < size) {
            sb.append(((Power)this.powers.get(ii)).printToXML());
            ++ii;
        }
        sb.append("</proof_sterm>");
        String xmlTerm = sb.toString();
        if (xmlTerm.length() > 50000) {
            return "??";
        }
        return xmlTerm;
    }

    @Override
    public String print() {
        int size = this.powers.size();
        int ii = 0;
        StringBuilder sb = new StringBuilder();
        double coeffSqr = this.coeff * this.coeff;
        double decrCoeffSqr = coeffSqr - 1.0;
        double incrCoeff = this.coeff + 1.0;
        long wholeCoeffPart = 0L;
        double diff = 0.0;
        if (this.coeff > -1.0E-6 && this.coeff < 1.0E-6) {
            return "";
        }
        if (size == 0 || decrCoeffSqr <= -1.0E-6 || decrCoeffSqr >= 1.0E-6) {
            wholeCoeffPart = Math.round(this.coeff);
            diff = this.coeff - (double)wholeCoeffPart;
            if (diff > -1.0E-6 && diff < 1.0E-6) {
                sb.append(wholeCoeffPart);
            } else {
                sb.append(OGPUtilities.roundUpToPrecision(this.coeff));
            }
        } else if (incrCoeff > -1.0E-6 && incrCoeff < 1.0E-6) {
            sb.append("-");
        }
        while (ii < size) {
            sb.append(((Power)this.powers.get(ii)).print());
            ++ii;
        }
        String stringTerm = sb.toString();
        if (stringTerm.length() > 2000) {
            return "...";
        }
        return stringTerm;
    }

    public int getVectorIndexOfVarIndex(int varIndex) {
        return -1;
    }

    public Power getPowerOfVarIndex(int varIndex) {
        return null;
    }

    @Override
    public Term changePowerExponent(int varIndex, int expInc) {
        return null;
    }
}

