/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.RationalAlgebraicExpression;
import com.ogprover.utilities.logger.ILogger;
import java.util.Vector;

public abstract class Term
implements Comparable<Term>,
Cloneable,
RationalAlgebraicExpression {
    public static final String VERSION_NUM = "1.00";
    public static final short TERM_TYPE_UTERM = 1;
    public static final short TERM_TYPE_XTERM = 2;
    public static final short TERM_TYPE_SYMBOLIC = 3;
    protected Vector<Power> powers;

    public abstract Term clone();

    public abstract int getType();

    public abstract Term merge(Term var1);

    public abstract Term mul(Term var1);

    public abstract Term mul(double var1);

    public abstract Term divide(Term var1);

    public abstract Term invert();

    public abstract boolean isZero();

    public Vector<Power> getPowers() {
        return this.powers;
    }

    @Override
    public int compareTo(Term t) {
        int size = this.powers.size();
        int tsize = t != null ? t.getPowers().size() : 0;
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (t == null) {
            logger.error("Null term passed in.");
            return -2;
        }
        if (this.getType() != t.getType()) {
            return this.getType() - t.getType();
        }
        for (int ii = 0; ii < size && ii < tsize; ++ii) {
            Power p = this.powers.get(ii);
            Power q = t.getPowers().get(ii);
            if (p == null || q == null) {
                logger.error("Found null object(s) when expected non-null value");
                return -2;
            }
            int cmp = p.compareTo(q);
            if (cmp == 0) continue;
            return cmp;
        }
        return size < tsize ? -1 : (size > tsize ? 1 : 0);
    }

    public void addPower(Power p) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (this.getType() == 1 && p.getVarType() == 0 || this.getType() == 2 && p.getVarType() == 1 || this.getType() == 3 && (p.getVarType() == 2 || p.getVarType() == 3)) {
            int left = 0;
            int right = this.powers.size() - 1;
            int middle = 0;
            Power middleP = null;
            long middleIndex = 0L;
            long pIndex = p.getIndex();
            int pExp = p.getExponent();
            while (left <= right) {
                middle = left + right >> 1;
                middleP = this.powers.get(middle);
                if (middleP == null) {
                    logger.error("Found null object in collection, while in binary search algorithm in addPower() method.");
                    break;
                }
                middleIndex = middleP.getIndex();
                if (middleIndex == pIndex) {
                    middleP.addToExponent(pExp);
                    break;
                }
                if (middleIndex < pIndex) {
                    right = middle - 1;
                    continue;
                }
                left = middle + 1;
            }
            if (left > right) {
                this.powers.insertElementAt(p, left);
            }
        } else {
            logger.warn("Attempting to add power of another variable type.");
        }
    }

    public void mergePowers(Term t, boolean add) {
        int size = this.powers.size();
        int tsize = t != null ? t.getPowers().size() : 0;
        int ii = 0;
        int jj = 0;
        int op = add ? 1 : -1;
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (t == null) {
            return;
        }
        if (this.getType() != t.getType()) {
            logger.warn("Attempt to merge two terms of different types.");
            return;
        }
        while (ii < size && jj < tsize) {
            long pjInd;
            Power pi = this.powers.get(ii);
            Power pj = t.getPowers().get(jj);
            if (pi == null || pj == null) {
                logger.error("Null object(s) read from collection");
                return;
            }
            long piInd = pi.getIndex();
            if (piInd == (pjInd = pj.getIndex())) {
                int resultExp = pi.getExponent() + op * pj.getExponent();
                if (resultExp < 0) {
                    resultExp = 0;
                }
                if (resultExp == 0) {
                    this.powers.remove(ii);
                    --size;
                    ++jj;
                    continue;
                }
                pi.setExponent(resultExp);
                ++ii;
                ++jj;
                continue;
            }
            if (piInd < pjInd) {
                if (add) {
                    this.powers.add(ii, pj.clone());
                    ++size;
                    ++ii;
                    ++jj;
                    continue;
                }
                ++jj;
                continue;
            }
            ++ii;
        }
        while (jj < tsize) {
            Power pj = t.getPowers().get(jj);
            this.powers.addElement(pj.clone());
            ++jj;
        }
    }

    public final boolean isDivisibleByTerm(Term t) {
        boolean result = true;
        boolean readI = true;
        boolean readJ = true;
        int ii = 0;
        int jj = 0;
        long piIndex = 0L;
        long pjIndex = 0L;
        int size = this.powers.size();
        int tsize = t != null ? t.getPowers().size() : 0;
        Power pi = null;
        Power pj = null;
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (t == null) {
            logger.error("Null term passed in.");
            return false;
        }
        if (this.getType() != t.getType()) {
            logger.error("Terms must be of same type.");
            return false;
        }
        if (tsize == 0) {
            return true;
        }
        if (size == 0) {
            return false;
        }
        if (tsize > size) {
            return false;
        }
        while (ii < size && jj < tsize) {
            if (readI) {
                pi = this.powers.get(ii);
                if (pi == null) {
                    logger.error("Found null object when expected non-null value");
                    return false;
                }
                piIndex = pi.getIndex();
                readI = false;
            }
            if (readJ) {
                pj = this.powers.get(jj);
                if (pj == null) {
                    logger.error("Found null object when expected non-null value");
                    return false;
                }
                pjIndex = pj.getIndex();
                readJ = false;
            }
            if (piIndex == pjIndex) {
                if (pi.getExponent() < pj.getExponent()) {
                    result = false;
                    break;
                }
                ++ii;
                readI = true;
                ++jj;
                readJ = true;
                continue;
            }
            if (piIndex > pjIndex) {
                ++ii;
                readI = true;
                continue;
            }
            result = false;
            break;
        }
        if (jj < tsize) {
            result = false;
        }
        return result;
    }

    public int getVectorIndexOfVarIndex(long varIndex) {
        int left = 0;
        int right = this.powers.size() - 1;
        int middle = 0;
        long midVarIndex = 0L;
        Power midP = null;
        while (left <= right) {
            middle = left + right >> 1;
            midP = this.powers.get(middle);
            if (midP == null) {
                OpenGeoProver.settings.getLogger().error("Found null object");
                return -1;
            }
            midVarIndex = midP.getIndex();
            if (midVarIndex == varIndex) {
                return middle;
            }
            if (midVarIndex < varIndex) {
                right = middle - 1;
                continue;
            }
            left = middle + 1;
        }
        return -1;
    }

    public Power getPowerOfVarIndex(long varIndex) {
        int left = 0;
        int right = this.powers.size() - 1;
        int middle = 0;
        long midVarIndex = 0L;
        Power midP = null;
        while (left <= right) {
            middle = left + right >> 1;
            midP = this.powers.get(middle);
            if (midP == null) {
                OpenGeoProver.settings.getLogger().error("Found null object");
                return null;
            }
            midVarIndex = midP.getIndex();
            if (midVarIndex == varIndex) {
                return midP;
            }
            if (midVarIndex < varIndex) {
                right = middle - 1;
                continue;
            }
            left = middle + 1;
        }
        return null;
    }

    public Term changePowerExponent(int varIndex, int expInc) {
        int ii;
        if (expInc != 0 && (ii = this.getVectorIndexOfVarIndex(varIndex)) >= 0) {
            Power pi = this.powers.get(ii);
            if (pi == null) {
                OpenGeoProver.settings.getLogger().error("Null object found when expected non-null value");
                return null;
            }
            pi.addToExponent(expInc);
            if (pi.getExponent() == 0) {
                this.powers.remove(ii);
            }
        }
        return this;
    }

    public final int getVariableExponent(int varIndex) {
        Power p = this.getPowerOfVarIndex(varIndex);
        if (p == null) {
            return 0;
        }
        return p.getExponent();
    }

    public final Term gcd(Term t) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        Term thisBeforeChange = this.clone();
        this.powers = new Vector();
        if (t == null) {
            logger.error("Null term passed in");
            return null;
        }
        if (this.getType() != t.getType()) {
            logger.error("Terms must be of same type in gcd() method");
            return null;
        }
        int size1 = thisBeforeChange.getPowers().size();
        int size2 = t.getPowers().size();
        int ii = 0;
        int jj = 0;
        boolean readI = true;
        boolean readJ = true;
        Power pi = null;
        Power pj = null;
        long piIndex = 0L;
        long pjIndex = 0L;
        int piExp = 0;
        int pjExp = 0;
        while (ii < size1 && jj < size2) {
            if (readI) {
                pi = thisBeforeChange.getPowers().get(ii);
                if (pi == null) {
                    logger.error("Found null object when expected non-null value");
                    return null;
                }
                piIndex = pi.getIndex();
                piExp = pi.getExponent();
                readI = false;
            }
            if (readJ) {
                pj = t.getPowers().get(jj);
                if (pj == null) {
                    logger.error("Found null object when expected non-null value");
                    return null;
                }
                pjIndex = pj.getIndex();
                pjExp = pj.getExponent();
                readJ = false;
            }
            if (piIndex == pjIndex) {
                int resExp;
                int n = resExp = piExp <= pjExp ? piExp : pjExp;
                if (resExp > 0) {
                    Power p = new Power(pi.getVarType(), piIndex, resExp);
                    this.powers.addElement(p);
                }
                ++ii;
                readI = true;
                ++jj;
                readJ = true;
                continue;
            }
            if (piIndex < pjIndex) {
                ++jj;
                readJ = true;
                continue;
            }
            ++ii;
            readI = true;
        }
        return this;
    }
}

