/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.polynomials.RationalAlgebraicExpression;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.UPolynomial;
import com.ogprover.polynomials.UTerm;
import java.util.Collection;
import java.util.Iterator;

public class UFraction
implements Cloneable,
RationalAlgebraicExpression {
    public static final String VERSION_NUM = "1.00";
    private UPolynomial numerator;
    private UPolynomial denominator;

    public UPolynomial getNumerator() {
        return this.numerator;
    }

    public void setNumerator(UPolynomial numerator) {
        this.numerator = numerator;
    }

    public UPolynomial getDenominator() {
        return this.denominator;
    }

    public void setDenominator(UPolynomial denominator) {
        this.denominator = denominator;
    }

    public UFraction(UPolynomial num, UPolynomial den) {
        this.numerator = num;
        this.denominator = den;
    }

    public UFraction(UPolynomial p) {
        this.numerator = p;
        this.denominator = new UPolynomial(1.0);
    }

    public UFraction(double d) {
        this.numerator = new UPolynomial(d);
        this.denominator = new UPolynomial(1.0);
    }

    public UFraction clone() {
        return new UFraction((UPolynomial)this.numerator.clone(), (UPolynomial)this.denominator.clone());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[UFraction object:\n Numerator = [");
        sb.append(this.numerator.toString());
        sb.append("];\n Denominator = [");
        sb.append(this.denominator.toString());
        sb.append("]\n]");
        return sb.toString();
    }

    public static boolean isValid(UFraction uf) {
        return !uf.getDenominator().isZero();
    }

    public boolean isZero() {
        return this.numerator.isZero();
    }

    public UFraction reduce() {
        if (this.numerator.getTerms().size() == 0 || this.denominator.getTerms().size() == 0) {
            return this;
        }
        Collection<Term> colNum = this.numerator.getTerms().values();
        Iterator<Term> itNum = colNum.iterator();
        Collection<Term> colDen = this.denominator.getTerms().values();
        Iterator<Term> itDen = colDen.iterator();
        boolean isFirst = true;
        Term gcdTerm = null;
        while (itNum.hasNext() && (isFirst || gcdTerm != null && gcdTerm.getPowers().size() > 0)) {
            if (isFirst) {
                gcdTerm = (UTerm)itNum.next().clone();
                ((UTerm)gcdTerm).setCoeff(1.0);
                isFirst = false;
                continue;
            }
            gcdTerm.gcd(itNum.next());
        }
        while (itDen.hasNext() && gcdTerm != null && gcdTerm.getPowers().size() > 0) {
            gcdTerm.gcd(itDen.next());
        }
        if (gcdTerm.getPowers().size() > 0) {
            itNum = colNum.iterator();
            while (itNum.hasNext()) {
                itNum.next().divide(gcdTerm);
            }
            itDen = colDen.iterator();
            while (itDen.hasNext()) {
                itDen.next().divide(gcdTerm);
            }
        }
        if (this.denominator.getTerms().size() == 1) {
            UTerm ut = (UTerm)this.denominator.getTerms().get(this.denominator.getTerms().firstKey());
            UTerm utn = (UTerm)this.numerator.getTerms().get(this.numerator.getTerms().firstKey());
            if (ut.getPowers().size() == 0 && (this.numerator.getTerms().size() != 1 || utn.getPowers().size() != 0)) {
                itNum = colNum.iterator();
                while (itNum.hasNext()) {
                    itNum.next().mul(1.0 / ut.getCoeff());
                }
                ut.setCoeff(1.0);
            }
        }
        return this;
    }

    public UFraction add(UFraction uf) {
        this.numerator.multiplyByPolynomial(uf.getDenominator()).addPolynomial(uf.getNumerator().clone().multiplyByPolynomial(this.denominator));
        this.denominator.multiplyByPolynomial(uf.getDenominator());
        return this;
    }

    public UFraction invertSign() {
        this.numerator.invert();
        return this;
    }

    public UFraction invertFraction() {
        UPolynomial oldNum = this.numerator;
        this.numerator = this.denominator;
        this.denominator = oldNum;
        return this;
    }

    public UFraction subtract(UFraction uf) {
        return this.add(uf.clone().invertSign());
    }

    public UFraction mul(UFraction uf) {
        if (this.isZero()) {
            return this;
        }
        if (uf.isZero()) {
            this.numerator = new UPolynomial();
            UTerm ut = new UTerm(1.0);
            this.denominator = new UPolynomial();
            this.denominator.addTerm(ut);
            return this;
        }
        this.numerator.multiplyByPolynomial(uf.getNumerator());
        this.denominator.multiplyByPolynomial(uf.getDenominator());
        return this;
    }

    public UFraction mul(UPolynomial up) {
        if (this.isZero()) {
            return this;
        }
        if (up.isZero()) {
            this.numerator = new UPolynomial();
            UTerm ut = new UTerm(1.0);
            this.denominator = new UPolynomial();
            this.denominator.addTerm(ut);
            return this;
        }
        this.numerator.multiplyByPolynomial(up);
        return this;
    }

    public UFraction mul(double d) {
        if (this.isZero()) {
            return this;
        }
        if (d > -1.0E-6 && d < 1.0E-6) {
            this.numerator = new UPolynomial();
            UTerm ut = new UTerm(1.0);
            this.denominator = new UPolynomial();
            this.denominator.addTerm(ut);
            return this;
        }
        this.numerator.multiplyByRealConstant(d);
        return this;
    }

    public boolean isSingleNegativeTerm() {
        UTerm ut;
        double coeffDiff;
        boolean isDenOne = false;
        if (this.denominator.getTerms().size() == 1 && (coeffDiff = (ut = (UTerm)this.denominator.getTerms().get(this.denominator.getTerms().firstKey())).getCoeff() - 1.0) > -1.0E-6 && coeffDiff < 1.0E-6 && ut.getPowers().size() == 0) {
            isDenOne = true;
        }
        if (isDenOne && this.numerator.getTerms().size() == 1) {
            ut = (UTerm)this.numerator.getTerms().get(this.numerator.getTerms().firstKey());
            return ut.getCoeff() < 0.0;
        }
        return false;
    }

    @Override
    public String printToLaTeX() {
        UTerm ut;
        double coeffDiff;
        StringBuilder sb = new StringBuilder();
        boolean isDenOne = false;
        if (this.denominator.getTerms().size() == 1 && (coeffDiff = (ut = (UTerm)this.denominator.getTerms().get(this.denominator.getTerms().firstKey())).getCoeff() - 1.0) > -1.0E-6 && coeffDiff < 1.0E-6 && ut.getPowers().size() == 0) {
            isDenOne = true;
        }
        String latexNum = this.numerator.printToLaTeX();
        if (isDenOne) {
            if (latexNum.startsWith("??")) {
                return "??";
            }
            if (this.numerator.getTerms().size() > 1) {
                sb.append("(");
                sb.append(latexNum);
                sb.append(")");
            } else {
                double uCoeffDiff;
                UTerm ut2 = (UTerm)this.numerator.getTerms().get(this.numerator.getTerms().firstKey());
                double uCoeff = ut2.getCoeff();
                double d = uCoeffDiff = uCoeff > 0.0 ? uCoeff - 1.0 : uCoeff + 1.0;
                if (ut2.getPowers().size() == 0 && uCoeffDiff > -1.0E-6 && uCoeffDiff < 1.0E-6) {
                    if (uCoeff < 0.0) {
                        sb.append("-");
                    }
                } else {
                    sb.append(latexNum);
                }
            }
        } else {
            String latexDen = this.denominator.printToLaTeX();
            if (latexNum.length() > 90 || latexDen.length() > 90) {
                return "??";
            }
            sb.append("\\frac{");
            sb.append(latexNum);
            sb.append("}{");
            sb.append(latexDen);
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public String printToXML() {
        String xmlNum;
        UTerm ut;
        double coeffDiff;
        StringBuilder sb = new StringBuilder();
        boolean isDenOne = false;
        sb.append("<proof_ufrac>");
        if (this.denominator.getTerms().size() == 1 && (coeffDiff = (ut = (UTerm)this.denominator.getTerms().get(this.denominator.getTerms().firstKey())).getCoeff() - 1.0) > -1.0E-6 && coeffDiff < 1.0E-6 && ut.getPowers().size() == 0) {
            isDenOne = true;
        }
        if ((xmlNum = this.numerator.printToXML()).startsWith("??")) {
            return "??";
        }
        if (isDenOne) {
            sb.append("<proof_ufrac_num>");
            if (this.numerator.getTerms().size() > 1) {
                sb.append("<proof_lbrac></proof_lbrac>");
                sb.append(xmlNum);
                sb.append("<proof_rbrac></proof_rbrac>");
            } else {
                sb.append(xmlNum);
            }
            sb.append("</proof_ufrac_num>");
        } else {
            String xmlDen = this.denominator.printToXML();
            if (xmlDen.startsWith("??")) {
                return "??";
            }
            sb.append("<proof_ufrac_num>");
            sb.append("<proof_lbrac></proof_lbrac>");
            sb.append(xmlNum);
            sb.append("<proof_rbrac></proof_rbrac>");
            sb.append("</proof_ufrac_num>");
            sb.append("<proof_slash></proof_slash>");
            sb.append("<proof_ufrac_den>");
            sb.append("<proof_lbrac></proof_lbrac>");
            sb.append(xmlDen);
            sb.append("<proof_rbrac></proof_rbrac>");
            sb.append("</proof_ufrac_den>");
        }
        sb.append("</proof_ufrac>");
        String xmlText = sb.toString();
        if (xmlText.length() > 50000) {
            return "??";
        }
        return xmlText;
    }

    @Override
    public String print() {
        UTerm ut;
        double coeffDiff;
        StringBuilder sb = new StringBuilder();
        boolean isDenOne = false;
        if (this.denominator.getTerms().size() == 1 && (coeffDiff = (ut = (UTerm)this.denominator.getTerms().get(this.denominator.getTerms().firstKey())).getCoeff() - 1.0) > -1.0E-6 && coeffDiff < 1.0E-6 && ut.getPowers().size() == 0) {
            isDenOne = true;
        }
        String stringNum = this.numerator.print();
        if (isDenOne) {
            if (stringNum.startsWith("...")) {
                return "...";
            }
            if (this.numerator.getTerms().size() > 1) {
                sb.append("(");
                sb.append(stringNum);
                sb.append(")");
            } else {
                double uCoeffDiff;
                UTerm ut2 = (UTerm)this.numerator.getTerms().get(this.numerator.getTerms().firstKey());
                double uCoeff = ut2.getCoeff();
                double d = uCoeffDiff = uCoeff > 0.0 ? uCoeff - 1.0 : uCoeff + 1.0;
                if (ut2.getPowers().size() == 0 && uCoeffDiff > -1.0E-6 && uCoeffDiff < 1.0E-6) {
                    if (uCoeff < 0.0) {
                        sb.append("-");
                    }
                } else {
                    sb.append(stringNum);
                }
            }
        } else {
            String stringDen = this.denominator.print();
            if (stringNum.length() > 2000 || stringDen.length() > 2000) {
                return "...";
            }
            sb.append("(");
            sb.append(stringNum);
            sb.append(")");
            sb.append("/");
            if (this.denominator.getTerms().size() > 1) {
                sb.append("(");
                sb.append(stringDen);
                sb.append(")");
            } else {
                sb.append(stringDen);
            }
        }
        return sb.toString();
    }
}

