/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.polynomials.Polynomial;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.UTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;

public class UPolynomial
extends Polynomial {
    public static final String VERSION_NUM = "1.00";

    @Override
    public int getType() {
        return 1;
    }

    public UPolynomial() {
        this.terms = new TreeMap();
    }

    public UPolynomial(double cf) {
        UTerm singleTerm = new UTerm(cf);
        this.terms = new TreeMap();
        this.terms.put(singleTerm, singleTerm);
    }

    @Override
    public Polynomial clone() {
        Collection col = this.terms.values();
        Iterator termIT = col.iterator();
        UPolynomial c = new UPolynomial();
        while (termIT.hasNext()) {
            Term ct = ((Term)termIT.next()).clone();
            c.getTerms().put(ct, ct);
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Term> list = this.getTermsAsDescList();
        int ii = 0;
        int size = list.size();
        if (size == 0) {
            sb.append("[UPolynomial object: zero polynomial]");
        } else {
            sb.append("[UPolynomial object: <terms in descending order>\n");
            while (ii < size) {
                sb.append("\t");
                sb.append(this.getTermsAsDescList().get(ii++).toString());
                sb.append("\n");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public UPolynomial divideByTerm(UTerm ut) {
        for (Term t : this.getTermsAsDescList()) {
            if (((UTerm)t).divide(ut) != null) continue;
            return null;
        }
        return this;
    }

    @Override
    public String printToLaTeX() {
        StringBuilder sb = new StringBuilder();
        boolean firstTerm = true;
        ArrayList<Term> list = this.getTermsAsDescList();
        int size = list.size();
        int chunkSize = 0;
        int newChunkSize = 0;
        if (list.size() > 255) {
            return "??";
        }
        for (int ii = 0; ii < size; ++ii) {
            Term t = list.get(ii);
            String latexTerm = t.printToLaTeX();
            int len = latexTerm.length();
            newChunkSize = chunkSize + len;
            if (latexTerm.startsWith("??")) {
                return "??";
            }
            if (!firstTerm && ((UTerm)t).getCoeff() > 0.0) {
                sb.append("+");
            }
            if (newChunkSize > 90) {
                if (!firstTerm) {
                    sb.append("$$");
                }
                sb.append(latexTerm);
                chunkSize = len;
            } else {
                sb.append(latexTerm);
                chunkSize = newChunkSize;
            }
            if (!firstTerm) continue;
            firstTerm = false;
        }
        return sb.toString();
    }

    @Override
    public String printToXML() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Term> list = this.getTermsAsDescList();
        if (list.size() > 255) {
            return "??";
        }
        sb.append("<proof_upoly>");
        boolean firstTerm = true;
        int jj = list.size();
        for (int ii = 0; ii < jj; ++ii) {
            UTerm ut = (UTerm)list.get(ii);
            String xmlTerm = ut.printToXML();
            if (xmlTerm.startsWith("??")) {
                return "??";
            }
            if (firstTerm) {
                if (ut.getCoeff() >= 0.0) {
                    sb.append(xmlTerm.substring(0, xmlTerm.indexOf("<proof_usign>")));
                    sb.append(xmlTerm.substring(xmlTerm.indexOf("</proof_usign>") + 14));
                } else {
                    sb.append(xmlTerm);
                }
                firstTerm = false;
                continue;
            }
            sb.append(xmlTerm);
        }
        sb.append("</proof_upoly>");
        String xmlText = sb.toString();
        if (xmlText.length() > 50000) {
            return "??";
        }
        return xmlText;
    }

    public boolean isSingleNegativeTerm() {
        if (this.getTerms().size() == 1) {
            UTerm ut = (UTerm)this.getTerms().get(this.getTerms().firstKey());
            return ut.getCoeff() < 0.0;
        }
        return false;
    }

    @Override
    public String print() {
        StringBuilder sb = new StringBuilder();
        boolean firstTerm = true;
        ArrayList<Term> list = this.getTermsAsDescList();
        int size = list.size();
        for (int ii = 0; ii < size; ++ii) {
            Term t = list.get(ii);
            String stringTerm = t.print();
            if (stringTerm.startsWith("...")) {
                return "...";
            }
            if (!firstTerm && ((UTerm)t).getCoeff() > 0.0) {
                sb.append("+");
            }
            sb.append(stringTerm);
            if (!firstTerm) continue;
            firstTerm = false;
        }
        String stringPoly = sb.toString();
        if (stringPoly.length() > 2000) {
            return "...";
        }
        return stringPoly;
    }
}

