/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.RationalAlgebraicExpression;
import com.ogprover.polynomials.SymbolicVariable;

public abstract class Variable
implements Comparable<Variable>,
Cloneable,
RationalAlgebraicExpression {
    public static final String VERSION_NUM = "1.00";
    public static final short VAR_TYPE_UX_U = 0;
    public static final short VAR_TYPE_UX_X = 1;
    public static final short VAR_TYPE_SYMB_X = 2;
    public static final short VAR_TYPE_SYMB_Y = 3;
    protected long index;

    public abstract short getVariableType();

    public abstract Variable clone();

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Variable)) {
            return false;
        }
        Variable v = (Variable)obj;
        return this.getVariableType() == v.getVariableType() && this.index == v.getIndex();
    }

    @Override
    public int compareTo(Variable v) {
        if (v == null) {
            OpenGeoProver.settings.getLogger().error("Null variable passed in.");
            return -2;
        }
        if (this.getVariableType() == v.getVariableType()) {
            if (this.index == v.getIndex()) {
                return 0;
            }
            if (this.index > v.getIndex()) {
                return 1;
            }
            return -1;
        }
        if (this.getVariableType() > v.getVariableType()) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        short varType = this.getVariableType();
        if (varType == 2 || varType == 3) {
            SymbolicVariable sv = (SymbolicVariable)this;
            return "[Variable object: variable type = " + varType + " label = " + sv.getPointLabel() + "]";
        }
        return "[Variable object: variable type = " + varType + " index = " + this.getIndex() + "]";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String printToLaTeX() {
        StringBuilder sb = new StringBuilder();
        short varType = this.getVariableType();
        if (varType == 0 || varType == 1) {
            if (varType == 0 && this.getIndex() == 0L) {
                sb.append("0");
                return sb.toString();
            }
            sb.append(varType == 0 ? "u" : "x");
            sb.append("_{");
            sb.append(this.getIndex() + "");
            sb.append("}");
        } else if (varType == 2 || varType == 3) {
            SymbolicVariable sv = (SymbolicVariable)this;
            sb.append(varType == 2 ? "x" : "y");
            sb.append("_{");
            sb.append(sv.getPointLabel() + "");
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public String printToXML() {
        StringBuilder sb = new StringBuilder();
        short varType = this.getVariableType();
        sb.append("<proof_var>");
        if (varType == 0 || varType == 1) {
            if (varType == 0 && this.getIndex() == 0L) {
                sb.append("<proof_varType>");
                sb.append("0");
                sb.append("</proof_varType>");
                sb.append("<proof_index>");
                sb.append("</proof_index>");
                sb.append("</proof_var>");
                return sb.toString();
            }
            sb.append("<proof_varType>");
            sb.append(varType == 0 ? "u" : "x");
            sb.append("</proof_varType>");
            sb.append("<proof_index>");
            sb.append(this.getIndex() + "");
            sb.append("</proof_index>");
        } else if (varType == 2 || varType == 3) {
            SymbolicVariable sv = (SymbolicVariable)this;
            sb.append("<proof_varType>");
            sb.append(varType == 2 ? "x" : "y");
            sb.append("</proof_varType>");
            sb.append("<proof_index>");
            sb.append(sv.getPointLabel() + "");
            sb.append("</proof_index>");
        }
        sb.append("</proof_var>");
        return sb.toString();
    }

    @Override
    public String print() {
        short varType = this.getVariableType();
        StringBuilder sb = new StringBuilder();
        if (varType == 0 || varType == 1) {
            sb.append(varType == 0 ? "u" : "x");
            sb.append(this.getIndex());
        } else if (varType == 2 || varType == 3) {
            sb.append(varType == 2 ? "x" : "y");
            sb.append(((SymbolicVariable)this).getPointLabel());
        }
        return sb.toString();
    }
}

