/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.polynomials.XTerm;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Vector;

public class XPolySystem {
    public static final String VERSION_NUM = "1.00";
    private Vector<XPolynomial> polynomials = new Vector();
    private Vector<Integer> variableList = null;

    public Vector<XPolynomial> getPolynomials() {
        return this.polynomials;
    }

    public void setPolynomials(Vector<XPolynomial> polynomials) {
        this.polynomials = polynomials;
    }

    public Vector<Integer> getVariableList() {
        return this.variableList;
    }

    public void setVariableList(Vector<Integer> variableList) {
        this.variableList = variableList;
    }

    public XPolynomial getXPoly(int index) {
        return this.polynomials.get(index);
    }

    public void setXPoly(int index, XPolynomial xPoly) {
        this.polynomials.set(index, xPoly);
    }

    public void addXPoly(int index, XPolynomial xPoly) {
        this.polynomials.add(index, xPoly);
    }

    public void addXPoly(XPolynomial xPoly) {
        this.polynomials.add(xPoly);
    }

    public void removePoly(int index) {
        this.polynomials.remove(index);
    }

    public int numOfPols() {
        return this.polynomials.size();
    }

    public boolean isValid() {
        int n = this.polynomials.size();
        int[] usedIndices = new int[n];
        for (int ii = 0; ii < n; ++ii) {
            usedIndices[ii] = 0;
        }
        for (XPolynomial xp : this.polynomials) {
            for (Term xt : xp.getTermsAsDescList()) {
                for (Power pow : xt.getPowers()) {
                    int currIndex = (int)pow.getIndex();
                    if (currIndex <= 0 || currIndex > n) {
                        return false;
                    }
                    usedIndices[currIndex - 1] = 1;
                }
            }
        }
        for (int ii = 0; ii < n; ++ii) {
            if (usedIndices[ii] != 0) continue;
            return false;
        }
        return true;
    }

    public boolean checkAndReOrderTriangularSystem() {
        int ii;
        if (this.getPolynomials().size() == 0) {
            return true;
        }
        int n = this.polynomials.size();
        Vector<Integer> polysByNumOfVars = new Vector<Integer>(n + 1);
        Vector<BitSet> varsInPolys = new Vector<BitSet>(n);
        for (ii = 0; ii < n; ++ii) {
            polysByNumOfVars.add(new Integer(-1));
            BitSet bs = new BitSet(n);
            bs.clear();
            varsInPolys.add(bs);
        }
        polysByNumOfVars.add(new Integer(-1));
        this.variableList = new Vector(n);
        for (ii = 0; ii < n; ++ii) {
            int counter = 0;
            ArrayList<Term> terms = this.polynomials.get(ii).getTermsAsDescList();
            int size = terms.size();
            for (int jj = 0; jj < size; ++jj) {
                Vector<Power> powers = terms.get(jj).getPowers();
                int psize = powers.size();
                for (int kk = 0; kk < psize; ++kk) {
                    int varIndex = (int)powers.get(kk).getIndex() - 1;
                    BitSet bs = (BitSet)varsInPolys.get(ii);
                    if (bs.get(varIndex)) continue;
                    ++counter;
                    bs.set(varIndex);
                }
            }
            if (counter <= 0 || counter > n || (Integer)polysByNumOfVars.get(counter) >= 0) {
                return false;
            }
            polysByNumOfVars.set(counter, new Integer(ii));
        }
        this.variableList.add(0, new Integer(((BitSet)varsInPolys.get((Integer)polysByNumOfVars.get(1))).nextSetBit(0) + 1));
        ii = 1;
        for (int jj = 2; jj <= n; ++jj) {
            BitSet bsi = (BitSet)varsInPolys.get((Integer)polysByNumOfVars.get(ii));
            BitSet bsiCopy = new BitSet(n);
            bsiCopy.clear();
            bsiCopy.or(bsi);
            BitSet bsj = (BitSet)varsInPolys.get((Integer)polysByNumOfVars.get(jj));
            bsiCopy.and(bsj);
            if (!bsi.equals(bsiCopy)) {
                return false;
            }
            BitSet bsiNewCopy = new BitSet(n);
            bsiNewCopy.clear();
            bsiNewCopy.or(bsi);
            bsiNewCopy.xor(bsj);
            this.variableList.add(jj - 1, new Integer(bsiNewCopy.nextSetBit(0) + 1));
            ++ii;
        }
        Vector<XPolynomial> triangularSystem = new Vector<XPolynomial>(n);
        for (int ii2 = 0; ii2 < n; ++ii2) {
            triangularSystem.add(ii2, this.polynomials.get((Integer)polysByNumOfVars.get(ii2 + 1)));
        }
        this.polynomials = triangularSystem;
        return true;
    }

    public int triangulate() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (this.checkAndReOrderTriangularSystem()) {
            try {
                output.writePlainText("The system is already triangular.\n\n");
                output.writePolySystem(this);
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
            return 0;
        }
        this.variableList = new Vector();
        Vector triangularSystem = new Vector();
        Vector<XPolynomial> freeSystem = null;
        Vector<XPolynomial> nonFreeSystem = null;
        Vector<XPolynomial> auxSystem = this.polynomials;
        Vector<XPolynomial> tempSystemForOutput = null;
        XPolySystem tempPolySystem = null;
        Vector<Integer> originalIndexes = null;
        boolean tempSystemChanged = true;
        try {
            output.writePlainText("The input system is:\n\n");
            output.writePolySystem(this);
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        int ii = this.polynomials.size();
        int istep = 1;
        int isize = this.polynomials.size();
        while (ii > 0) {
            StringBuilder sb;
            try {
                output.openSubSection("Triangulation, step " + istep, true);
                output.openEnum("description");
                output.openItemWithDesc("Choosing variable:");
                sb = new StringBuilder();
                sb.append("Trying the variable with index ");
                sb.append(ii);
                sb.append(".\n\n");
                output.closeItemWithDesc(sb.toString());
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
            freeSystem = new Vector<XPolynomial>();
            nonFreeSystem = new Vector<XPolynomial>();
            originalIndexes = new Vector<Integer>();
            tempSystemChanged = true;
            int kk = auxSystem.size();
            for (int jj = 0; jj < kk; ++jj) {
                XPolynomial currXPoly = auxSystem.get(jj);
                int varExp = 0;
                ArrayList<Term> termList = currXPoly.getTermsAsDescList();
                boolean allProcessed = false;
                int numOfTerms = termList.size();
                boolean found = false;
                for (int counter = 0; counter < numOfTerms && !allProcessed && !found; ++counter) {
                    XTerm currTerm = (XTerm)termList.get(counter);
                    if (currTerm == null) {
                        String errMsg = "Found null term";
                        logger.error(errMsg);
                        try {
                            output.openItemWithDesc("Error:");
                            output.closeItemWithDesc(errMsg);
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                        return -4;
                    }
                    varExp = currTerm.getVariableExponent(ii);
                    if (varExp > 0) {
                        found = true;
                        continue;
                    }
                    if (currTerm.getPowers().size() != 0 && currTerm.getPowers().get(0).getIndex() >= (long)ii) continue;
                    allProcessed = true;
                }
                if (found) {
                    nonFreeSystem.add((XPolynomial)currXPoly.clone());
                    originalIndexes.add(new Integer(jj));
                    continue;
                }
                freeSystem.add((XPolynomial)currXPoly.clone());
            }
            if (nonFreeSystem.size() == 0) {
                String errMsg = "Variable with index " + ii + " not found in polynomial system.";
                logger.error(errMsg);
                try {
                    output.openItemWithDesc("Error:");
                    output.closeItemWithDesc(errMsg);
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
                return -1;
            }
            try {
                sb = new StringBuilder();
                sb.append("Variable <ind_text><label>x</label><ind>");
                sb.append(ii);
                sb.append("</ind></ind_text> selected:");
                output.openItemWithDesc(sb.toString());
                sb = new StringBuilder();
                sb.append("The number of polynomials with this variable, with indexes from 1 to ");
                sb.append(isize - istep + 1);
                sb.append(", is ");
                sb.append(nonFreeSystem.size());
                sb.append(".\n\n");
                output.closeItemWithDesc(sb.toString());
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
            if (nonFreeSystem.size() == 1) {
                triangularSystem.add(0, nonFreeSystem.get(0));
                this.variableList.add(0, new Integer(ii));
                auxSystem = freeSystem;
                tempSystemChanged = false;
                try {
                    output.openItemWithDesc("Single polynomial with chosen variable:");
                    sb = new StringBuilder();
                    sb.append("Chosen polynomial is <ind_text><label>p</label><ind>");
                    sb.append((Integer)originalIndexes.get(0) + 1);
                    sb.append("</ind></ind_text>. No reduction needed.\n\n");
                    output.closeItemWithDesc(sb.toString());
                    output.writeEnumItem("The triangular system has not been changed.\n\n");
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
            }
            boolean end = false;
            do {
                String errMsg;
                int numOfTerms;
                int min2;
                int min1;
                int first = 0;
                int second = 1;
                int exp1 = ((XPolynomial)nonFreeSystem.get(first)).getLeadingExp(ii);
                int exp2 = ((XPolynomial)nonFreeSystem.get(second)).getLeadingExp(ii);
                int count1 = 1;
                int count2 = 1;
                if (exp1 == 0 || exp2 == 0) {
                    String errMsg2 = "Variable not found when expected to be found.";
                    logger.error(errMsg2);
                    try {
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc(errMsg2);
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                        return -1;
                    }
                    return -1;
                }
                if (exp1 <= exp2) {
                    min1 = exp1;
                    min2 = exp2;
                } else {
                    first = 1;
                    second = 0;
                    min1 = exp2;
                    min2 = exp1;
                }
                int mm = nonFreeSystem.size();
                for (int ll = 2; ll < mm; ++ll) {
                    int currExp = ((XPolynomial)nonFreeSystem.get(ll)).getLeadingExp(ii);
                    if (currExp == 0) {
                        String errMsg3 = "Variable not found when expected to be found.";
                        logger.error(errMsg3);
                        try {
                            output.openItemWithDesc("Error:");
                            output.closeItemWithDesc(errMsg3);
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                        return -1;
                    }
                    if (currExp < min1) {
                        first = ll;
                        min1 = currExp;
                        count1 = 1;
                        continue;
                    }
                    if (currExp == min1) {
                        ++count1;
                        continue;
                    }
                    if (currExp < min2) {
                        second = ll;
                        min2 = currExp;
                        count2 = 1;
                        continue;
                    }
                    if (currExp != min2) continue;
                    ++count2;
                }
                try {
                    output.openItemWithDesc("Minimal degrees:");
                    sb = new StringBuilder();
                    if (min1 < min2) {
                        sb.append(count1);
                        sb.append(" polynomial(s) with degree ");
                        sb.append(min1);
                        sb.append(" and ");
                        sb.append(count2);
                        sb.append(" polynomial(s) with degree ");
                        sb.append(min2);
                    } else if (min1 == min2) {
                        sb.append(count1 + count2);
                        sb.append(" polynomial(s) with degree ");
                        sb.append(min1);
                    }
                    sb.append(".\n\n");
                    output.closeItemWithDesc(sb.toString());
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
                if (min1 == 1) {
                    try {
                        output.openItemWithDesc("Polynomial with linear degree:");
                        sb = new StringBuilder();
                        sb.append("Removing variable <ind_text><label>x</label><ind>");
                        sb.append(ii);
                        sb.append("</ind></ind_text> from all other polynomials by reducing them with polynomial <ind_text><label>p</label><ind>");
                        sb.append((Integer)originalIndexes.get(first) + 1);
                        sb.append("</ind></ind_text> from previous step.\n\n");
                        output.closeItemWithDesc(sb.toString());
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                        return -1;
                    }
                    XPolynomial currPoly = (XPolynomial)nonFreeSystem.get(first);
                    triangularSystem.add(0, currPoly);
                    this.variableList.add(0, new Integer(ii));
                    nonFreeSystem.remove(first);
                    int mm2 = nonFreeSystem.size();
                    for (int ll = 0; ll < mm2; ++ll) {
                        XPolynomial tempXP = ((XPolynomial)nonFreeSystem.get(ll)).pseudoReminder(currPoly, ii);
                        if (tempXP == null) {
                            return OpenGeoProver.settings.getRetCodeOfPseudoDivision();
                        }
                        numOfTerms = tempXP.getTerms().size();
                        if (numOfTerms > OpenGeoProver.settings.getParameters().getSpaceLimit()) {
                            errMsg = "Polynomial exceeds maximal allowed number of terms.";
                            logger.error(errMsg);
                            try {
                                output.openItemWithDesc("Error:");
                                output.closeItemWithDesc(errMsg);
                            }
                            catch (IOException e) {
                                logger.error("Failed to write to output file(s).");
                                output.close();
                                return -1;
                            }
                            return -3;
                        }
                        if (numOfTerms > OpenGeoProver.settings.getMaxNumOfTerms()) {
                            OpenGeoProver.settings.setMaxNumOfTerms(numOfTerms);
                        }
                        if (OpenGeoProver.settings.getTimer().isTimeIsUp()) {
                            errMsg = "Prover execution time has been expired.";
                            logger.error(errMsg);
                            try {
                                output.openItemWithDesc("Error:");
                                output.closeItemWithDesc(errMsg);
                            }
                            catch (IOException e) {
                                logger.error("Failed to write to output file(s).");
                                output.close();
                                return -1;
                            }
                            return -2;
                        }
                        freeSystem.add(tempXP);
                    }
                    auxSystem = freeSystem;
                    end = true;
                    continue;
                }
                XPolynomial r2 = (XPolynomial)nonFreeSystem.get(second);
                XPolynomial r1 = (XPolynomial)nonFreeSystem.get(first);
                int leadExp = 0;
                try {
                    output.openItemWithDesc("No linear degree polynomials:");
                    sb = new StringBuilder();
                    sb.append("Reducing polynomial <ind_text><label>p</label><ind>");
                    sb.append(second + 1);
                    sb.append("</ind></ind_text> (of degree ");
                    sb.append(min2);
                    sb.append(") with <ind_text><label>p</label><ind>");
                    sb.append(first + 1);
                    sb.append("</ind></ind_text> (of degree ");
                    sb.append(min1);
                    sb.append(").\n\n");
                    output.closeItemWithDesc(sb.toString());
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
                do {
                    XPolynomial temp;
                    if ((temp = r2.pseudoReminder(r1, ii)) == null) {
                        return OpenGeoProver.settings.getRetCodeOfPseudoDivision();
                    }
                    numOfTerms = temp.getTerms().size();
                    if (numOfTerms > OpenGeoProver.settings.getParameters().getSpaceLimit()) {
                        errMsg = "Polynomial exceeds maximal allowed number of terms.";
                        logger.error(errMsg);
                        try {
                            output.openItemWithDesc("Error:");
                            output.closeItemWithDesc(errMsg);
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                        return -3;
                    }
                    if (numOfTerms > OpenGeoProver.settings.getMaxNumOfTerms()) {
                        OpenGeoProver.settings.setMaxNumOfTerms(numOfTerms);
                    }
                    if (OpenGeoProver.settings.getTimer().isTimeIsUp()) {
                        errMsg = "Prover execution time has been expired.";
                        logger.error(errMsg);
                        try {
                            output.openItemWithDesc("Error:");
                            output.closeItemWithDesc(errMsg);
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                        return -2;
                    }
                    r2 = r1;
                    r1 = temp;
                    if (!r1.isZero()) continue;
                    errMsg = "Two polynomials have common factor.";
                    logger.error(errMsg);
                    try {
                        output.openItemWithDesc("Error:");
                        output.closeItemWithDesc(errMsg);
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                        return -1;
                    }
                    return -1;
                } while ((leadExp = r1.getLeadingExp(ii)) > 1);
                nonFreeSystem.set(first, r1);
                nonFreeSystem.set(second, r2);
                if (leadExp == 0) {
                    freeSystem.add(r1);
                    nonFreeSystem.remove(first);
                    if (nonFreeSystem.size() != 1) continue;
                    triangularSystem.add(0, r2);
                    this.variableList.add(0, new Integer(ii));
                    auxSystem = freeSystem;
                    end = true;
                    continue;
                }
                triangularSystem.add(0, r1);
                this.variableList.add(0, new Integer(ii));
                nonFreeSystem.remove(first);
                int mm3 = nonFreeSystem.size();
                for (int ll = 0; ll < mm3; ++ll) {
                    XPolynomial tempXP = ((XPolynomial)nonFreeSystem.get(ll)).pseudoReminder(r1, ii);
                    if (tempXP == null) {
                        return OpenGeoProver.settings.getRetCodeOfPseudoDivision();
                    }
                    int numOfTerms2 = tempXP.getTerms().size();
                    if (numOfTerms2 > OpenGeoProver.settings.getParameters().getSpaceLimit()) {
                        String errMsg4 = "Polynomial exceeds maximal allowed number of terms.";
                        logger.error(errMsg4);
                        try {
                            output.openItemWithDesc("Error:");
                            output.closeItemWithDesc(errMsg4);
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                        return -3;
                    }
                    if (numOfTerms2 > OpenGeoProver.settings.getMaxNumOfTerms()) {
                        OpenGeoProver.settings.setMaxNumOfTerms(numOfTerms2);
                    }
                    if (OpenGeoProver.settings.getTimer().isTimeIsUp()) {
                        String errMsg5 = "Prover execution time has been expired.";
                        logger.error(errMsg5);
                        try {
                            output.openItemWithDesc("Error:");
                            output.closeItemWithDesc(errMsg5);
                        }
                        catch (IOException e) {
                            logger.error("Failed to write to output file(s).");
                            output.close();
                            return -1;
                        }
                        return -2;
                    }
                    freeSystem.add(tempXP);
                }
                auxSystem = freeSystem;
                end = true;
            } while (!end);
            tempSystemForOutput = new Vector<XPolynomial>();
            for (XPolynomial xp : auxSystem) {
                tempSystemForOutput.add(xp);
            }
            for (XPolynomial xp : triangularSystem) {
                tempSystemForOutput.add(xp);
            }
            tempPolySystem = new XPolySystem();
            tempPolySystem.setPolynomials(tempSystemForOutput);
            try {
                output.closeEnum("description");
                if (tempSystemChanged) {
                    output.writePlainText("Finished a triangulation step, the current system is:\n\n");
                    output.writePolySystem(tempPolySystem);
                }
                output.closeSubSection();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
            --ii;
            ++istep;
        }
        this.polynomials = triangularSystem;
        try {
            output.writePlainText("\n\nThe triangular system is:\n\n");
            output.writePolySystem(this);
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }

    public boolean isSystemLinear() {
        for (XPolynomial xp : this.polynomials) {
            for (Term xt : xp.getTermsAsDescList()) {
                for (Power pow : xt.getPowers()) {
                    if (pow.getExponent() <= 1) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

