/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Polynomial;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.UFraction;
import com.ogprover.polynomials.UPolynomial;
import com.ogprover.polynomials.UTerm;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.XTerm;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class XPolynomial
extends Polynomial {
    public static final String VERSION_NUM = "1.00";

    @Override
    public int getType() {
        return 2;
    }

    public XPolynomial() {
        this.terms = new TreeMap();
    }

    public XPolynomial(double cf) {
        XTerm singleTerm = new XTerm(new UFraction(cf));
        this.terms = new TreeMap();
        this.terms.put(singleTerm, singleTerm);
    }

    @Override
    public Polynomial clone() {
        Collection col = this.terms.values();
        Iterator termIT = col.iterator();
        XPolynomial c = new XPolynomial();
        while (termIT.hasNext()) {
            Term ct = ((Term)termIT.next()).clone();
            c.getTerms().put(ct, ct);
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Term> list = this.getTermsAsDescList();
        int ii = 0;
        int size = list.size();
        if (size == 0) {
            sb.append("[XPolynomial object: zero polynomial]");
        } else {
            sb.append("[XPolynomial object: <terms in descending order>\n");
            while (ii < size) {
                sb.append("\t");
                sb.append(this.getTermsAsDescList().get(ii++).toString());
                sb.append("\n");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    @Override
    public String printToLaTeX() {
        StringBuilder sb = new StringBuilder();
        boolean firstTerm = true;
        ArrayList<Term> list = this.getTermsAsDescList();
        int size = list.size();
        int chunkSize = 0;
        if (size == 0) {
            return "0";
        }
        for (int ii = 0; ii < size; ++ii) {
            Term t = list.get(ii);
            ((XTerm)t).reduce();
            String latexTerm = t.printToLaTeX();
            if (latexTerm.startsWith("??")) {
                return "??";
            }
            int len = latexTerm.length();
            int newChunkSize = chunkSize + len;
            if (!firstTerm && !((XTerm)t).getUCoeff().isSingleNegativeTerm()) {
                sb.append(" + ");
            }
            if (newChunkSize <= 90) {
                sb.append(latexTerm);
                chunkSize = newChunkSize;
            } else {
                if (!firstTerm) {
                    sb.append("$$");
                }
                sb.append(latexTerm);
                if (len > 90) {
                    sb.append("$$");
                    chunkSize = 0;
                } else {
                    chunkSize = len;
                }
            }
            if (!firstTerm) continue;
            firstTerm = false;
        }
        return sb.toString();
    }

    @Override
    public String printToXML() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Term> list = this.getTermsAsDescList();
        int size = list.size();
        if (size > 255) {
            return "??";
        }
        if (size == 0) {
            return "<proof_xpoly><proof_xterm><proof_ufrac><proof_ufrac_num><proof_upoly><proof_uterm><proof_coeff>0</proof_coeff></proof_uterm></proof_upoly></proof_ufrac_num></proof_ufrac></proof_xterm></proof_xpoly>";
        }
        sb.append("<proof_xpoly>");
        boolean firstTerm = true;
        int jj = list.size();
        for (int ii = 0; ii < jj; ++ii) {
            XTerm xt = (XTerm)list.get(ii);
            String xmlTerm = xt.printToXML();
            if (xmlTerm.startsWith("??")) {
                return "??";
            }
            if (firstTerm) {
                int signInd = xmlTerm.indexOf("<proof_xsign> +");
                if (signInd >= 0) {
                    sb.append(xmlTerm.substring(0, xmlTerm.indexOf("<proof_xsign>")));
                    sb.append(xmlTerm.substring(xmlTerm.indexOf("</proof_xsign>") + 14));
                } else {
                    sb.append(xmlTerm);
                }
                firstTerm = false;
                continue;
            }
            sb.append(xmlTerm);
        }
        sb.append("</proof_xpoly>");
        String xmlText = sb.toString();
        if (xmlText.length() > 50000) {
            return "??";
        }
        return xmlText;
    }

    @Override
    public String print() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Term> list = this.getTermsAsDescList();
        int size = list.size();
        int textSize = 0;
        if (size == 0) {
            return "0";
        }
        for (int ii = 0; ii < size; ++ii) {
            Term t = list.get(ii);
            ((XTerm)t).reduce();
            String stringTerm = t.print();
            if (stringTerm.startsWith("...")) {
                sb.append("+...");
                return sb.toString();
            }
            int len = stringTerm.length();
            if (ii != 0 && !((XTerm)t).getUCoeff().isSingleNegativeTerm()) {
                sb.append("+");
            }
            if (textSize + len <= 2000) {
                sb.append(stringTerm);
                textSize += len;
                continue;
            }
            sb.append("+...");
            return sb.toString();
        }
        return sb.toString();
    }

    public XPolynomial reduceUTerms(boolean bTotalReduction) {
        UFraction coeff;
        UTerm numGcd = null;
        Term denGcd = null;
        boolean beginNum = true;
        boolean beginDen = true;
        boolean calcNumGcd = true;
        boolean calcDenGcd = true;
        if (this.terms.size() == 0) {
            return this;
        }
        for (Term t : this.getTermsAsDescList()) {
            ((XTerm)t).reduce();
        }
        for (Term t : this.getTermsAsDescList()) {
            coeff = ((XTerm)t).getUCoeff();
            if (calcNumGcd) {
                for (Term s : coeff.getNumerator().getTermsAsDescList()) {
                    if (beginNum) {
                        numGcd = (UTerm)s.clone();
                        numGcd.setCoeff(1.0);
                        beginNum = false;
                        continue;
                    }
                    numGcd.gcd(s);
                }
                if (numGcd.getPowers().size() == 0) {
                    calcNumGcd = false;
                }
            }
            if (!calcDenGcd) continue;
            for (Term s : coeff.getDenominator().getTermsAsDescList()) {
                if (beginDen) {
                    denGcd = (UTerm)s.clone();
                    ((UTerm)denGcd).setCoeff(1.0);
                    beginDen = false;
                    continue;
                }
                denGcd.gcd(s);
            }
            if (denGcd.getPowers().size() != 0) continue;
            calcDenGcd = false;
        }
        if (numGcd == null || denGcd == null) {
            OpenGeoProver.settings.getLogger().error("Failed to calculate GCD of u-coefficients from terms of x-polynomial");
            return null;
        }
        if (!bTotalReduction) {
            UTerm tempUT = new UTerm(numGcd.getCoeff());
            for (Power uPow : numGcd.getPowers()) {
                if (uPow.getExponent() <= 1) continue;
                Power tempUP = uPow.clone();
                tempUP.addToExponent(-1);
                tempUT.addPower(tempUP);
            }
            numGcd = tempUT;
        }
        for (Term t : this.getTermsAsDescList()) {
            coeff = ((XTerm)t).getUCoeff();
            coeff.getNumerator().divideByTerm(numGcd);
            coeff.getDenominator().divideByTerm((UTerm)denGcd);
        }
        double leadingDoubleCoeff = ((UTerm)((XTerm)this.getTermsAsDescList().get(0)).getUCoeff().getNumerator().getTermsAsDescList().get(0)).getCoeff();
        if (leadingDoubleCoeff > -1.0E-6 && leadingDoubleCoeff < 1.0E-6) {
            OpenGeoProver.settings.getLogger().error("Attempt to divide by zero - leading coefficient must not be zero since zero terms are not kept in memory");
            return null;
        }
        this.multiplyByRealConstant(1.0 / leadingDoubleCoeff);
        return this;
    }

    public XPolynomial reduceByUTermDivision() {
        return this.reduceUTerms(true);
    }

    private int getLeadingExpAndCoeff(int varIndex, int expDecr, XPolynomial leadingCoeff) {
        int ii;
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (leadingCoeff == null) {
            logger.error("Passed null polynomial - no place where to store terms");
            return -4;
        }
        ArrayList<Term> termList = this.getTermsAsDescList();
        int maxExp = 0;
        Vector<Term> coeff = null;
        int currDecr = 0;
        boolean allProcessed = false;
        int jj = termList.size();
        for (ii = 0; ii < jj && !allProcessed; ++ii) {
            Term currT = termList.get(ii);
            if (currT == null) {
                logger.error("Null object found when expected non-null value");
                return -4;
            }
            int currExp = currT.getVariableExponent(varIndex);
            if (currExp > 0) {
                if (currExp < expDecr) continue;
                if (currExp == maxExp) {
                    if (coeff == null) {
                        coeff = new Vector<Term>();
                    }
                    if (currDecr == 0) {
                        coeff.add(currT.clone());
                        continue;
                    }
                    coeff.add(currT.clone().changePowerExponent(varIndex, -currDecr));
                    continue;
                }
                if (currExp <= maxExp) continue;
                maxExp = currExp;
                currDecr = expDecr >= 0 ? expDecr : maxExp;
                coeff = new Vector();
                if (currDecr == 0) {
                    coeff.add(currT.clone());
                    continue;
                }
                coeff.add(currT.clone().changePowerExponent(varIndex, -currDecr));
                continue;
            }
            if (currT.getPowers().size() != 0 && currT.getPowers().get(0).getIndex() >= (long)varIndex) continue;
            allProcessed = true;
        }
        if (maxExp > 0) {
            jj = coeff.size();
            for (ii = 0; ii < jj; ++ii) {
                leadingCoeff.addTerm((Term)coeff.get(ii));
            }
        }
        return maxExp;
    }

    public XPolynomial pseudoReminder(XPolynomial p, int varIndex) {
        boolean canProceed;
        XPolynomial pc;
        int pe;
        int sizeOfP;
        if (p == null) {
            OpenGeoProver.settings.logGeneralErrorInPseudoDivision("Pseudo division error: Null polynomial passed in.");
            return null;
        }
        if (varIndex <= 0) {
            OpenGeoProver.settings.logGeneralErrorInPseudoDivision("Pseudo division error: Bad variable index passed in - it should be positive.");
            return null;
        }
        int sizeOfThis = this.getTerms().size();
        if (sizeOfThis > OpenGeoProver.settings.getMaxNumOfTerms()) {
            OpenGeoProver.settings.setMaxNumOfTerms(sizeOfThis);
        }
        if ((sizeOfP = p.getTerms().size()) > OpenGeoProver.settings.getMaxNumOfTerms()) {
            OpenGeoProver.settings.setMaxNumOfTerms(sizeOfP);
        }
        if ((pe = p.getLeadingExpAndCoeff(varIndex, -1, pc = new XPolynomial())) < 0) {
            OpenGeoProver.settings.logGeneralErrorInPseudoDivision("Pseudo division error: Failed to get leading exponent and coefficient.");
            return null;
        }
        if (pe == 0) {
            this.terms = new TreeMap();
            return this;
        }
        XPolynomial reminder = this;
        do {
            int sizeOfRem;
            canProceed = false;
            XPolynomial rc = new XPolynomial();
            int re = reminder.getLeadingExpAndCoeff(varIndex, pe, rc);
            if (re < 0) {
                OpenGeoProver.settings.logGeneralErrorInPseudoDivision("Pseudo division error: Failed to get leading exponent and coefficient.");
                return null;
            }
            if (re >= pe) {
                canProceed = true;
                reminder = (XPolynomial)reminder.multiplyByPolynomial(pc).subtractPolynomial(p.clone().multiplyByPolynomial(rc));
            }
            if ((sizeOfRem = reminder.getTerms().size()) > OpenGeoProver.settings.getParameters().getSpaceLimit()) {
                OpenGeoProver.settings.logSpaceErrorInPseudoDivision(sizeOfRem);
                return null;
            }
            if (OpenGeoProver.settings.getTimer().isTimeIsUp()) {
                OpenGeoProver.settings.logTimeErrorInPseudoDivision();
                return null;
            }
            if (sizeOfRem <= OpenGeoProver.settings.getMaxNumOfTerms()) continue;
            OpenGeoProver.settings.setMaxNumOfTerms(sizeOfRem);
        } while (canProceed);
        return this;
    }

    public int getLeadingExp(int varIndex) {
        ArrayList<Term> termList = this.getTermsAsDescList();
        int maxExp = 0;
        boolean allProcessed = false;
        int jj = termList.size();
        for (int ii = 0; ii < jj && !allProcessed; ++ii) {
            Power currP;
            Term currT = termList.get(ii);
            if (currT == null) {
                OpenGeoProver.settings.getLogger().error("Null object found when expected non-null value");
                return -4;
            }
            int currExp = currT.getVariableExponent(varIndex);
            if (currExp > 0) {
                if (currExp <= maxExp) continue;
                maxExp = currExp;
                continue;
            }
            Vector<Power> powers = currT.getPowers();
            Power power = currP = powers.size() > 0 ? powers.get(0) : null;
            if (currP != null && currP.getIndex() >= (long)varIndex) continue;
            allProcessed = true;
        }
        return maxExp;
    }

    public XPolynomial getLeadingCoefficientOfVariable(int xVarIndex) {
        XPolynomial leadingCoeffXPoly = new XPolynomial();
        this.getLeadingExpAndCoeff(xVarIndex, -1, leadingCoeffXPoly);
        return leadingCoeffXPoly;
    }

    public Vector<UXVariable> extractAllVariables() {
        HashMap<String, UXVariable> varMap = new HashMap<String, UXVariable>();
        for (Term t : this.getTermsAsDescList()) {
            String uxvKey;
            UXVariable uxVar;
            UTerm ut;
            XTerm xt = (XTerm)t;
            UFraction uf = xt.getUCoeff();
            UPolynomial uNum = uf.getNumerator();
            UPolynomial uDen = uf.getDenominator();
            for (Term u : uNum.getTermsAsDescList()) {
                ut = (UTerm)u;
                for (Power p : ut.getPowers()) {
                    uxVar = (UXVariable)p.getVariable();
                    uxvKey = uxVar.toString();
                    if (varMap.containsKey(uxvKey)) continue;
                    varMap.put(uxvKey, uxVar);
                }
            }
            for (Term u : uDen.getTermsAsDescList()) {
                ut = (UTerm)u;
                for (Power p : ut.getPowers()) {
                    uxVar = (UXVariable)p.getVariable();
                    uxvKey = uxVar.toString();
                    if (varMap.containsKey(uxvKey)) continue;
                    varMap.put(uxvKey, uxVar);
                }
            }
            for (Power p : xt.getPowers()) {
                UXVariable uxVar2 = (UXVariable)p.getVariable();
                String uxvKey2 = uxVar2.toString();
                if (varMap.containsKey(uxvKey2)) continue;
                varMap.put(uxvKey2, uxVar2);
            }
        }
        Collection allVars = varMap.values();
        if (allVars == null) {
            return null;
        }
        return new Vector<UXVariable>(allVars);
    }

    public boolean matchesNDGCPolynomial(XPolynomial ndgcPoly) {
        if (this.isZero()) {
            return false;
        }
        XPolynomial positionPoly = ((XPolynomial)this.clone()).reduceUTerms(false);
        XPolynomial conditionPoly = (XPolynomial)ndgcPoly.clone();
        Term posPolyUFactor = null;
        for (Term t : positionPoly.getTermsAsDescList()) {
            Term xt = (XTerm)t;
            for (Term ut : ((XTerm)xt).getUCoeff().getNumerator().getTermsAsDescList()) {
                if (posPolyUFactor == null) {
                    posPolyUFactor = (UTerm)ut.clone();
                    ((UTerm)posPolyUFactor).setCoeff(1.0);
                    continue;
                }
                posPolyUFactor.gcd(ut);
            }
        }
        XPolynomial posPolyResidum = (XPolynomial)positionPoly.clone();
        for (Term xt : posPolyResidum.getTermsAsDescList()) {
            ((XTerm)xt).getUCoeff().getNumerator().divideByTerm((UTerm)posPolyUFactor);
        }
        for (Power p : posPolyUFactor.getPowers()) {
            Term ut;
            UPolynomial up = new UPolynomial();
            ut = new UTerm(1.0);
            ut.addPower(p.clone());
            up.addTerm(ut);
            XTerm xt = new XTerm(new UFraction(up));
            XPolynomial xp = new XPolynomial();
            xp.addTerm(xt);
            if (!xp.equals(conditionPoly)) continue;
            return true;
        }
        if (conditionPoly.getTerms().size() == 1) {
            boolean bDivisible = true;
            Term singleTerm = conditionPoly.getTermsAsDescList().get(0);
            for (Term xt : posPolyResidum.getTermsAsDescList()) {
                if (xt.isDivisibleByTerm(singleTerm)) continue;
                bDivisible = false;
                break;
            }
            if (bDivisible) {
                return true;
            }
        }
        return posPolyResidum.equals(conditionPoly);
    }
}

