/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.polynomials;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.UFraction;
import com.ogprover.polynomials.UTerm;
import com.ogprover.utilities.logger.ILogger;
import java.util.Vector;

public class XTerm
extends Term {
    public static final String VERSION_NUM = "1.00";
    private UFraction uCoeff;

    public UFraction getUCoeff() {
        return this.uCoeff;
    }

    public void setUCoeff(UFraction uCoeff) {
        this.uCoeff = uCoeff;
    }

    @Override
    public int getType() {
        return 2;
    }

    public XTerm(UFraction uf) {
        this.uCoeff = uf;
        this.powers = new Vector();
    }

    public XTerm(double d) {
        this.uCoeff = new UFraction(d);
        this.powers = new Vector();
    }

    @Override
    public Term clone() {
        XTerm c = new XTerm(this.uCoeff.clone());
        int size = this.powers.size();
        for (int ii = 0; ii < size; ++ii) {
            c.getPowers().addElement(((Power)this.powers.get(ii)).clone());
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int size = this.powers.size();
        if (this.uCoeff.isZero()) {
            return "[XTerm object: coefficient = 0]";
        }
        sb.append("[XTerm object:\n coefficient = ");
        sb.append(this.uCoeff.toString());
        sb.append("\n vector of powers = [\n");
        for (int ii = 0; ii < size; ++ii) {
            sb.append("\t" + ((Power)this.powers.get(ii)).toString());
            sb.append("\n");
        }
        sb.append("]]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XTerm)) {
            return false;
        }
        XTerm x = (XTerm)obj;
        return this.compareTo(x) == 0;
    }

    public Term reduce() {
        this.uCoeff.reduce();
        return this;
    }

    @Override
    public Term merge(Term t) {
        if (t == null) {
            OpenGeoProver.settings.getLogger().error("Null term passed in.");
            return null;
        }
        this.uCoeff.add(((XTerm)t).getUCoeff());
        return this;
    }

    @Override
    public Term mul(Term t) {
        if (t == null) {
            OpenGeoProver.settings.getLogger().error("Null term passed in.");
            return null;
        }
        this.uCoeff.mul(((XTerm)t).getUCoeff());
        this.mergePowers(t, true);
        return this;
    }

    @Override
    public Term mul(double r) {
        this.uCoeff.mul(r);
        return this;
    }

    @Override
    public Term divide(Term t) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (t == null) {
            logger.error("Null term passed in.");
            return null;
        }
        if (t.isZero()) {
            logger.error("Attempt to divide by zero term.");
            return null;
        }
        this.uCoeff.mul(((XTerm)t).getUCoeff().invertFraction());
        this.mergePowers(t, false);
        return this;
    }

    @Override
    public Term invert() {
        this.uCoeff.invertSign();
        return this;
    }

    @Override
    public boolean isZero() {
        return this.uCoeff.isZero();
    }

    @Override
    public String printToLaTeX() {
        int size = this.powers.size();
        int ii = 0;
        StringBuilder sb = new StringBuilder();
        if (this.uCoeff.isZero()) {
            return "";
        }
        String latexUCoeff = this.uCoeff.printToLaTeX();
        int len = 0;
        int lenUCoeff = latexUCoeff.length();
        if (lenUCoeff == 0) {
            double shiftedUCoeff;
            double uCoeff = ((UTerm)this.uCoeff.getNumerator().getTermsAsDescList().get(0)).getCoeff();
            double d = shiftedUCoeff = uCoeff > 0.0 ? uCoeff - 1.0 : uCoeff + 1.0;
            if (shiftedUCoeff > -1.0E-6 && shiftedUCoeff < 1.0E-6 && this.powers.size() == 0) {
                return uCoeff > 0.0 ? "1" : "-1";
            }
        }
        if (latexUCoeff.startsWith("??")) {
            return "??";
        }
        sb.append(latexUCoeff);
        if (lenUCoeff > 90) {
            sb.append("$$");
        } else {
            len = lenUCoeff;
        }
        StringBuilder tempSb = new StringBuilder();
        while (ii < size) {
            tempSb.append(((Power)this.powers.get(ii)).printToLaTeX());
            ++ii;
        }
        String latexPowers = tempSb.toString();
        int lenPowers = latexPowers.length();
        if (len + lenPowers > 90) {
            if (lenPowers > 90) {
                return "??";
            }
            sb.append("$$");
            sb.append(latexPowers);
        } else {
            sb.append(latexPowers);
        }
        return sb.toString();
    }

    @Override
    public String printToXML() {
        StringBuilder sb = new StringBuilder();
        if (this.uCoeff.isZero()) {
            return "";
        }
        String xmlUCoeff = this.uCoeff.printToXML();
        if (xmlUCoeff.startsWith("??")) {
            return "??";
        }
        sb.append("<proof_xterm>");
        if (xmlUCoeff.indexOf("<proof_ufrac_den>") >= 0 || xmlUCoeff.indexOf("<proof_lbrac>") >= 0 || xmlUCoeff.indexOf("<proof_usign>") < 0) {
            sb.append("<proof_xsign> + </proof_xsign>");
        }
        if (xmlUCoeff.indexOf("<proof_ufrac_den>") < 0 && xmlUCoeff.indexOf("<proof_lbrac>") < 0) {
            double shiftedUCoeff;
            UTerm singleUTerm = (UTerm)this.uCoeff.getNumerator().getTermsAsDescList().get(0);
            double uCoeff = singleUTerm.getCoeff();
            double d = shiftedUCoeff = uCoeff > 0.0 ? uCoeff - 1.0 : uCoeff + 1.0;
            if (singleUTerm.getPowers().size() == 0 && shiftedUCoeff > -1.0E-6 && shiftedUCoeff < 1.0E-6) {
                if (this.getPowers().size() > 0) {
                    sb.append(xmlUCoeff.substring(0, xmlUCoeff.indexOf("<proof_coeff>")));
                    sb.append(xmlUCoeff.substring(xmlUCoeff.indexOf("</proof_coeff>") + 14));
                } else {
                    sb.append(xmlUCoeff);
                }
            } else {
                sb.append(xmlUCoeff);
            }
        } else {
            sb.append(xmlUCoeff);
        }
        int size = this.powers.size();
        for (int ii = 0; ii < size; ++ii) {
            sb.append(((Power)this.powers.get(ii)).printToXML());
        }
        sb.append("</proof_xterm>");
        String xmlText = sb.toString();
        if (xmlText.length() > 50000) {
            return "??";
        }
        return xmlText;
    }

    @Override
    public String print() {
        int size = this.powers.size();
        int ii = 0;
        StringBuilder sb = new StringBuilder();
        if (this.uCoeff.isZero()) {
            return "";
        }
        String stringUCoeff = this.uCoeff.print();
        int len = 0;
        int lenUCoeff = stringUCoeff.length();
        if (lenUCoeff == 0) {
            double shiftedUCoeff;
            double uCoeff = ((UTerm)this.uCoeff.getNumerator().getTermsAsDescList().get(0)).getCoeff();
            double d = shiftedUCoeff = uCoeff > 0.0 ? uCoeff - 1.0 : uCoeff + 1.0;
            if (shiftedUCoeff > -1.0E-6 && shiftedUCoeff < 1.0E-6 && this.powers.size() == 0) {
                return uCoeff > 0.0 ? "1" : "-1";
            }
        }
        if (stringUCoeff.startsWith("...")) {
            return "...";
        }
        sb.append(stringUCoeff);
        len = lenUCoeff;
        StringBuilder tempSb = new StringBuilder();
        while (ii < size) {
            tempSb.append(((Power)this.powers.get(ii)).print());
            ++ii;
        }
        String stringPowers = tempSb.toString();
        int lenPowers = stringPowers.length();
        if (len + lenPowers > 2000) {
            return "...";
        }
        sb.append(stringPowers);
        return sb.toString();
    }
}

