/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.OGPOutputProverProtocol;
import com.ogprover.utilities.logger.ILogger;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class GeoGebraOGPOutputProverProtocol
extends OGPOutputProverProtocol {
    public static final String VERSION_NUM = "1.00";
    private Map<String, String> outputResultMap;
    private Vector<String> ndgList;
    public static final String OGP_OUTPUT_RES_SUCCESS = "success";
    public static final String OGP_OUTPUT_RES_FAILURE_MSG = "failureMessage";
    public static final String OGP_OUTPUT_RES_PROVER = "proverResult";
    public static final String OGP_OUTPUT_RES_PROVER_MSG = "proverMessage";
    public static final String OGP_OUTPUT_RES_TIME = "time";
    public static final String OGP_OUTPUT_RES_NUMTERMS = "numTerms";

    public void setOutputResultMap(Map<String, String> outputResultMap) {
        this.outputResultMap = outputResultMap;
    }

    public Map<String, String> getOutputResultMap() {
        return this.outputResultMap;
    }

    public void setNdgList(Vector<String> ndgList) {
        this.ndgList = ndgList;
    }

    public Vector<String> getNdgList() {
        return this.ndgList;
    }

    public void setOutputResult(String resName, String resValue) {
        if (this.outputResultMap != null) {
            this.outputResultMap.put(resName, resValue);
        }
    }

    public String getOutputResult(String resName) {
        if (this.outputResultMap != null) {
            return this.outputResultMap.get(resName);
        }
        return null;
    }

    public GeoGebraOGPOutputProverProtocol() {
        this.outputResultMap = new HashMap<String, String>();
        this.ndgList = new Vector();
    }

    public GeoGebraOGPOutputProverProtocol(Map<String, String> outputRes, Vector<String> ndgList) {
        this.outputResultMap = outputRes;
        this.ndgList = ndgList;
    }

    public boolean getSuccess() {
        String successStr = this.getOutputResult(OGP_OUTPUT_RES_SUCCESS);
        if (successStr != null) {
            return successStr.equals("true");
        }
        return false;
    }

    public String getFailureMsg() {
        return this.getOutputResult(OGP_OUTPUT_RES_FAILURE_MSG);
    }

    public String getProverResult() {
        return this.getOutputResult(OGP_OUTPUT_RES_PROVER);
    }

    public String getProverMessage() {
        return this.getOutputResult(OGP_OUTPUT_RES_PROVER_MSG);
    }

    public double getExecutionTime() {
        String exTimeStr = this.getOutputResult(OGP_OUTPUT_RES_TIME);
        double exTime = 0.0;
        if (exTimeStr != null) {
            try {
                exTime = Double.parseDouble(exTimeStr);
            }
            catch (NumberFormatException ex) {
                ILogger logger = OpenGeoProver.settings.getLogger();
                logger.warn("Failed to read execution time from string - exception caught: " + ex.toString());
                exTime = 0.0;
            }
        }
        return exTime;
    }

    public int getNumberOfTerms() {
        String numTermsStr = this.getOutputResult(OGP_OUTPUT_RES_NUMTERMS);
        int numTerms = 0;
        if (numTermsStr != null) {
            try {
                numTerms = Integer.parseInt(numTermsStr);
            }
            catch (NumberFormatException ex) {
                ILogger logger = OpenGeoProver.settings.getLogger();
                logger.warn("Failed to read number of terms from string - exception caught: " + ex.toString());
                numTerms = 0;
            }
        }
        return numTerms;
    }
}

