/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.GeoTheorem;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.Term;
import com.ogprover.polynomials.UFraction;
import com.ogprover.polynomials.UPolynomial;
import com.ogprover.polynomials.UTerm;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.polynomials.XTerm;
import com.ogprover.pp.tp.auxiliary.PointListManager;
import com.ogprover.pp.tp.geoconstruction.FreeParametricSet;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.ParametricSet;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromParametricSet;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromSetOfPoints;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.pp.tp.geoconstruction.ShortcutConstruction;
import com.ogprover.pp.tp.geoconstruction.SpecialConstantAngle;
import com.ogprover.pp.tp.ndgcondition.AlgebraicNDGCondition;
import com.ogprover.pp.tp.ndgcondition.SimpleNDGCondition;
import com.ogprover.pp.tp.thmstatement.CompoundThmStatement;
import com.ogprover.pp.tp.thmstatement.ThmStatement;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class OGPTP {
    public static final String VERSION_NUM = "1.00";
    private String theoremName = null;
    private Vector<GeoConstruction> constructionSteps = null;
    private Map<String, GeoConstruction> constructionMap = null;
    private ThmStatement theoremStatement = null;
    private Vector<AlgebraicNDGCondition> algebraicNDGConditions = null;
    private Vector<SimpleNDGCondition> simpleNDGConditions = null;
    private GeoTheorem algebraicGeoTheorem = new GeoTheorem();
    private Vector<Vector<Point>> zeroPoints = null;
    private int uIndex = 1;
    private int xIndex = 1;
    private int numZeroIndices = 0;
    private boolean hasFreeParametricSet = false;

    public void setTheoremName(String theoremName) {
        this.theoremName = theoremName;
        if (this.algebraicGeoTheorem != null) {
            this.algebraicGeoTheorem.setName(theoremName);
        }
    }

    public String getTheoremName() {
        return this.theoremName;
    }

    public void setConstructionSteps(Vector<GeoConstruction> constructionSteps) {
        this.constructionSteps = constructionSteps;
    }

    public Vector<GeoConstruction> getConstructionSteps() {
        return this.constructionSteps;
    }

    public void setConstructionMap(Map<String, GeoConstruction> constructionMap) {
        this.constructionMap = constructionMap;
    }

    public Map<String, GeoConstruction> getConstructionMap() {
        return this.constructionMap;
    }

    public void setTheoremStatement(ThmStatement theoremStatement) {
        this.theoremStatement = theoremStatement;
    }

    public ThmStatement getTheoremStatement() {
        return this.theoremStatement;
    }

    public void setAlgebraicNDGConditions(Vector<AlgebraicNDGCondition> ndgConditions) {
        this.algebraicNDGConditions = ndgConditions;
    }

    public Vector<AlgebraicNDGCondition> getAlgebraicNDGConditions() {
        return this.algebraicNDGConditions;
    }

    public void setSimpleNDGConditions(Vector<SimpleNDGCondition> ndgConditions) {
        this.simpleNDGConditions = ndgConditions;
    }

    public Vector<SimpleNDGCondition> getSimpleNDGConditions() {
        return this.simpleNDGConditions;
    }

    public void setAlgebraicGeoTheorem(GeoTheorem algebraicGeoTheorem) {
        this.algebraicGeoTheorem = algebraicGeoTheorem;
    }

    public GeoTheorem getAlgebraicGeoTheorem() {
        return this.algebraicGeoTheorem;
    }

    public Vector<Vector<Point>> getZeroPoints() {
        if (this.zeroPoints == null) {
            this.populateZeroPoints();
        }
        return this.zeroPoints;
    }

    public void setUIndex(int uIndex) {
        this.uIndex = uIndex;
    }

    public int getUIndex() {
        return this.uIndex;
    }

    public void setXIndex(int xIndex) {
        this.xIndex = xIndex;
    }

    public int getXIndex() {
        return this.xIndex;
    }

    public void setNumZeroIndices(int numZeroIndices) {
        this.numZeroIndices = numZeroIndices;
    }

    public int getNumZeroIndices() {
        return this.numZeroIndices;
    }

    public void setHasFreeParametricSet(boolean hasFreeParametricSet) {
        this.hasFreeParametricSet = hasFreeParametricSet;
    }

    public boolean isHasFreeParametricSet() {
        return this.hasFreeParametricSet;
    }

    public OGPTP() {
        this.constructionSteps = new Vector();
        this.constructionMap = new HashMap<String, GeoConstruction>();
    }

    public void clear() {
        this.constructionSteps = new Vector();
        this.constructionMap = new HashMap<String, GeoConstruction>();
        this.theoremStatement = null;
        this.theoremName = null;
        this.algebraicNDGConditions = null;
        this.algebraicGeoTheorem = new GeoTheorem();
        this.zeroPoints = null;
        this.uIndex = 1;
        this.xIndex = 1;
        this.numZeroIndices = 0;
        this.hasFreeParametricSet = false;
    }

    public void addGeoConstruction(GeoConstruction gc) {
        if (gc == null) {
            OpenGeoProver.settings.getLogger().warn("Attempt to add null object to theorem protocol");
            return;
        }
        if (this.constructionSteps == null) {
            this.constructionSteps = new Vector();
            this.constructionMap = new HashMap<String, GeoConstruction>();
        }
        if (gc instanceof ShortcutConstruction) {
            for (GeoConstruction singleCons : ((ShortcutConstruction)gc).getShortcutListOfConstructions()) {
                this.constructionSteps.add(singleCons);
                this.constructionMap.put(singleCons.getGeoObjectLabel(), singleCons);
                singleCons.setConsProtocol(this);
                singleCons.setIndex(this.constructionSteps.size() - 1);
            }
        } else {
            this.constructionSteps.add(gc);
            this.constructionMap.put(gc.getGeoObjectLabel(), gc);
            gc.setConsProtocol(this);
            gc.setIndex(this.constructionSteps.size() - 1);
            if (gc instanceof FreeParametricSet) {
                if (!this.hasFreeParametricSet) {
                    ((FreeParametricSet)gc).setContainsOrigin(true);
                    this.hasFreeParametricSet = true;
                } else {
                    ((FreeParametricSet)gc).setContainsOrigin(false);
                }
            }
        }
    }

    public void addGeoConstruction(int index, GeoConstruction gc) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (gc == null) {
            logger.warn("Attempt to add null object to theorem protocol");
            return;
        }
        if (index < 0 || index > this.getConstructionSteps().size()) {
            logger.error("Bad index to put object in theorem protocol - index out of boundaries");
            return;
        }
        if (this.constructionSteps == null) {
            this.constructionSteps = new Vector();
            this.constructionMap = new HashMap<String, GeoConstruction>();
        }
        if (gc instanceof ShortcutConstruction) {
            ShortcutConstruction scCons = (ShortcutConstruction)gc;
            int ii = index;
            int jj = this.constructionSteps.size();
            int kk = ii + scCons.getShortcutListOfConstructions().size();
            while (ii < jj) {
                this.constructionSteps.get(ii).setIndex(kk);
                ii = kk++;
            }
            int currIndex = index;
            for (GeoConstruction currGC : scCons.getShortcutListOfConstructions()) {
                this.constructionSteps.add(currIndex, currGC);
                this.constructionMap.put(currGC.getGeoObjectLabel(), currGC);
                currGC.setConsProtocol(this);
                currGC.setIndex(currIndex);
                ++currIndex;
            }
        } else {
            int ii = index;
            int jj = this.constructionSteps.size();
            int kk = ii + 1;
            while (ii < jj) {
                this.constructionSteps.get(ii).setIndex(kk);
                ii = kk++;
            }
            this.constructionSteps.add(index, gc);
            this.constructionMap.put(gc.getGeoObjectLabel(), gc);
            gc.setConsProtocol(this);
            gc.setIndex(index);
            if (gc instanceof FreeParametricSet) {
                if (!this.hasFreeParametricSet) {
                    ((FreeParametricSet)gc).setContainsOrigin(true);
                    this.hasFreeParametricSet = true;
                } else {
                    ((FreeParametricSet)gc).setContainsOrigin(false);
                }
            }
        }
    }

    public void removeGeoConstruction(GeoConstruction gc) {
        SetOfPoints set;
        int idx;
        Point pt;
        if (gc == null || gc instanceof ShortcutConstruction) {
            return;
        }
        int consInd = this.constructionSteps.indexOf(gc);
        this.constructionSteps.remove(consInd);
        this.constructionMap.remove(gc.getGeoObjectLabel());
        gc.setConsProtocol(null);
        gc.setIndex(-1);
        if (gc instanceof IntersectionPoint) {
            pt = (IntersectionPoint)gc;
            SetOfPoints set1 = ((IntersectionPoint)pt).getFirstPointSet();
            SetOfPoints set2 = ((IntersectionPoint)pt).getSecondPointSet();
            int idx1 = set1.getPoints().indexOf(pt);
            int idx2 = set2.getPoints().indexOf(pt);
            if (idx1 != -1) {
                set1.getPoints().remove(idx1);
            }
            if (idx2 != -1) {
                set2.getPoints().remove(idx2);
            }
        } else if (gc instanceof RandomPointFromSetOfPoints && (idx = (set = ((RandomPointFromSetOfPoints)(pt = (RandomPointFromSetOfPoints)gc)).getBaseSetOfPoints()).getPoints().indexOf(pt)) != -1) {
            set.getPoints().remove(idx);
        }
        int jj = this.constructionSteps.size();
        for (int ii = consInd; ii < jj; ++ii) {
            this.constructionSteps.get(ii).setIndex(ii);
        }
    }

    public void addThmStatement(ThmStatement statement) {
        if (statement == null) {
            OpenGeoProver.settings.getLogger().error("Attempt to add null theorem statement to theorem protocol.");
            return;
        }
        this.theoremStatement = statement;
        statement.setConsProtocol(this);
        if (statement instanceof CompoundThmStatement) {
            for (ThmStatement singleStatement : ((CompoundThmStatement)statement).getParticleThmStatements()) {
                singleStatement.setConsProtocol(this);
            }
        }
    }

    public void addAlgebraicNDGCondition(AlgebraicNDGCondition ndgCond) {
        if (ndgCond == null) {
            OpenGeoProver.settings.getLogger().error("Attempt to add null NDG condition to theorem protocol.");
            return;
        }
        if (this.algebraicNDGConditions == null) {
            this.algebraicNDGConditions = new Vector();
        }
        this.algebraicNDGConditions.add(ndgCond);
        ndgCond.setConsProtocol(this);
    }

    public void addSimpleNDGCondition(SimpleNDGCondition ndgCond) {
        if (ndgCond == null) {
            OpenGeoProver.settings.getLogger().error("Attempt to add null NDG condition to theorem protocol.");
            return;
        }
        if (this.simpleNDGConditions == null) {
            this.simpleNDGConditions = new Vector();
        }
        this.simpleNDGConditions.add(ndgCond);
    }

    public boolean isValid() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        boolean valid = true;
        try {
            output.openSection("Validation of Construction Protocol");
            output.openSubSection("Construction steps: ", false);
            output.openEnum("itemize");
            for (GeoConstruction geoCons : this.constructionSteps) {
                output.writeEnumItem(geoCons.getConstructionDesc());
            }
            output.closeEnum("itemize");
            output.closeSubSection();
            output.openSubSection("Theorem statement: ", false);
            output.openEnum("itemize");
            output.writeEnumItem(this.theoremStatement.getStatementDesc());
            output.closeEnum("itemize");
            output.closeSubSection();
            output.openEnum("description");
            if (this.theoremStatement == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("There is no theorem statement");
                valid = false;
            }
            if (this.constructionSteps.size() > 0) {
                if (valid) {
                    for (GeoConstruction geoCons : this.constructionSteps) {
                        String label = geoCons.getGeoObjectLabel();
                        GeoConstruction mapCons = this.constructionMap.get(label);
                        if (mapCons != null && mapCons == geoCons) continue;
                        output.openItemWithDesc("Error: ");
                        if (mapCons == null) {
                            output.closeItemWithDesc("Object with name " + label + " not correctly mapped in this protocol with its name");
                        } else {
                            output.closeItemWithDesc("Name " + label + " is used more than once for definition of new constructed object");
                        }
                        valid = false;
                        break;
                    }
                }
                if (valid) {
                    GeoConstruction currGeoCons = this.constructionSteps.get(0);
                    while (currGeoCons != null && (valid = currGeoCons.isValidConstructionStep())) {
                        int nextIndex = currGeoCons.getIndex() + 1;
                        if (nextIndex < this.constructionSteps.size()) {
                            currGeoCons = this.constructionSteps.get(nextIndex);
                            continue;
                        }
                        currGeoCons = null;
                    }
                }
            }
            if (!this.theoremStatement.isValid()) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Theorem statement is not valid");
                valid = false;
            }
            output.openItemWithDesc("Validation result: ");
            if (valid) {
                output.closeItemWithDesc("Theorem protocol is valid.");
            } else {
                output.closeItemWithDesc("Theorem protocol is not valid - cannot proceed.");
            }
            output.closeEnum("description");
            output.closeSection();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
        return valid;
    }

    public void resetIndices() {
        this.uIndex = 1;
        this.xIndex = 1;
        this.numZeroIndices = 0;
        this.hasFreeParametricSet = false;
    }

    public void decrementXIndex() {
        --this.xIndex;
    }

    public void incrementXIndex() {
        ++this.xIndex;
    }

    public void decrementUIndex() {
        --this.uIndex;
    }

    public void incrementUIndex() {
        ++this.uIndex;
    }

    private void setNumberOfZeroCoordinates() {
        if (this.hasFreeParametricSet) {
            for (GeoConstruction geoCons : this.constructionSteps) {
                if (!(geoCons instanceof FreeParametricSet)) continue;
                this.numZeroIndices = ((FreeParametricSet)geoCons).getNumberOfZeroCoordinates();
                return;
            }
        }
        this.numZeroIndices = 3;
    }

    public int convertToAlgebraicForm() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        this.setNumberOfZeroCoordinates();
        this.simplify();
        try {
            output.openSubSection("Transformation of Construction steps", false);
            for (GeoConstruction geoCons : this.constructionSteps) {
                int iRet;
                if (geoCons instanceof Point) {
                    iRet = ((Point)geoCons).transformToAlgebraicForm();
                    if (iRet == 0) continue;
                    output.openEnum("description");
                    output.openItemWithDesc("Error: ");
                    output.closeItemWithDesc("Prover failed to transform construction of point " + geoCons.getGeoObjectLabel() + " to algebraic form.");
                    return -1;
                }
                if (geoCons instanceof ParametricSet) {
                    iRet = ((ParametricSet)geoCons).transformToAlgebraicForm();
                    if (iRet == 0) continue;
                    output.openEnum("description");
                    output.openItemWithDesc("Error: ");
                    output.closeItemWithDesc("Prover failed to transform parametric set of points " + geoCons.getGeoObjectLabel() + " to algebraic form.");
                    return -1;
                }
                if (!(geoCons instanceof SpecialConstantAngle) || (iRet = ((SpecialConstantAngle)((Object)geoCons)).transformToAlgebraicForm()) == 0) continue;
                output.openEnum("description");
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Prover failed to transform special constant angle " + geoCons.getGeoObjectLabel() + " to algebraic form.");
                return -1;
            }
            output.closeSubSection();
            output.openSubSection("Transformation of Theorem statement", false);
            int iRet = this.theoremStatement.transformToAlgebraicForm();
            if (iRet != 0) {
                output.openEnum("description");
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Prover failed to transform theorem statement to algebraic form.");
                return -1;
            }
            output.closeSubSection();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }

    public void simplify() {
        int ii;
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (this.theoremStatement == null || this.constructionMap == null) {
            return;
        }
        HashMap<String, String> usedLabelsMap = new HashMap<String, String>();
        Vector<String> usedLabelsList = new Vector<String>();
        String[] statementInputLabels = this.theoremStatement.getInputLabels();
        if (statementInputLabels == null) {
            logger.warn("Statement doesn't have input arguments");
            return;
        }
        for (String label : statementInputLabels) {
            if (usedLabelsMap.get(label) != null) continue;
            usedLabelsMap.put(label, label);
            usedLabelsList.add(label);
        }
        for (ii = 0; ii < usedLabelsList.size(); ++ii) {
            String[] consLabels = this.constructionMap.get(usedLabelsList.get(ii)).getInputLabels();
            if (consLabels == null) continue;
            for (String label : consLabels) {
                if (usedLabelsMap.get(label) != null) continue;
                usedLabelsMap.put(label, label);
                usedLabelsList.add(label);
            }
        }
        for (ii = 0; ii < this.constructionSteps.size(); ++ii) {
            GeoConstruction gc = this.constructionSteps.get(ii);
            if (usedLabelsMap.get(gc.getGeoObjectLabel()) != null) continue;
            this.removeGeoConstruction(gc);
            --ii;
        }
    }

    public void instantiatePoint(Point P, int pointType) {
        if (P == null) {
            return;
        }
        UXVariable xVar = null;
        UXVariable yVar = null;
        boolean instantiatedAsOrigin = false;
        switch (pointType) {
            case 0: {
                if (!this.hasFreeParametricSet && this.numZeroIndices > 0) {
                    xVar = new UXVariable(0, 0L);
                    --this.numZeroIndices;
                } else {
                    xVar = new UXVariable(0, this.uIndex);
                    ++this.uIndex;
                }
                if (!this.hasFreeParametricSet && this.numZeroIndices > 0) {
                    yVar = new UXVariable(0, 0L);
                    --this.numZeroIndices;
                    break;
                }
                yVar = new UXVariable(0, this.uIndex);
                ++this.uIndex;
                break;
            }
            case 1: {
                instantiatedAsOrigin = false;
                if (this.hasFreeParametricSet && P instanceof RandomPointFromParametricSet) {
                    ParametricSet set = (ParametricSet)((RandomPointFromParametricSet)P).getBaseSetOfPoints();
                    Point firstPointFromParamSet = set.getPoints().get(0);
                    if (set instanceof FreeParametricSet && ((FreeParametricSet)set).isContainsOrigin() && P.equals(firstPointFromParamSet) && this.numZeroIndices > 1) {
                        xVar = new UXVariable(0, 0L);
                        yVar = new UXVariable(0, 0L);
                        this.numZeroIndices -= 2;
                        instantiatedAsOrigin = true;
                    }
                }
                if (instantiatedAsOrigin) break;
                if ((!this.hasFreeParametricSet || P instanceof RandomPointFromParametricSet) && this.numZeroIndices > 0) {
                    xVar = new UXVariable(0, 0L);
                    --this.numZeroIndices;
                } else {
                    xVar = new UXVariable(0, this.uIndex);
                    ++this.uIndex;
                }
                yVar = new UXVariable(1, this.xIndex);
                ++this.xIndex;
                break;
            }
            case 2: {
                instantiatedAsOrigin = false;
                if (this.hasFreeParametricSet && P instanceof RandomPointFromParametricSet) {
                    ParametricSet set = (ParametricSet)((RandomPointFromParametricSet)P).getBaseSetOfPoints();
                    Point firstPointFromParamSet = set.getPoints().get(0);
                    if (set instanceof FreeParametricSet && ((FreeParametricSet)set).isContainsOrigin() && P.equals(firstPointFromParamSet) && this.numZeroIndices > 1) {
                        xVar = new UXVariable(0, 0L);
                        yVar = new UXVariable(0, 0L);
                        this.numZeroIndices -= 2;
                        instantiatedAsOrigin = true;
                    }
                }
                if (instantiatedAsOrigin) break;
                xVar = new UXVariable(1, this.xIndex);
                ++this.xIndex;
                if ((!this.hasFreeParametricSet || P instanceof RandomPointFromParametricSet) && this.numZeroIndices > 0) {
                    yVar = new UXVariable(0, 0L);
                    --this.numZeroIndices;
                    break;
                }
                yVar = new UXVariable(0, this.uIndex);
                ++this.uIndex;
                break;
            }
            case 3: {
                xVar = new UXVariable(1, this.xIndex);
                ++this.xIndex;
                yVar = new UXVariable(1, this.xIndex);
                ++this.xIndex;
                break;
            }
        }
        P.setX(xVar);
        P.setY(yVar);
        P.setInstanceType(pointType);
        if (P.getPointState() == 0) {
            P.setPointState(1);
        } else {
            P.setPointState(2);
        }
    }

    public static XPolynomial instantiateCondition(SymbolicPolynomial condition, Map<String, Point> pointsMap) {
        XPolynomial result = new XPolynomial();
        for (Term st : condition.getTermsAsDescList()) {
            HashMap<UXVariable, Power> uPowers = new HashMap<UXVariable, Power>();
            HashMap<UXVariable, Power> xPowers = new HashMap<UXVariable, Power>();
            boolean isZeroTerm = false;
            for (Power pow : st.getPowers()) {
                Power currPower;
                Power powerInstance;
                SymbolicVariable sv = (SymbolicVariable)pow.getVariable();
                String pointLabel = sv.getPointLabel();
                short varType = sv.getVariableType();
                Point P = pointsMap.get(pointLabel);
                if (P == null) {
                    OpenGeoProver.settings.getLogger().error("Failed to find point with specified label " + pointLabel + " during instantiation of condition");
                    return null;
                }
                if (varType == 2) {
                    powerInstance = new Power(P.getX().clone(), pow.getExponent());
                } else if (varType == 3) {
                    powerInstance = new Power(P.getY().clone(), pow.getExponent());
                } else {
                    OpenGeoProver.settings.getLogger().error("Non-symbolic variable obtained when symbolic was excpected");
                    return null;
                }
                short newVarType = powerInstance.getVarType();
                if (newVarType == 0) {
                    if (powerInstance.getIndex() == 0L) {
                        isZeroTerm = true;
                        break;
                    }
                    currPower = (Power)uPowers.get(powerInstance.getVariable());
                    if (currPower == null) {
                        uPowers.put((UXVariable)powerInstance.getVariable(), powerInstance);
                        continue;
                    }
                    currPower.addToExponent(powerInstance.getExponent());
                    continue;
                }
                if (newVarType == 1) {
                    currPower = (Power)xPowers.get(powerInstance.getVariable());
                    if (currPower == null) {
                        xPowers.put((UXVariable)powerInstance.getVariable(), powerInstance);
                        continue;
                    }
                    currPower.addToExponent(powerInstance.getExponent());
                    continue;
                }
                OpenGeoProver.settings.getLogger().error("Power is not instantiated by UX variable");
                return null;
            }
            if (isZeroTerm) continue;
            UTerm ut = new UTerm(((SymbolicTerm)st).getCoeff());
            for (Power upow : uPowers.values()) {
                ut.addPower(upow);
            }
            UPolynomial up = new UPolynomial();
            up.addTerm(ut);
            UFraction uf = new UFraction(up);
            XTerm xt = new XTerm(uf);
            for (Power xpow : xPowers.values()) {
                xt.addPower(xpow);
            }
            result.addTerm(xt);
        }
        return result;
    }

    public boolean isPolynomialConsequenceOfConstructions(XPolynomial xpoly) {
        if (xpoly.isZero()) {
            return true;
        }
        for (XPolynomial xp : this.getAlgebraicGeoTheorem().getHypotheses().getPolynomials()) {
            if (!xpoly.clone().subtractPolynomial(xp).isZero()) continue;
            return true;
        }
        return false;
    }

    public int translateNDGConditionsToUserReadableForm() {
        if (this.algebraicNDGConditions == null) {
            Vector<XPolynomial> ndgConditionsPolys = this.getAlgebraicGeoTheorem().getNDGConditions().getPolynomials();
            if (ndgConditionsPolys == null || ndgConditionsPolys.size() == 0) {
                return 0;
            }
            for (XPolynomial ndgPoly : ndgConditionsPolys) {
                this.addAlgebraicNDGCondition(new AlgebraicNDGCondition(ndgPoly));
            }
        }
        if (this.algebraicNDGConditions == null) {
            OpenGeoProver.settings.getLogger().error("Failed to fill in objects for NDG conditions");
            return -1;
        }
        for (AlgebraicNDGCondition ndgCond : this.algebraicNDGConditions) {
            if (ndgCond.transformToUserReadableForm() == 0) continue;
            OpenGeoProver.settings.getLogger().error("Failed to translate NDG condition " + ndgCond.getPolynomial().print());
            return -1;
        }
        return 0;
    }

    public Vector<String> exportTranslatedNDGConditions() {
        if (this.translateNDGConditionsToUserReadableForm() != 0) {
            return null;
        }
        HashMap<String, String> ndgMap = new HashMap<String, String>();
        if (this.algebraicNDGConditions != null && this.algebraicNDGConditions.size() > 0) {
            for (AlgebraicNDGCondition ndgc : this.algebraicNDGConditions) {
                StringBuilder sbNdgText = new StringBuilder(ndgc.getNdgType());
                String ndgText = null;
                sbNdgText.append("[");
                if (ndgc.getNdgType().equals("IsPolynomial")) {
                    sbNdgText.append(ndgc.getPolynomial().print());
                } else {
                    Vector<Point> ptList = ndgc.getBestPointList();
                    int jj = ptList.size();
                    for (int ii = 0; ii < jj; ++ii) {
                        if (ii > 0) {
                            sbNdgText.append(", ");
                        }
                        sbNdgText.append(ptList.get(ii).getGeoObjectLabel());
                    }
                }
                sbNdgText.append("]");
                ndgText = sbNdgText.toString();
                if (ndgMap.get(ndgText) != null) continue;
                ndgMap.put(ndgText, ndgText);
            }
        }
        return new Vector<String>(ndgMap.values());
    }

    private void populateZeroPoints() {
        Vector<Point> allZeroPoints = new Vector<Point>();
        for (GeoConstruction cons : this.constructionSteps) {
            if (!(cons instanceof Point)) continue;
            Point P = (Point)cons;
            UXVariable x = P.getX();
            UXVariable y = P.getY();
            if ((((Variable)x).getVariableType() != 0 || x.getIndex() != 0L) && (((Variable)y).getVariableType() != 0 || y.getIndex() != 0L)) continue;
            allZeroPoints.add(P);
        }
        this.zeroPoints = PointListManager.createListOfCombinations(allZeroPoints);
        this.zeroPoints.add(new Vector());
    }

    public Map<UXVariable, Vector<Point>> getPointsAssociatedWithVariables(Vector<UXVariable> varList) {
        HashMap<UXVariable, Vector<Point>> resultMap = new HashMap<UXVariable, Vector<Point>>();
        HashMap<String, UXVariable> varMap = new HashMap<String, UXVariable>();
        for (UXVariable uxV : varList) {
            varMap.put(uxV.toString(), uxV);
        }
        if (varList.size() != varMap.size()) {
            OpenGeoProver.settings.getLogger().error("Passed in list of variables contains duplicates.");
            return null;
        }
        for (GeoConstruction gc : this.constructionSteps) {
            if (!(gc instanceof Point)) continue;
            Point p = (Point)gc;
            if (p.getPointState() == 0) {
                OpenGeoProver.settings.getLogger().error("Point not yet instantiated.");
                return null;
            }
            UXVariable xVar = p.getX();
            UXVariable yVar = p.getY();
            if (xVar == null || yVar == null) {
                OpenGeoProver.settings.getLogger().error("Point doesn't have coordinates.");
                return null;
            }
            if (varMap.get(xVar.toString()) != null) {
                Vector<Point> xVarPts = (Vector<Point>)resultMap.get(xVar);
                if (xVarPts == null) {
                    xVarPts = new Vector<Point>();
                    resultMap.put(xVar, xVarPts);
                }
                if (!xVarPts.contains(p)) {
                    xVarPts.add(p);
                }
            }
            if (varMap.get(yVar.toString()) == null) continue;
            Vector<Point> yVarPts = (Vector<Point>)resultMap.get(yVar);
            if (yVarPts == null) {
                yVarPts = new Vector<Point>();
                resultMap.put(yVar, yVarPts);
            }
            if (yVarPts.contains(p)) continue;
            yVarPts.add(p);
        }
        if (resultMap.size() != varMap.size()) {
            OpenGeoProver.settings.getLogger().error("Not all variables were successfully processed.");
            return null;
        }
        return resultMap;
    }
}

