/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import java.util.Vector;

public class DoubleSignedAreaOfPolygon {
    public static final String VERSION_NUM = "1.00";
    private Vector<Point> vertices = null;
    private XPolynomial areaPolynomial = null;

    public void setVertices(Vector<Point> vertices) {
        this.vertices = vertices;
    }

    public Vector<Point> getVertices() {
        return this.vertices;
    }

    public XPolynomial getAreaPolynomial() {
        this.calculateAreaPolynomial();
        return this.areaPolynomial;
    }

    public DoubleSignedAreaOfPolygon(Vector<Point> vertices) {
        this.vertices = vertices;
    }

    private void calculateAreaPolynomial() {
        if (this.areaPolynomial != null) {
            return;
        }
        if (this.vertices == null || this.vertices.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There are no enough vertices in polygon.");
            return;
        }
        Point A1 = this.vertices.get(0);
        Point secondPoint = this.vertices.get(1);
        Point thirdPoint = null;
        Segment AB = null;
        Segment AC = null;
        this.areaPolynomial = new XPolynomial();
        int jj = this.vertices.size();
        for (int ii = 2; ii < jj; ++ii) {
            thirdPoint = this.vertices.get(ii);
            AB = new Segment(A1, secondPoint);
            AC = new Segment(A1, thirdPoint);
            this.areaPolynomial.addPolynomial(AB.getInstantiatedXCoordinateOfOrientedSegment().multiplyByPolynomial(AC.getInstantiatedYCoordinateOfOrientedSegment()).subtractPolynomial(AB.getInstantiatedYCoordinateOfOrientedSegment().multiplyByPolynomial(AC.getInstantiatedXCoordinateOfOrientedSegment())));
            secondPoint = thirdPoint;
        }
    }
}

