/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointsPositionChecker;
import com.ogprover.pp.tp.geoconstruction.AngleBisector;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndPoint;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndRadius;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.ndgcondition.AlgebraicNDGCondition;
import com.ogprover.pp.tp.thmstatement.CollinearPoints;
import com.ogprover.pp.tp.thmstatement.ConcyclicPoints;
import com.ogprover.pp.tp.thmstatement.FourHarmonicConjugatePoints;
import com.ogprover.pp.tp.thmstatement.LinearCombinationOfOrientedSegments;
import com.ogprover.pp.tp.thmstatement.PointOnSetOfPoints;
import com.ogprover.pp.tp.thmstatement.SegmentsOfEqualLengths;
import com.ogprover.pp.tp.thmstatement.TwoInversePoints;
import com.ogprover.pp.tp.thmstatement.TwoParallelLines;
import com.ogprover.pp.tp.thmstatement.TwoPerpendicularLines;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class FourPointsPositionChecker
extends PointsPositionChecker {
    public static final String VERSION_NUM = "1.00";

    public FourPointsPositionChecker(AlgebraicNDGCondition ndgCond) {
        this.initializePointsPositionChecker(ndgCond);
    }

    private boolean checkFourCollinearPoints(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        ArrayList<Point> pointList = new ArrayList<Point>();
        pointList.add(A);
        pointList.add(B);
        pointList.add(C);
        pointList.add(D);
        this.auxiliaryCP.addThmStatement(new CollinearPoints(pointList));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreCollinear", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkFourConcyclicPoints(Point A, Point B, Point C, Point D) {
        HashMap<String, UXVariable> xVarMap = new HashMap<String, UXVariable>();
        xVarMap.put(A.getX().toString(), A.getX());
        xVarMap.put(B.getX().toString(), B.getX());
        xVarMap.put(C.getX().toString(), C.getX());
        xVarMap.put(D.getX().toString(), D.getX());
        HashMap<String, UXVariable> yVarMap = new HashMap<String, UXVariable>();
        yVarMap.put(A.getY().toString(), A.getY());
        yVarMap.put(B.getY().toString(), B.getY());
        yVarMap.put(C.getY().toString(), C.getY());
        yVarMap.put(D.getY().toString(), D.getY());
        if (xVarMap.size() <= 2 || yVarMap.size() <= 2) {
            return false;
        }
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        ArrayList<Point> pointList = new ArrayList<Point>();
        pointList.add(A);
        pointList.add(B);
        pointList.add(C);
        pointList.add(D);
        this.auxiliaryCP.addThmStatement(new ConcyclicPoints(pointList));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreConcyclic", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkEqualSegments(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        this.auxiliaryCP.addThmStatement(new SegmentsOfEqualLengths(A, B, C, D));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreEqual", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkParallelLines(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        LineThroughTwoPoints AB = new LineThroughTwoPoints("AB", A, B);
        this.auxiliaryCP.addGeoConstruction(AB);
        LineThroughTwoPoints CD = new LineThroughTwoPoints("CD", C, D);
        this.auxiliaryCP.addGeoConstruction(CD);
        this.auxiliaryCP.addThmStatement(new TwoParallelLines(AB, CD));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreParallel", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkPerpendicularLines(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        LineThroughTwoPoints AB = new LineThroughTwoPoints("AB", A, B);
        this.auxiliaryCP.addGeoConstruction(AB);
        LineThroughTwoPoints CD = new LineThroughTwoPoints("CD", C, D);
        this.auxiliaryCP.addGeoConstruction(CD);
        this.auxiliaryCP.addThmStatement(new TwoPerpendicularLines(AB, CD));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("ArePerpendicular", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkHarmonicConjugatePoints(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        this.auxiliaryCP.addThmStatement(new FourHarmonicConjugatePoints(A, B, C, D));
        XPolynomial statementXPoly = ((FourHarmonicConjugatePoints)this.auxiliaryCP.getTheoremStatement()).getXAlgebraicForm();
        XPolynomial statementYPoly = ((FourHarmonicConjugatePoints)this.auxiliaryCP.getTheoremStatement()).getYAlgebraicForm();
        XPolynomial statementPoly = null;
        if (statementXPoly != null && statementYPoly != null) {
            statementPoly = (XPolynomial)statementXPoly.clone().multiplyByPolynomial(statementXPoly).addPolynomial(statementYPoly.clone().multiplyByPolynomial(statementYPoly));
        }
        if (statementXPoly != null && statementXPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial()) || statementYPoly != null && statementYPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial()) || statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreHarmonic", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkCongruentCollinearSegments(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        Segment segAB = new Segment(A, B);
        Segment segCD = new Segment(C, D);
        Vector<Segment> segments = new Vector<Segment>();
        segments.add(segAB);
        segments.add(segCD);
        Vector<Double> coefficients = new Vector<Double>();
        coefficients.add(new Double(1.0));
        coefficients.add(new Double(-1.0));
        this.auxiliaryCP.addThmStatement(new LinearCombinationOfOrientedSegments(segments, coefficients));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreCollinearCongruentSegments", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkAngleBisectorPoint(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        StringBuilder nameSB = new StringBuilder("tempAngBis_");
        nameSB.append(A.getGeoObjectLabel());
        nameSB.append(B.getGeoObjectLabel());
        nameSB.append(C.getGeoObjectLabel());
        AngleBisector angBis = new AngleBisector(nameSB.toString(), A, B, C);
        this.auxiliaryCP.addGeoConstruction(angBis);
        this.auxiliaryCP.addThmStatement(new PointOnSetOfPoints(angBis, D));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("IsOnAngleBisector", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkTwoPointsOnCircle(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        CircleWithCenterAndPoint k = new CircleWithCenterAndPoint("tempCircle", A, B);
        this.auxiliaryCP.addGeoConstruction(k);
        this.auxiliaryCP.addThmStatement(new PointOnSetOfPoints(k, C));
        XPolynomial statementPolyC = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        this.auxiliaryCP.addThmStatement(new PointOnSetOfPoints(k, D));
        XPolynomial statementPolyD = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        XPolynomial statementPoly = null;
        if (statementPolyC != null && statementPolyD != null) {
            statementPoly = (XPolynomial)statementPolyC.clone().multiplyByPolynomial(statementPolyC).addPolynomial(statementPolyD.clone().multiplyByPolynomial(statementPolyD));
        }
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreOnCircle", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkPointOnCircle(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        CircleWithCenterAndRadius k = new CircleWithCenterAndRadius("tempCircle", A, B, C);
        this.auxiliaryCP.addGeoConstruction(k);
        this.auxiliaryCP.addThmStatement(new PointOnSetOfPoints(k, D));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreOnCircle", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkInversePoints(Point A, Point B, Point C, Point D) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addGeoConstruction(D);
        CircleWithCenterAndPoint k = new CircleWithCenterAndPoint("tempCircle", A, B);
        this.auxiliaryCP.addGeoConstruction(k);
        this.auxiliaryCP.addThmStatement(new TwoInversePoints(C, D, k));
        XPolynomial statementXPoly = ((TwoInversePoints)this.auxiliaryCP.getTheoremStatement()).getXAlgebraicForm();
        XPolynomial statementYPoly = ((TwoInversePoints)this.auxiliaryCP.getTheoremStatement()).getYAlgebraicForm();
        XPolynomial statementPoly = null;
        if (statementXPoly != null && statementYPoly != null) {
            statementPoly = (XPolynomial)statementXPoly.clone().multiplyByPolynomial(statementXPoly).addPolynomial(statementYPoly.clone().multiplyByPolynomial(statementYPoly));
        }
        if (statementXPoly != null && statementXPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial()) || statementYPoly != null && statementYPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial()) || statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            pointsV.add(D);
            this.ndgCond.addNewTranslation("AreInverses", pointsV);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkPositions(Vector<Point> pointList) {
        if (pointList == null || pointList.size() != 4) {
            return false;
        }
        boolean checkResult = false;
        boolean singleCheckResult = false;
        Point A = pointList.get(0).clone();
        Point B = pointList.get(1).clone();
        Point C = pointList.get(2).clone();
        Point D = pointList.get(3).clone();
        singleCheckResult = this.checkFourCollinearPoints(A, B, C, D);
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkFourConcyclicPoints(A, B, C, D);
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkEqualSegments(A, B, C, D);
        if (!singleCheckResult && !(singleCheckResult = this.checkEqualSegments(A, C, B, D))) {
            singleCheckResult = this.checkEqualSegments(A, D, B, C);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkParallelLines(A, B, C, D);
        if (!singleCheckResult && !(singleCheckResult = this.checkParallelLines(A, C, B, D))) {
            singleCheckResult = this.checkParallelLines(A, D, B, C);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkPerpendicularLines(A, B, C, D);
        if (!singleCheckResult && !(singleCheckResult = this.checkPerpendicularLines(A, C, B, D))) {
            singleCheckResult = this.checkPerpendicularLines(A, D, B, C);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkHarmonicConjugatePoints(A, B, C, D);
        if (!singleCheckResult && !(singleCheckResult = this.checkHarmonicConjugatePoints(A, C, B, D))) {
            singleCheckResult = this.checkHarmonicConjugatePoints(A, D, B, C);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkCongruentCollinearSegments(A, B, C, D);
        if (!singleCheckResult && !(singleCheckResult = this.checkCongruentCollinearSegments(A, C, B, D))) {
            singleCheckResult = this.checkCongruentCollinearSegments(A, D, B, C);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkAngleBisectorPoint(C, A, B, D);
        if (!(singleCheckResult || (singleCheckResult = this.checkAngleBisectorPoint(A, B, C, D)) || (singleCheckResult = this.checkAngleBisectorPoint(B, C, A, D)) || (singleCheckResult = this.checkAngleBisectorPoint(D, A, B, C)) || (singleCheckResult = this.checkAngleBisectorPoint(A, B, D, C)) || (singleCheckResult = this.checkAngleBisectorPoint(B, D, A, C)) || (singleCheckResult = this.checkAngleBisectorPoint(D, A, C, B)) || (singleCheckResult = this.checkAngleBisectorPoint(A, C, D, B)) || (singleCheckResult = this.checkAngleBisectorPoint(C, D, A, B)) || (singleCheckResult = this.checkAngleBisectorPoint(D, B, C, A)) || (singleCheckResult = this.checkAngleBisectorPoint(B, C, D, A)))) {
            singleCheckResult = this.checkAngleBisectorPoint(C, D, B, A);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkTwoPointsOnCircle(A, B, C, D);
        if (!(singleCheckResult || (singleCheckResult = this.checkTwoPointsOnCircle(B, A, C, D)) || (singleCheckResult = this.checkTwoPointsOnCircle(A, C, B, D)) || (singleCheckResult = this.checkTwoPointsOnCircle(C, A, B, D)) || (singleCheckResult = this.checkTwoPointsOnCircle(A, D, B, C)) || (singleCheckResult = this.checkTwoPointsOnCircle(D, A, B, C)) || (singleCheckResult = this.checkTwoPointsOnCircle(B, C, A, D)) || (singleCheckResult = this.checkTwoPointsOnCircle(C, B, D, A)) || (singleCheckResult = this.checkTwoPointsOnCircle(B, D, A, C)) || (singleCheckResult = this.checkTwoPointsOnCircle(D, B, A, C)) || (singleCheckResult = this.checkTwoPointsOnCircle(C, D, A, B)))) {
            singleCheckResult = this.checkTwoPointsOnCircle(D, C, A, B);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkPointOnCircle(A, B, C, D);
        if (!(singleCheckResult || (singleCheckResult = this.checkPointOnCircle(A, B, D, C)) || (singleCheckResult = this.checkPointOnCircle(A, C, D, B)) || (singleCheckResult = this.checkPointOnCircle(B, A, C, D)) || (singleCheckResult = this.checkPointOnCircle(B, A, D, C)) || (singleCheckResult = this.checkPointOnCircle(B, C, D, A)) || (singleCheckResult = this.checkPointOnCircle(C, A, B, D)) || (singleCheckResult = this.checkPointOnCircle(C, A, D, B)) || (singleCheckResult = this.checkPointOnCircle(C, B, D, A)) || (singleCheckResult = this.checkPointOnCircle(D, A, B, C)) || (singleCheckResult = this.checkPointOnCircle(D, A, C, B)))) {
            singleCheckResult = this.checkPointOnCircle(D, B, C, A);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkInversePoints(A, B, C, D);
        if (!(singleCheckResult || (singleCheckResult = this.checkInversePoints(B, A, C, D)) || (singleCheckResult = this.checkInversePoints(A, C, B, D)) || (singleCheckResult = this.checkInversePoints(C, A, B, D)) || (singleCheckResult = this.checkInversePoints(A, D, B, C)) || (singleCheckResult = this.checkInversePoints(D, A, B, C)) || (singleCheckResult = this.checkInversePoints(B, C, A, D)) || (singleCheckResult = this.checkInversePoints(C, B, A, D)) || (singleCheckResult = this.checkInversePoints(B, D, A, C)) || (singleCheckResult = this.checkInversePoints(D, B, A, C)) || (singleCheckResult = this.checkInversePoints(C, D, A, B)))) {
            singleCheckResult = this.checkInversePoints(D, C, A, B);
        }
        checkResult = checkResult || singleCheckResult;
        return checkResult;
    }
}

