/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.Term;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Angle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GeneralizedAngleTangent {
    public static final String VERSION_NUM = "1.00";
    private static final String OLabel = "O";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static final String O1Label = "O1";
    private static final String A1Label = "A1";
    private static final String B1Label = "B1";
    private static final String O2Label = "O2";
    private static final String A2Label = "A2";
    private static final String B2Label = "B2";
    private static final String O3Label = "O3";
    private static final String A3Label = "A3";
    private static final String B3Label = "B3";
    public static final int TANGENT_NUMERATOR = 0;
    public static final int TANGENT_DENOMINATOR = 1;
    private static ArrayList<SymbolicPolynomial> tangentCondition = null;

    public static Map<String, Point> getPointsMapForTwoAngles(Angle alpha, Angle beta) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(O1Label, alpha.getVertex());
        pointsMap.put(A1Label, alpha.getFirstRayPoint());
        pointsMap.put(B1Label, alpha.getSecondRayPoint());
        pointsMap.put(O2Label, beta.getVertex());
        pointsMap.put(A2Label, beta.getFirstRayPoint());
        pointsMap.put(B2Label, beta.getSecondRayPoint());
        return pointsMap;
    }

    public static Map<String, Point> getPointsMapForAlgebraicSumOfThreeAngles(Angle alpha, Angle beta, Angle gamma) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(O1Label, alpha.getVertex());
        pointsMap.put(A1Label, alpha.getFirstRayPoint());
        pointsMap.put(B1Label, alpha.getSecondRayPoint());
        pointsMap.put(O2Label, beta.getVertex());
        pointsMap.put(A2Label, beta.getFirstRayPoint());
        pointsMap.put(B2Label, beta.getSecondRayPoint());
        pointsMap.put(O3Label, gamma.getVertex());
        pointsMap.put(A3Label, gamma.getFirstRayPoint());
        pointsMap.put(B3Label, gamma.getSecondRayPoint());
        return pointsMap;
    }

    public static Map<String, String> getLabelsMapForTwoAngles(String labelA1, String labelO1, String labelB1, String labelA2, String labelO2, String labelB2) {
        HashMap<String, String> labelsMap = new HashMap<String, String>();
        labelsMap.put(O1Label, labelO1);
        labelsMap.put(A1Label, labelA1);
        labelsMap.put(B1Label, labelB1);
        labelsMap.put(O2Label, labelO2);
        labelsMap.put(A2Label, labelA2);
        labelsMap.put(B2Label, labelB2);
        return labelsMap;
    }

    public static SymbolicPolynomial substitutePointLabelsForTwoAngles(SymbolicPolynomial symbPoly, String labelA1, String labelO1, String labelB1, String labelA2, String labelO2, String labelB2) {
        Map<String, String> labelsMap = GeneralizedAngleTangent.getLabelsMapForTwoAngles(labelA1, labelO1, labelB1, labelA2, labelO2, labelB2);
        return symbPoly.substitute(labelsMap);
    }

    public static ArrayList<SymbolicPolynomial> getConditionForTangent() {
        ArrayList<SymbolicPolynomial> tan = new ArrayList<SymbolicPolynomial>();
        tan.add((SymbolicPolynomial)tangentCondition.get(0).clone());
        tan.add((SymbolicPolynomial)tangentCondition.get(1).clone());
        return tan;
    }

    public static ArrayList<SymbolicPolynomial> getSubstitutedConditionForTangent(String labelA, String labelO, String labelB) {
        ArrayList<SymbolicPolynomial> tan = new ArrayList<SymbolicPolynomial>();
        HashMap<String, String> labelsMap = new HashMap<String, String>();
        labelsMap.put(OLabel, labelO);
        labelsMap.put(ALabel, labelA);
        labelsMap.put(BLabel, labelB);
        tan.add(((SymbolicPolynomial)tangentCondition.get(0).clone()).substitute(labelsMap));
        tan.add(((SymbolicPolynomial)tangentCondition.get(1).clone()).substitute(labelsMap));
        return tan;
    }

    private static ArrayList<SymbolicPolynomial> getConditionForTangentOfFirstAngle() {
        SymbolicVariable var;
        ArrayList<SymbolicPolynomial> tan = GeneralizedAngleTangent.getConditionForTangent();
        for (Term t : tan.get(0).getTermsAsDescList()) {
            for (Power p : t.getPowers()) {
                var = (SymbolicVariable)p.getVariable();
                if (var.getPointLabel().equals(OLabel)) {
                    var.setPointLabel(O1Label);
                    continue;
                }
                if (var.getPointLabel().equals(ALabel)) {
                    var.setPointLabel(A1Label);
                    continue;
                }
                if (!var.getPointLabel().equals(BLabel)) continue;
                var.setPointLabel(B1Label);
            }
        }
        for (Term t : tan.get(1).getTermsAsDescList()) {
            for (Power p : t.getPowers()) {
                var = (SymbolicVariable)p.getVariable();
                if (var.getPointLabel().equals(OLabel)) {
                    var.setPointLabel(O1Label);
                    continue;
                }
                if (var.getPointLabel().equals(ALabel)) {
                    var.setPointLabel(A1Label);
                    continue;
                }
                if (!var.getPointLabel().equals(BLabel)) continue;
                var.setPointLabel(B1Label);
            }
        }
        OpenGeoProver.settings.getLogger().debug("Condition for tangent of first angle:");
        OpenGeoProver.settings.getLogger().debug("Numerator:");
        OpenGeoProver.settings.getLogger().debug(tan.get(0).printToLaTeX());
        OpenGeoProver.settings.getLogger().debug("Denominator:");
        OpenGeoProver.settings.getLogger().debug(tan.get(1).printToLaTeX());
        return tan;
    }

    private static ArrayList<SymbolicPolynomial> getConditionForTangentOfSecondAngle() {
        SymbolicVariable var;
        ArrayList<SymbolicPolynomial> tan = GeneralizedAngleTangent.getConditionForTangent();
        for (Term t : tan.get(0).getTermsAsDescList()) {
            for (Power p : t.getPowers()) {
                var = (SymbolicVariable)p.getVariable();
                if (var.getPointLabel().equals(OLabel)) {
                    var.setPointLabel(O2Label);
                    continue;
                }
                if (var.getPointLabel().equals(ALabel)) {
                    var.setPointLabel(A2Label);
                    continue;
                }
                if (!var.getPointLabel().equals(BLabel)) continue;
                var.setPointLabel(B2Label);
            }
        }
        for (Term t : tan.get(1).getTermsAsDescList()) {
            for (Power p : t.getPowers()) {
                var = (SymbolicVariable)p.getVariable();
                if (var.getPointLabel().equals(OLabel)) {
                    var.setPointLabel(O2Label);
                    continue;
                }
                if (var.getPointLabel().equals(ALabel)) {
                    var.setPointLabel(A2Label);
                    continue;
                }
                if (!var.getPointLabel().equals(BLabel)) continue;
                var.setPointLabel(B2Label);
            }
        }
        OpenGeoProver.settings.getLogger().debug("Condition for tangent of second angle:");
        OpenGeoProver.settings.getLogger().debug("Numerator:");
        OpenGeoProver.settings.getLogger().debug(tan.get(0).printToLaTeX());
        OpenGeoProver.settings.getLogger().debug("Denominator:");
        OpenGeoProver.settings.getLogger().debug(tan.get(1).printToLaTeX());
        return tan;
    }

    private static ArrayList<SymbolicPolynomial> getConditionForTangentOfThirdAngle() {
        SymbolicVariable var;
        ArrayList<SymbolicPolynomial> tan = GeneralizedAngleTangent.getConditionForTangent();
        for (Term t : tan.get(0).getTermsAsDescList()) {
            for (Power p : t.getPowers()) {
                var = (SymbolicVariable)p.getVariable();
                if (var.getPointLabel().equals(OLabel)) {
                    var.setPointLabel(O3Label);
                    continue;
                }
                if (var.getPointLabel().equals(ALabel)) {
                    var.setPointLabel(A3Label);
                    continue;
                }
                if (!var.getPointLabel().equals(BLabel)) continue;
                var.setPointLabel(B3Label);
            }
        }
        for (Term t : tan.get(1).getTermsAsDescList()) {
            for (Power p : t.getPowers()) {
                var = (SymbolicVariable)p.getVariable();
                if (var.getPointLabel().equals(OLabel)) {
                    var.setPointLabel(O3Label);
                    continue;
                }
                if (var.getPointLabel().equals(ALabel)) {
                    var.setPointLabel(A3Label);
                    continue;
                }
                if (!var.getPointLabel().equals(BLabel)) continue;
                var.setPointLabel(B3Label);
            }
        }
        OpenGeoProver.settings.getLogger().debug("Condition for tangent of third angle:");
        OpenGeoProver.settings.getLogger().debug("Numerator:");
        OpenGeoProver.settings.getLogger().debug(tan.get(0).printToLaTeX());
        OpenGeoProver.settings.getLogger().debug("Denominator:");
        OpenGeoProver.settings.getLogger().debug(tan.get(1).printToLaTeX());
        return tan;
    }

    public static SymbolicPolynomial getConditionForTangentsDifference() {
        ArrayList<SymbolicPolynomial> tanA1O1B1 = GeneralizedAngleTangent.getConditionForTangentOfFirstAngle();
        ArrayList<SymbolicPolynomial> tanA2O2B2 = GeneralizedAngleTangent.getConditionForTangentOfSecondAngle();
        return (SymbolicPolynomial)tanA1O1B1.get(0).clone().multiplyByPolynomial(tanA2O2B2.get(1)).subtractPolynomial(tanA2O2B2.get(0).clone().multiplyByPolynomial(tanA1O1B1.get(1)));
    }

    public static SymbolicPolynomial getConditionForTangentsSum() {
        ArrayList<SymbolicPolynomial> tanA1O1B1 = GeneralizedAngleTangent.getConditionForTangentOfFirstAngle();
        ArrayList<SymbolicPolynomial> tanA2O2B2 = GeneralizedAngleTangent.getConditionForTangentOfSecondAngle();
        return (SymbolicPolynomial)tanA1O1B1.get(0).clone().multiplyByPolynomial(tanA2O2B2.get(1)).addPolynomial(tanA2O2B2.get(0).clone().multiplyByPolynomial(tanA1O1B1.get(1)));
    }

    public static ArrayList<SymbolicPolynomial> getConditionForTangentOfSum() {
        ArrayList<SymbolicPolynomial> tanSum = new ArrayList<SymbolicPolynomial>();
        ArrayList<SymbolicPolynomial> tanA1O1B1 = GeneralizedAngleTangent.getConditionForTangentOfFirstAngle();
        ArrayList<SymbolicPolynomial> tanA2O2B2 = GeneralizedAngleTangent.getConditionForTangentOfSecondAngle();
        SymbolicPolynomial numerator = (SymbolicPolynomial)tanA1O1B1.get(0).clone().multiplyByPolynomial(tanA2O2B2.get(1)).addPolynomial(tanA2O2B2.get(0).clone().multiplyByPolynomial(tanA1O1B1.get(1)));
        SymbolicPolynomial denominator = (SymbolicPolynomial)tanA1O1B1.get(1).clone().multiplyByPolynomial(tanA2O2B2.get(1)).subtractPolynomial(tanA1O1B1.get(0).clone().multiplyByPolynomial(tanA2O2B2.get(0)));
        tanSum.add(numerator);
        tanSum.add(denominator);
        return tanSum;
    }

    public static ArrayList<SymbolicPolynomial> getSubstitutedConditionForTangentOfSumOfThreeAngles(String labelA1, String labelO1, String labelB1, String labelA2, String labelO2, String labelB2, String labelA3, String labelO3, String labelB3) {
        ArrayList<SymbolicPolynomial> tanSum = new ArrayList<SymbolicPolynomial>();
        ArrayList<SymbolicPolynomial> tanA1O1B1 = GeneralizedAngleTangent.getConditionForTangentOfFirstAngle();
        ArrayList<SymbolicPolynomial> tanA2O2B2 = GeneralizedAngleTangent.getConditionForTangentOfSecondAngle();
        ArrayList<SymbolicPolynomial> tanA3O3B3 = GeneralizedAngleTangent.getConditionForTangentOfThirdAngle();
        SymbolicPolynomial one = new SymbolicPolynomial(1.0);
        SymbolicPolynomial nx = tanA1O1B1.get(0);
        SymbolicPolynomial dx = tanA1O1B1.get(1);
        SymbolicPolynomial ny = tanA2O2B2.get(0);
        SymbolicPolynomial dy = tanA2O2B2.get(1);
        SymbolicPolynomial nz = tanA3O3B3.get(0);
        SymbolicPolynomial dz = tanA3O3B3.get(1);
        SymbolicPolynomial N = new SymbolicPolynomial();
        SymbolicPolynomial temp = (SymbolicPolynomial)one.clone().multiplyByPolynomial(nx).multiplyByPolynomial(dy).multiplyByPolynomial(dz);
        N.addPolynomial(temp);
        temp = (SymbolicPolynomial)one.clone().multiplyByPolynomial(dx).multiplyByPolynomial(ny).multiplyByPolynomial(dz);
        N.addPolynomial(temp);
        temp = (SymbolicPolynomial)one.clone().multiplyByPolynomial(dx).multiplyByPolynomial(dy).multiplyByPolynomial(nz);
        N.addPolynomial(temp);
        temp = (SymbolicPolynomial)one.clone().multiplyByPolynomial(nx).multiplyByPolynomial(ny).multiplyByPolynomial(nz);
        N.subtractPolynomial(temp);
        SymbolicPolynomial D = new SymbolicPolynomial();
        temp = (SymbolicPolynomial)one.clone().multiplyByPolynomial(dx).multiplyByPolynomial(dy).multiplyByPolynomial(dz);
        D.addPolynomial(temp);
        temp = (SymbolicPolynomial)one.clone().multiplyByPolynomial(nx).multiplyByPolynomial(ny).multiplyByPolynomial(dz);
        D.subtractPolynomial(temp);
        temp = (SymbolicPolynomial)one.clone().multiplyByPolynomial(nx).multiplyByPolynomial(dy).multiplyByPolynomial(nz);
        D.subtractPolynomial(temp);
        temp = (SymbolicPolynomial)one.clone().multiplyByPolynomial(dx).multiplyByPolynomial(ny).multiplyByPolynomial(nz);
        D.subtractPolynomial(temp);
        HashMap<String, String> labelsMap = new HashMap<String, String>();
        labelsMap.put(A1Label, labelA1);
        labelsMap.put(O1Label, labelO1);
        labelsMap.put(B1Label, labelB1);
        labelsMap.put(A2Label, labelA2);
        labelsMap.put(O2Label, labelO2);
        labelsMap.put(B2Label, labelB2);
        labelsMap.put(A3Label, labelA3);
        labelsMap.put(O3Label, labelO3);
        labelsMap.put(B3Label, labelB3);
        tanSum.add(N.substitute(labelsMap));
        tanSum.add(D.substitute(labelsMap));
        return tanSum;
    }

    public static SymbolicPolynomial getConditionForTripleAngle() {
        ArrayList<SymbolicPolynomial> tanA1O1B1 = GeneralizedAngleTangent.getConditionForTangentOfFirstAngle();
        ArrayList<SymbolicPolynomial> tanA2O2B2 = GeneralizedAngleTangent.getConditionForTangentOfSecondAngle();
        SymbolicPolynomial n1 = tanA1O1B1.get(0);
        SymbolicPolynomial d1 = tanA1O1B1.get(1);
        SymbolicPolynomial n2 = tanA2O2B2.get(0);
        SymbolicPolynomial d2 = tanA2O2B2.get(1);
        SymbolicTerm coeff3 = new SymbolicTerm(3.0);
        return (SymbolicPolynomial)n1.multiplyByPolynomial(d2.clone().multiplyByPolynomial(d2.clone().multiplyByPolynomial(d2)).subtractPolynomial(n2.clone().multiplyByPolynomial(n2).multiplyByPolynomial(d2).multiplyByTerm(coeff3))).subtractPolynomial(d1.multiplyByPolynomial(n2.clone().multiplyByPolynomial(d2.clone().multiplyByPolynomial(d2)).multiplyByTerm(coeff3).subtractPolynomial(n2.clone().multiplyByPolynomial(n2.clone().multiplyByPolynomial(n2)))));
    }

    public static SymbolicPolynomial getConditionForAlgebraicSumOfThreeAngles() {
        ArrayList<SymbolicPolynomial> tanSum = GeneralizedAngleTangent.getConditionForTangentOfSum();
        ArrayList<SymbolicPolynomial> tan3 = GeneralizedAngleTangent.getConditionForTangentOfThirdAngle();
        return (SymbolicPolynomial)tanSum.get(0).clone().multiplyByPolynomial(tan3.get(1)).subtractPolynomial(tan3.get(0).clone().multiplyByPolynomial(tanSum.get(1)));
    }

    public static SymbolicPolynomial getConditionForEqualsConvexAngles() {
        return GeneralizedAngleTangent.getConditionForTangentsDifference();
    }

    public static SymbolicPolynomial getConditionForSupplementaryConvexAngles() {
        return GeneralizedAngleTangent.getConditionForTangentsSum();
    }

    public static SymbolicPolynomial getConditionForEqualsOrSupplementaryConvexAngles() {
        return (SymbolicPolynomial)GeneralizedAngleTangent.getConditionForTangentsDifference().multiplyByPolynomial(GeneralizedAngleTangent.getConditionForTangentsSum());
    }

    static {
        if (tangentCondition == null) {
            tangentCondition = new ArrayList();
            SymbolicPolynomial numerator = new SymbolicPolynomial();
            SymbolicPolynomial denominator = new SymbolicPolynomial();
            SymbolicVariable xO = new SymbolicVariable(2, OLabel);
            SymbolicVariable yO = new SymbolicVariable(3, OLabel);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(yB, 1));
            numerator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xO, 1));
            t.addPower(new Power(yB, 1));
            numerator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(yO, 1));
            numerator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(yA, 1));
            numerator.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xO, 1));
            t.addPower(new Power(yA, 1));
            numerator.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(yO, 1));
            numerator.addTerm(t);
            tangentCondition.add(numerator);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(xB, 1));
            denominator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(xO, 1));
            denominator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(xO, 1));
            denominator.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xO, 2));
            denominator.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(yB, 1));
            denominator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(yO, 1));
            denominator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yB, 1));
            t.addPower(new Power(yO, 1));
            denominator.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yO, 2));
            denominator.addTerm(t);
            tangentCondition.add(denominator);
        }
    }
}

