/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.pp.tp.geoconstruction.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class PointListManager {
    public static final String VERSION_NUM = "1.00";

    public static Vector<Vector<Point>> createListOfCombinations(Vector<Point> pointList) {
        if (pointList == null) {
            return null;
        }
        Vector<Vector<Point>> combinations = new Vector<Vector<Point>>();
        if (pointList.size() == 0) {
            return combinations;
        }
        int n = pointList.size();
        for (int len = 1; len <= n; ++len) {
            Vector<Integer> indexV = new Vector<Integer>(len);
            for (int ii = 0; ii < len; ++ii) {
                indexV.add(new Integer(-1));
            }
            int iCurrIdx = 0;
            while (iCurrIdx >= 0) {
                int currVal = (Integer)indexV.get(iCurrIdx);
                int newVal = currVal + 1;
                if (newVal >= n) {
                    --iCurrIdx;
                    continue;
                }
                if (len - iCurrIdx - 1 + newVal >= n) {
                    --iCurrIdx;
                    continue;
                }
                indexV.set(iCurrIdx, new Integer(newVal));
                if (iCurrIdx == len - 1) {
                    Vector<Point> ptsCombination = new Vector<Point>();
                    for (int jj = 0; jj < len; ++jj) {
                        ptsCombination.add(pointList.get((Integer)indexV.get(jj)));
                    }
                    combinations.add(ptsCombination);
                    continue;
                }
                indexV.set(++iCurrIdx, new Integer(newVal));
            }
        }
        return combinations;
    }

    public static String getPointListKey(Vector<Point> pointList) {
        if (pointList == null) {
            return null;
        }
        if (pointList.size() == 0) {
            return "";
        }
        TreeMap<String, Point> pointTree = new TreeMap<String, Point>();
        for (Point pt : pointList) {
            pointTree.put(pt.getGeoObjectLabel(), pt);
        }
        StringBuilder sb = new StringBuilder();
        for (Point pt : pointTree.values()) {
            sb.append(pt.getGeoObjectLabel());
        }
        return sb.toString();
    }

    public static Vector<Point> mergePointLists(Vector<Point> firstV, Vector<Point> secondV) {
        Collection destinationC;
        HashMap<String, Point> destinationM = new HashMap<String, Point>();
        if (firstV != null) {
            for (Point P : firstV) {
                destinationM.put(P.getGeoObjectLabel(), P);
            }
        }
        if (secondV != null) {
            for (Point P : secondV) {
                destinationM.put(P.getGeoObjectLabel(), P);
            }
        }
        if ((destinationC = destinationM.values()) == null) {
            return null;
        }
        return new Vector<Point>(destinationC);
    }

    public static Vector<Vector<Point>> mergePairsOfPointCombinations(Vector<Vector<Point>> firstComb, Vector<Vector<Point>> secondComb) {
        if (firstComb == null) {
            return secondComb;
        }
        if (secondComb == null) {
            return firstComb;
        }
        HashMap<String, Vector<Point>> destinationM = new HashMap<String, Vector<Point>>();
        for (Vector<Point> comb1 : firstComb) {
            for (Vector<Point> comb2 : secondComb) {
                Vector<Point> mergeComb = PointListManager.mergePointLists(comb1, comb2);
                String combKey = PointListManager.getPointListKey(mergeComb);
                destinationM.put(combKey, mergeComb);
            }
        }
        Collection destinationC = destinationM.values();
        if (destinationC == null) {
            return null;
        }
        return new Vector<Vector<Point>>(destinationC);
    }
}

