/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;
import com.ogprover.polynomials.XPolySystem;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.utilities.logger.ILogger;
import java.util.HashMap;
import java.util.Map;

public class PointSetRelationshipManager {
    public static final String VERSION_NUM = "1.00";
    private SetOfPoints set = null;
    private Point point = null;
    private boolean errorFlag = false;
    private SymbolicPolynomial condition = null;
    private Map<String, Point> bestPointsForInstantiation = null;
    private XPolynomial bestInstantiatedPolynomial = null;
    private int degreeOfBestInstantiatedPolynomial = 0;
    private Variable xCoord = null;
    private Variable yCoord = null;
    private int managerType;
    public static final int MANAGER_TYPE_CONSTRUCTION = 0;
    public static final int MANAGER_TYPE_STATEMENT = 1;

    public void setSet(SetOfPoints set) {
        this.set = set;
    }

    public SetOfPoints getSet() {
        return this.set;
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    public Point getPoint() {
        return this.point;
    }

    public void setErrorFlag(boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public boolean isErrorFlag() {
        return this.errorFlag;
    }

    public void setCondition(SymbolicPolynomial condition) {
        this.condition = condition;
    }

    public SymbolicPolynomial getCondition() {
        return this.condition;
    }

    public void setBestPointsForInstantiation(Map<String, Point> bestPointsForInstantiation) {
        this.bestPointsForInstantiation = bestPointsForInstantiation;
    }

    public Map<String, Point> getBestPointsForInstantiation() {
        return this.bestPointsForInstantiation;
    }

    public void setBestInstantiatedPolynomial(XPolynomial bestInstantiatedPolynomial) {
        this.bestInstantiatedPolynomial = bestInstantiatedPolynomial;
    }

    public XPolynomial getBestInstantiatedPolynomial() {
        return this.bestInstantiatedPolynomial;
    }

    public void setDegreeOfBestInstantiatedPolynomial(int degreeOfBestInstantiatedPolynomial) {
        this.degreeOfBestInstantiatedPolynomial = degreeOfBestInstantiatedPolynomial;
    }

    public int getDegreeOfBestInstantiatedPolynomial() {
        return this.degreeOfBestInstantiatedPolynomial;
    }

    public void setxCoord(Variable xCoord) {
        this.xCoord = xCoord;
    }

    public Variable getxCoord() {
        return this.xCoord;
    }

    public void setyCoord(Variable yCoord) {
        this.yCoord = yCoord;
    }

    public Variable getyCoord() {
        return this.yCoord;
    }

    public void setManagerType(int managerType) {
        this.managerType = managerType;
    }

    public int getManagerType() {
        return this.managerType;
    }

    public PointSetRelationshipManager(SetOfPoints set, Point point) {
        this.set = set;
        this.setPoint(point);
        this.managerType = 0;
    }

    public PointSetRelationshipManager(SetOfPoints set, Point point, int managerType) {
        this.set = set;
        this.setPoint(point);
        this.managerType = managerType;
    }

    public void clear() {
        this.bestInstantiatedPolynomial = null;
        this.degreeOfBestInstantiatedPolynomial = 0;
        this.bestPointsForInstantiation = null;
        this.condition = null;
        this.errorFlag = false;
    }

    public XPolynomial retrieveInstantiatedCondition() {
        int oldIndex = -1;
        if (this.managerType == 1) {
            oldIndex = this.point.getIndex();
            this.point.setIndex(1000000);
        }
        this.set.findBestPointsForInstantation(this);
        if (this.managerType == 1) {
            this.point.setIndex(oldIndex);
        }
        return this.bestInstantiatedPolynomial;
    }

    public void prepareForFirstInstantiation() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (this.point.getPointState() == 0) {
            logger.error("Point not yet instantiated");
            this.setErrorFlag(true);
            return;
        }
        this.xCoord = this.point.getX().clone();
        this.yCoord = this.point.getY().clone();
        this.point.setPointState(4);
        this.clear();
    }

    public void processPointsAndCondition(Map<String, Point> pointsMap) {
        if (this.managerType == 0) {
            this.processPointsAndConditionForConstruction(pointsMap);
        } else if (this.managerType == 1) {
            this.processPointsAndConditionForStatement(pointsMap);
        } else {
            OpenGeoProver.settings.getLogger().error("Wrong manager type!");
        }
    }

    public void processPointsAndConditionForConstruction(Map<String, Point> pointsMap) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        Map<String, Point> bestElements = this.getBestPointsForInstantiation();
        XPolynomial bestPolynomial = this.getBestInstantiatedPolynomial();
        XPolynomial insCondition1 = OGPTP.instantiateCondition(this.condition, pointsMap).reduceByUTermDivision();
        int retCode = this.point.processConstructionPolynomial(insCondition1, false);
        block0 : switch (retCode) {
            case -1: 
            case 0: {
                logger.error("Error or bad polynomial instantiated when was searching for best elements");
                this.setErrorFlag(true);
                return;
            }
            case 1: {
                logger.info("Wrong polynomial but will try again");
                this.point.getConsProtocol().decrementUIndex();
                this.point.getConsProtocol().decrementXIndex();
                if (this.point.getInstanceType() == 1) {
                    this.point.getConsProtocol().instantiatePoint(this.point, 2);
                } else if (this.point.getInstanceType() == 2) {
                    this.point.getConsProtocol().instantiatePoint(this.point, 1);
                } else {
                    logger.error("Wrong instance type of point");
                    this.setErrorFlag(true);
                    return;
                }
                this.xCoord = this.point.getX().clone();
                this.yCoord = this.point.getY().clone();
                XPolynomial insCondition2 = OGPTP.instantiateCondition(this.condition, pointsMap).reduceByUTermDivision();
                int newRetCode = this.point.processConstructionPolynomial(insCondition2, false);
                switch (newRetCode) {
                    case -1: 
                    case 0: 
                    case 1: {
                        logger.error("Error or bad polynomial instantiated when was searching for best elements in second attempt");
                        this.setErrorFlag(true);
                        return;
                    }
                    case 3: {
                        logger.info("Found best elements in second attempt that will rename coordinates of point " + this.point.getGeoObjectLabel());
                        if (bestElements == null) {
                            bestElements = new HashMap<String, Point>();
                            this.setBestPointsForInstantiation(bestElements);
                        }
                        bestPolynomial = insCondition2;
                        this.setBestInstantiatedPolynomial(bestPolynomial);
                        this.setDegreeOfBestInstantiatedPolynomial(bestPolynomial.getPolynomialDegree());
                        for (String key : pointsMap.keySet()) {
                            String newKey = new String(key);
                            bestElements.put(newKey, pointsMap.get(key).clone());
                        }
                        this.point.setX((UXVariable)this.xCoord.clone());
                        this.point.setY((UXVariable)this.yCoord.clone());
                        this.point.getConsProtocol().incrementXIndex();
                        return;
                    }
                    case 2: {
                        logger.info("Found elements in second attempt that will generate new polynomial that will be added to system of hypotheses");
                        XPolySystem system = this.point.getConsProtocol().getAlgebraicGeoTheorem().getHypotheses();
                        system.removePoly(system.getPolynomials().size() - 1);
                        if (bestElements == null) {
                            bestElements = new HashMap<String, Point>();
                            this.setBestPointsForInstantiation(bestElements);
                        }
                        if (bestPolynomial == null) {
                            bestPolynomial = insCondition2;
                            this.setBestInstantiatedPolynomial(bestPolynomial);
                            this.setDegreeOfBestInstantiatedPolynomial(bestPolynomial.getPolynomialDegree());
                            for (String key : pointsMap.keySet()) {
                                String newKey = new String(key);
                                bestElements.put(newKey, pointsMap.get(key).clone());
                            }
                        } else {
                            int condDegree = insCondition2.getPolynomialDegree();
                            if (condDegree >= this.getDegreeOfBestInstantiatedPolynomial() && (condDegree != this.getDegreeOfBestInstantiatedPolynomial() || insCondition2.getTerms().size() >= bestPolynomial.getTerms().size())) break block0;
                            bestPolynomial = insCondition2;
                            this.setBestInstantiatedPolynomial(bestPolynomial);
                            this.setDegreeOfBestInstantiatedPolynomial(condDegree);
                            for (String key : pointsMap.keySet()) {
                                String newKey = new String(key);
                                bestElements.put(newKey, pointsMap.get(key).clone());
                            }
                        }
                        break block0;
                    }
                    default: {
                        logger.error("Unknown return result from processing of condition in second attempt");
                        this.setErrorFlag(true);
                        return;
                    }
                }
            }
            case 3: {
                logger.info("Found best elements that will rename coordinates of point " + this.point.getGeoObjectLabel());
                if (bestElements == null) {
                    bestElements = new HashMap<String, Point>();
                    this.setBestPointsForInstantiation(bestElements);
                }
                bestPolynomial = insCondition1;
                this.setBestInstantiatedPolynomial(bestPolynomial);
                this.setDegreeOfBestInstantiatedPolynomial(bestPolynomial.getPolynomialDegree());
                for (String key : pointsMap.keySet()) {
                    String newKey = new String(key);
                    bestElements.put(newKey, pointsMap.get(key).clone());
                }
                this.point.setX((UXVariable)this.xCoord.clone());
                this.point.setY((UXVariable)this.yCoord.clone());
                this.point.getConsProtocol().incrementXIndex();
                return;
            }
            case 2: {
                logger.info("Found elements that will generate new polynomial that will be added to system of hypotheses");
                XPolySystem system = this.point.getConsProtocol().getAlgebraicGeoTheorem().getHypotheses();
                system.removePoly(system.getPolynomials().size() - 1);
                if (bestElements == null) {
                    bestElements = new HashMap<String, Point>();
                    this.setBestPointsForInstantiation(bestElements);
                }
                if (bestPolynomial == null) {
                    bestPolynomial = insCondition1;
                    this.setBestInstantiatedPolynomial(bestPolynomial);
                    this.setDegreeOfBestInstantiatedPolynomial(bestPolynomial.getPolynomialDegree());
                    for (String key : pointsMap.keySet()) {
                        String newKey = new String(key);
                        bestElements.put(newKey, pointsMap.get(key).clone());
                    }
                } else {
                    int condDegree = insCondition1.getPolynomialDegree();
                    if (condDegree >= this.getDegreeOfBestInstantiatedPolynomial() && (condDegree != this.getDegreeOfBestInstantiatedPolynomial() || insCondition1.getTerms().size() >= bestPolynomial.getTerms().size())) break;
                    bestPolynomial = insCondition1;
                    this.setBestInstantiatedPolynomial(bestPolynomial);
                    this.setDegreeOfBestInstantiatedPolynomial(condDegree);
                    for (String key : pointsMap.keySet()) {
                        String newKey = new String(key);
                        bestElements.put(newKey, pointsMap.get(key).clone());
                    }
                }
                break;
            }
            default: {
                logger.error("Unknown return result from processing of condition");
                this.setErrorFlag(true);
                return;
            }
        }
    }

    public void processPointsAndConditionForStatement(Map<String, Point> pointsMap) {
        block4: {
            XPolynomial insCondition;
            XPolynomial bestPolynomial;
            Map<String, Point> bestElements;
            block3: {
                bestElements = this.getBestPointsForInstantiation();
                bestPolynomial = this.getBestInstantiatedPolynomial();
                insCondition = OGPTP.instantiateCondition(this.condition, pointsMap);
                if (bestElements == null) {
                    bestElements = new HashMap<String, Point>();
                    this.setBestPointsForInstantiation(bestElements);
                }
                if (bestPolynomial != null) break block3;
                this.setBestInstantiatedPolynomial(insCondition);
                this.setDegreeOfBestInstantiatedPolynomial(insCondition.getPolynomialDegree());
                for (String key : pointsMap.keySet()) {
                    String newKey = new String(key);
                    bestElements.put(newKey, pointsMap.get(key).clone());
                }
                break block4;
            }
            int condDegree = insCondition.getPolynomialDegree();
            if (condDegree >= this.getDegreeOfBestInstantiatedPolynomial() && (condDegree != this.getDegreeOfBestInstantiatedPolynomial() || insCondition.getTerms().size() >= bestPolynomial.getTerms().size())) break block4;
            this.setBestInstantiatedPolynomial(insCondition);
            this.setDegreeOfBestInstantiatedPolynomial(condDegree);
            for (String key : pointsMap.keySet()) {
                String newKey = new String(key);
                bestElements.put(newKey, pointsMap.get(key).clone());
            }
        }
    }
}

