/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.polynomials.XTerm;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import java.util.HashMap;

public class RatioOfTwoCollinearSegments {
    public static final String VERSION_NUM = "1.00";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static final String CLabel = "C";
    private static final String DLabel = "D";
    private static SymbolicPolynomial xNumerator;
    private static SymbolicPolynomial yNumerator;
    private static SymbolicPolynomial xDenominator;
    private static SymbolicPolynomial yDenominator;
    private XPolynomial numerator = null;
    private XPolynomial denominator = null;
    private Segment numeratorSegment = null;
    private Segment denominatorSegment = null;

    public void setNumerator(XPolynomial numerator) {
        this.numerator = numerator;
    }

    public XPolynomial getNumerator() {
        return this.numerator;
    }

    public void setDenominator(XPolynomial denominator) {
        this.denominator = denominator;
    }

    public XPolynomial getDenominator() {
        return this.denominator;
    }

    public void setNumeratorSegment(Segment numeratorSegment) {
        this.numeratorSegment = numeratorSegment;
    }

    public Segment getNumeratorSegment() {
        return this.numeratorSegment;
    }

    public void setDenominatorSegment(Segment denominatorSegment) {
        this.denominatorSegment = denominatorSegment;
    }

    public Segment getDenominatorSegment() {
        return this.denominatorSegment;
    }

    public RatioOfTwoCollinearSegments(Segment numerator, Segment denominator) {
        this.numeratorSegment = numerator;
        this.denominatorSegment = denominator;
        this.numerator = new XPolynomial();
        this.numerator.addTerm(new XTerm(1.0));
        this.denominator = new XPolynomial();
        this.denominator.addTerm(new XTerm(1.0));
    }

    public RatioOfTwoCollinearSegments(Point A, Point B, Point C, Point D) {
        this.numeratorSegment = new Segment(A, B);
        this.denominatorSegment = new Segment(C, D);
        this.numerator = new XPolynomial();
        this.numerator.addTerm(new XTerm(1.0));
        this.denominator = new XPolynomial();
        this.denominator.addTerm(new XTerm(1.0));
    }

    public RatioOfTwoCollinearSegments(Point A, Point B, Point C) {
        this.numeratorSegment = new Segment(A, C);
        this.denominatorSegment = new Segment(C, B);
        this.numerator = new XPolynomial();
        this.numerator.addTerm(new XTerm(1.0));
        this.denominator = new XPolynomial();
        this.denominator.addTerm(new XTerm(1.0));
    }

    public void transformToAlgebraicForm() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, this.numeratorSegment.getFirstEndPoint());
        pointsMap.put(BLabel, this.numeratorSegment.getSecondEndPoint());
        pointsMap.put(CLabel, this.denominatorSegment.getFirstEndPoint());
        pointsMap.put(DLabel, this.denominatorSegment.getSecondEndPoint());
        UXVariable xA = this.numeratorSegment.getFirstEndPoint().getX();
        UXVariable xB = this.numeratorSegment.getSecondEndPoint().getX();
        if (((Variable)xA).getVariableType() == ((Variable)xB).getVariableType() && xA.getIndex() == xB.getIndex()) {
            this.numerator = OGPTP.instantiateCondition(yNumerator, pointsMap);
            this.denominator = OGPTP.instantiateCondition(yDenominator, pointsMap);
        } else {
            this.numerator = OGPTP.instantiateCondition(xNumerator, pointsMap);
            this.denominator = OGPTP.instantiateCondition(xDenominator, pointsMap);
        }
    }

    static {
        SymbolicTerm t;
        xNumerator = null;
        yNumerator = null;
        xDenominator = null;
        yDenominator = null;
        if (xNumerator == null) {
            xNumerator = new SymbolicPolynomial();
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xB, 1));
            xNumerator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            xNumerator.addTerm(t);
        }
        if (yNumerator == null) {
            yNumerator = new SymbolicPolynomial();
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yB, 1));
            yNumerator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA, 1));
            yNumerator.addTerm(t);
        }
        if (xDenominator == null) {
            xDenominator = new SymbolicPolynomial();
            SymbolicVariable xC = new SymbolicVariable(2, CLabel);
            SymbolicVariable xD = new SymbolicVariable(2, DLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xD, 1));
            xDenominator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xC, 1));
            xDenominator.addTerm(t);
        }
        if (yDenominator == null) {
            yDenominator = new SymbolicPolynomial();
            SymbolicVariable yC = new SymbolicVariable(3, CLabel);
            SymbolicVariable yD = new SymbolicVariable(3, DLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yD, 1));
            yDenominator.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yC, 1));
            yDenominator.addTerm(t);
        }
    }
}

