/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.polynomials.XPolynomial;
import com.ogprover.polynomials.XTerm;
import com.ogprover.pp.tp.auxiliary.RatioOfTwoCollinearSegments;
import java.util.Vector;

public class RatioProduct {
    public static final String VERSION_NUM = "1.00";
    private Vector<RatioOfTwoCollinearSegments> ratios = null;
    private XPolynomial numerator = null;
    private XPolynomial denominator = null;
    private boolean instantiated = false;

    public void setRatios(Vector<RatioOfTwoCollinearSegments> ratios) {
        this.ratios = ratios;
    }

    public Vector<RatioOfTwoCollinearSegments> getRatios() {
        return this.ratios;
    }

    public void setNumerator(XPolynomial numerator) {
        this.numerator = numerator;
    }

    public XPolynomial getNumerator() {
        return this.numerator;
    }

    public void setDenominator(XPolynomial denominator) {
        this.denominator = denominator;
    }

    public XPolynomial getDenominator() {
        return this.denominator;
    }

    public void setInstantiated(boolean instantiated) {
        this.instantiated = instantiated;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    public RatioProduct(Vector<RatioOfTwoCollinearSegments> ratios) {
        this.ratios = ratios;
        this.numerator = new XPolynomial();
        this.numerator.addTerm(new XTerm(1.0));
        this.denominator = new XPolynomial();
        this.denominator.addTerm(new XTerm(1.0));
        this.instantiated = false;
    }

    public RatioProduct() {
        this(null);
    }

    public void transformToAlgebraicForm() {
        if (this.instantiated) {
            return;
        }
        if (this.ratios != null) {
            for (RatioOfTwoCollinearSegments ratio : this.ratios) {
                ratio.transformToAlgebraicForm();
                this.numerator.multiplyByPolynomial(ratio.getNumerator());
                this.denominator.multiplyByPolynomial(ratio.getDenominator());
            }
        }
        this.instantiated = true;
    }
}

