/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointsPositionChecker;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndPoint;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.PerpendicularBisector;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.pp.tp.ndgcondition.AlgebraicNDGCondition;
import com.ogprover.pp.tp.thmstatement.AlgebraicSumOfThreeSegments;
import com.ogprover.pp.tp.thmstatement.CollinearPoints;
import com.ogprover.pp.tp.thmstatement.PointOnSetOfPoints;
import com.ogprover.pp.tp.thmstatement.RatioOfOrientedSegments;
import com.ogprover.pp.tp.thmstatement.TwoPerpendicularLines;
import java.util.ArrayList;
import java.util.Vector;

public class ThreePointsPositionChecker
extends PointsPositionChecker {
    public static final String VERSION_NUM = "1.00";

    public ThreePointsPositionChecker(AlgebraicNDGCondition ndgCond) {
        this.initializePointsPositionChecker(ndgCond);
    }

    private boolean checkThreeCollinearPoints(Point A, Point B, Point C) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        ArrayList<Point> pointList = new ArrayList<Point>();
        pointList.add(A);
        pointList.add(B);
        pointList.add(C);
        this.auxiliaryCP.addThmStatement(new CollinearPoints(pointList));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            this.ndgCond.addNewTranslation("AreCollinear", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkMidPoint(Point A, Point B, Point C) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        Segment AC = new Segment(A, C);
        Segment CB = new Segment(C, B);
        this.auxiliaryCP.addThmStatement(new RatioOfOrientedSegments(AC, CB, 1.0));
        XPolynomial statementXPoly = ((RatioOfOrientedSegments)this.auxiliaryCP.getTheoremStatement()).getXAlgebraicForm();
        XPolynomial statementYPoly = ((RatioOfOrientedSegments)this.auxiliaryCP.getTheoremStatement()).getYAlgebraicForm();
        XPolynomial statementPoly = null;
        if (statementXPoly != null && statementYPoly != null) {
            statementPoly = (XPolynomial)statementXPoly.clone().multiplyByPolynomial(statementXPoly).addPolynomial(statementYPoly.clone().multiplyByPolynomial(statementYPoly));
        }
        if (statementXPoly != null && statementXPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial()) || statementYPoly != null && statementYPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial()) || statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            this.ndgCond.addNewTranslation("IsMidpointOf", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkPerpBisectorPoint(Point A, Point B, Point C) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        PerpendicularBisector perpB = new PerpendicularBisector("perpB", A, B);
        this.auxiliaryCP.addGeoConstruction(perpB);
        this.auxiliaryCP.addThmStatement(new PointOnSetOfPoints(perpB, C));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            this.ndgCond.addNewTranslation("IsOnBisector", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkRightAngle(Point A, Point B, Point C) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        LineThroughTwoPoints AC = new LineThroughTwoPoints("AC", A, C);
        this.auxiliaryCP.addGeoConstruction(AC);
        LineThroughTwoPoints BC = new LineThroughTwoPoints("BC", B, C);
        this.auxiliaryCP.addGeoConstruction(BC);
        this.auxiliaryCP.addThmStatement(new TwoPerpendicularLines(AC, BC));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            this.ndgCond.addNewTranslation("ArePerpendicular", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkPointOnCircle(Point A, Point B, Point C) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        CircleWithCenterAndPoint k = new CircleWithCenterAndPoint("k", A, B);
        this.auxiliaryCP.addGeoConstruction(k);
        this.auxiliaryCP.addThmStatement(new PointOnSetOfPoints(k, C));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            this.ndgCond.addNewTranslation("IsOnCircle", pointsV);
            return true;
        }
        return false;
    }

    private boolean checkAlgebraicSumOfThreeSegments(Point A, Point B, Point C) {
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addGeoConstruction(C);
        this.auxiliaryCP.addThmStatement(new AlgebraicSumOfThreeSegments(A, B, A, C, C, B));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            Vector<Point> pointsV = new Vector<Point>();
            pointsV.add(A);
            pointsV.add(B);
            pointsV.add(C);
            this.ndgCond.addNewTranslation("IsSumOf", pointsV);
            return true;
        }
        return false;
    }

    @Override
    public boolean checkPositions(Vector<Point> pointList) {
        if (pointList == null || pointList.size() != 3) {
            return false;
        }
        boolean checkResult = false;
        boolean singleCheckResult = false;
        Point A = pointList.get(0).clone();
        Point B = pointList.get(1).clone();
        Point C = pointList.get(2).clone();
        singleCheckResult = this.checkThreeCollinearPoints(A, B, C);
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkMidPoint(A, B, C);
        if (!singleCheckResult && !(singleCheckResult = this.checkMidPoint(B, C, A))) {
            singleCheckResult = this.checkMidPoint(C, A, B);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkPerpBisectorPoint(A, B, C);
        if (!singleCheckResult && !(singleCheckResult = this.checkPerpBisectorPoint(B, C, A))) {
            singleCheckResult = this.checkPerpBisectorPoint(C, A, B);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkRightAngle(A, B, C);
        if (!singleCheckResult && !(singleCheckResult = this.checkRightAngle(B, C, A))) {
            singleCheckResult = this.checkRightAngle(C, A, B);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkPointOnCircle(A, B, C);
        if (!(singleCheckResult || (singleCheckResult = this.checkPointOnCircle(B, A, C)) || (singleCheckResult = this.checkPointOnCircle(B, C, A)) || (singleCheckResult = this.checkPointOnCircle(C, B, A)) || (singleCheckResult = this.checkPointOnCircle(C, A, B)))) {
            singleCheckResult = this.checkPointOnCircle(A, C, B);
        }
        checkResult = checkResult || singleCheckResult;
        singleCheckResult = this.checkAlgebraicSumOfThreeSegments(A, B, C);
        if (!singleCheckResult && !(singleCheckResult = this.checkAlgebraicSumOfThreeSegments(B, C, A))) {
            singleCheckResult = this.checkAlgebraicSumOfThreeSegments(C, A, B);
        }
        checkResult = checkResult || singleCheckResult;
        return checkResult;
    }
}

