/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.auxiliary;

import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointsPositionChecker;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.ndgcondition.AlgebraicNDGCondition;
import com.ogprover.pp.tp.thmstatement.IdenticalPoints;
import java.util.Vector;

public class TwoPointsPositionChecker
extends PointsPositionChecker {
    public static final String VERSION_NUM = "1.00";

    public TwoPointsPositionChecker(AlgebraicNDGCondition ndgCond) {
        this.initializePointsPositionChecker(ndgCond);
    }

    @Override
    public boolean checkPositions(Vector<Point> pointList) {
        if (pointList == null || pointList.size() != 2) {
            return false;
        }
        Point A = pointList.get(0).clone();
        Point B = pointList.get(1).clone();
        this.clearAuxCP();
        this.auxiliaryCP.addGeoConstruction(A);
        this.auxiliaryCP.addGeoConstruction(B);
        this.auxiliaryCP.addThmStatement(new IdenticalPoints(A, B));
        XPolynomial statementPoly = this.auxiliaryCP.getTheoremStatement().getAlgebraicForm();
        if (statementPoly != null && statementPoly.matchesNDGCPolynomial(this.ndgCond.getPolynomial())) {
            this.ndgCond.addNewTranslation("AreEqual", pointList);
            return true;
        }
        return false;
    }
}

