/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpressionComparator;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.expressions.Sum;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

public abstract class AMExpression {
    public static final String VERSION_NUM = "1.00";
    public static Point iO = new FreePoint("iO");
    public static Point iU = new FreePoint("iU");
    public static Point iV = new FreePoint("iV");
    public static AMExpression souv = new AreaOfTriangle(iO, iU, iV);

    public abstract String print();

    public abstract HashSet<Point> getPoints();

    public abstract boolean containsOnlyFreePoints();

    public abstract int size();

    public abstract AMExpression uniformize(HashSet<HashSet<Point>> var1);

    public abstract AMExpression simplifyInOneStep();

    public abstract AMExpression eliminate(Point var1, AreaMethodProver var2) throws UnknownStatementException;

    public abstract AMExpression reduceToSingleFraction();

    public abstract AMExpression reduceToRightAssociativeFormInOneStep();

    public abstract AMExpression toIndependantVariables(AreaMethodProver var1) throws UnknownStatementException;

    public abstract AMExpression replace(HashMap<Point, Point> var1);

    public abstract SumOfProducts toSumOfProducts();

    public abstract boolean equals(Object var1);

    public boolean isZero() {
        if (this instanceof BasicNumber && ((BasicNumber)this).value() == 0) {
            return true;
        }
        return this instanceof SumOfProducts && ((SumOfProducts)this).getTerms().isEmpty();
    }

    public AMExpression simplify() {
        AMExpression last = this;
        AMExpression current = last.simplifyInOneStep();
        while (!last.equals(current)) {
            last = current;
            current = current.simplifyInOneStep();
        }
        return last;
    }

    public AMExpression reduceToRightAssociativeForm() {
        AMExpression last = this;
        AMExpression current = last.reduceToRightAssociativeFormInOneStep();
        while (!last.equals(current)) {
            last = current;
            current = current.reduceToRightAssociativeFormInOneStep();
        }
        return last;
    }

    public List<AMExpression> productToList() {
        if (this instanceof PythagorasDifference || this instanceof AreaOfTriangle) {
            Vector<AMExpression> list = new Vector<AMExpression>();
            list.add(this);
            return list;
        }
        if (this instanceof BasicNumber) {
            return new Vector<AMExpression>();
        }
        if (this instanceof Product) {
            AMExpression leftFactor = ((Product)this).getFactor1();
            AMExpression rightFactor = ((Product)this).getFactor2();
            List<AMExpression> list = rightFactor.productToList();
            if (leftFactor instanceof PythagorasDifference || leftFactor instanceof AreaOfTriangle) {
                list.add(leftFactor);
            }
            return list;
        }
        System.out.println("The expression is not in the good form : " + this.print());
        return null;
    }

    public boolean isSameProduct(AMExpression expr) {
        List<AMExpression> factorsOfThis = this.productToList();
        List<AMExpression> factorsOfExpr = expr.productToList();
        AMExpressionComparator comparator = new AMExpressionComparator();
        Collections.sort(factorsOfExpr, comparator);
        Collections.sort(factorsOfThis, comparator);
        if (factorsOfThis.size() != factorsOfExpr.size()) {
            return false;
        }
        for (int i = 0; i < factorsOfThis.size(); ++i) {
            if (factorsOfThis.get(i).equals(factorsOfExpr.get(i))) continue;
            return false;
        }
        return true;
    }

    public AMExpression addProductToSum(AMExpression expr) {
        if (this instanceof Sum) {
            AMExpression leftTerm = ((Sum)this).getTerm1();
            AMExpression restOfSum = ((Sum)this).getTerm2();
            if (leftTerm.isSameProduct(expr)) {
                int constantOfLeftTerm = ((BasicNumber)((Product)leftTerm).getFactor1()).value();
                int constantOfExpr = ((BasicNumber)((Product)expr).getFactor1()).value();
                int sum = constantOfExpr + constantOfLeftTerm;
                AMExpression restOfProduct = ((Product)leftTerm).getFactor2();
                return new Sum(new Product(new BasicNumber(sum), restOfProduct), restOfSum);
            }
            return new Sum(leftTerm, restOfSum.addProductToSum(expr));
        }
        if (this.isSameProduct(expr)) {
            int constantOfThis = ((BasicNumber)((Product)this).getFactor1()).value();
            int constantOfExpr = ((BasicNumber)((Product)expr).getFactor1()).value();
            int sum = constantOfExpr + constantOfThis;
            AMExpression restOfProduct = ((Product)this).getFactor2();
            return new Product(new BasicNumber(sum), restOfProduct);
        }
        return new Sum(this, expr);
    }

    public AMExpression groupSumOfProducts() {
        if (this instanceof Sum) {
            AMExpression leftTerm = ((Sum)this).getTerm1();
            AMExpression groupedRest = ((Sum)this).getTerm2().groupSumOfProducts();
            return groupedRest.addProductToSum(leftTerm);
        }
        return this;
    }

    protected static AMExpression getX(Point p) {
        return new AreaOfTriangle(iO, iU, p);
    }

    protected static AMExpression getY(Point p) {
        return new AreaOfTriangle(iO, iV, p);
    }
}

