/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.Fraction;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.HashMap;
import java.util.HashSet;

public class AdditiveInverse
extends AMExpression {
    public static final String VERSION_NUM = "1.00";
    protected AMExpression expr;

    public AMExpression getExpr() {
        return this.expr;
    }

    @Override
    public HashSet<Point> getPoints() {
        return this.expr.getPoints();
    }

    public AdditiveInverse(AMExpression expr) {
        this.expr = expr;
    }

    @Override
    public String print() {
        return "-" + this.expr.print();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof AdditiveInverse)) {
            return false;
        }
        AdditiveInverse inv = (AdditiveInverse)expr;
        return this.getExpr().equals(inv.getExpr());
    }

    @Override
    public boolean containsOnlyFreePoints() {
        return this.expr.containsOnlyFreePoints();
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        return new AdditiveInverse(this.expr.uniformize(knownCollinearPoints));
    }

    @Override
    public AMExpression simplifyInOneStep() {
        AMExpression e = this.expr.simplifyInOneStep();
        if (e instanceof AdditiveInverse) {
            return ((AdditiveInverse)e).getExpr();
        }
        if (e.isZero()) {
            return new BasicNumber(0);
        }
        return new AdditiveInverse(e);
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) throws UnknownStatementException {
        return new AdditiveInverse(this.expr.eliminate(pt, prover));
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        AMExpression term = this.expr.reduceToSingleFraction();
        if (term instanceof Fraction) {
            AMExpression numerator = ((Fraction)term).getNumerator();
            AMExpression denominator = ((Fraction)term).getDenominator();
            return new Fraction(new AdditiveInverse(numerator), denominator);
        }
        return new AdditiveInverse(term);
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        return new Product(new BasicNumber(-1), this.expr);
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        return new AdditiveInverse(this.expr.toIndependantVariables(prover));
    }

    @Override
    public int size() {
        return 1 + this.expr.size();
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        return new AdditiveInverse(this.expr.replace(replacementMap));
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        return new Product(new BasicNumber(-1), this.expr).toSumOfProducts();
    }
}

