/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AdditiveInverse;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.BigProduct;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.Fraction;
import com.ogprover.pp.tp.expressions.GeometricQuantity;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.expressions.Sum;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.AMFootPoint;
import com.ogprover.pp.tp.geoconstruction.AMIntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.PRatioPoint;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.TRatioPoint;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.HashMap;
import java.util.HashSet;

public class AreaOfTriangle
extends GeometricQuantity {
    public static final String VERSION_NUM = "1.00";
    protected Point a;
    protected Point b;
    protected Point c;

    public Point getA() {
        return this.a;
    }

    public Point getB() {
        return this.b;
    }

    public Point getC() {
        return this.c;
    }

    @Override
    public HashSet<Point> getPoints() {
        HashSet<Point> points = new HashSet<Point>();
        points.add(this.a);
        points.add(this.b);
        points.add(this.c);
        return points;
    }

    public AreaOfTriangle(Point a, Point b, Point c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("S_");
        s.append(this.a.getGeoObjectLabel());
        s.append(this.b.getGeoObjectLabel());
        s.append(this.c.getGeoObjectLabel());
        return s.toString();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof AreaOfTriangle)) {
            return false;
        }
        AreaOfTriangle area = (AreaOfTriangle)expr;
        return this.print().equals(area.print());
    }

    @Override
    public boolean containsOnlyFreePoints() {
        return this.a instanceof FreePoint && this.b instanceof FreePoint && this.c instanceof FreePoint;
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        if (this.a.equals(this.b) || this.b.equals(this.c) || this.c.equals(this.a)) {
            return new BasicNumber(0);
        }
        if (AreaMethodProver.optimizeAreaOfCollinearPoints) {
            HashSet<Point> set = new HashSet<Point>();
            set.add(this.a);
            set.add(this.b);
            set.add(this.c);
            if (knownCollinearPoints.contains(set)) {
                OpenGeoProver.settings.getLogger().debug("Koukou : " + this.print());
                return new BasicNumber(0);
            }
        }
        if (this.a.compare(this.b) && this.a.compare(this.c)) {
            if (this.b.compare(this.c)) {
                return this;
            }
            return new AdditiveInverse(new AreaOfTriangle(this.a, this.c, this.b));
        }
        if (this.b.compare(this.a) && this.b.compare(this.c)) {
            if (this.a.compare(this.c)) {
                return new AdditiveInverse(new AreaOfTriangle(this.b, this.a, this.c));
            }
            return new AreaOfTriangle(this.b, this.c, this.a);
        }
        if (this.a.compare(this.b)) {
            return new AreaOfTriangle(this.c, this.a, this.b);
        }
        return new AdditiveInverse(new AreaOfTriangle(this.c, this.b, this.a));
    }

    @Override
    public AMExpression simplifyInOneStep() {
        return this;
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) {
        Point aa = null;
        Point bb = null;
        if (pt.equals(this.c)) {
            aa = this.a;
            bb = this.b;
        } else if (pt.equals(this.b)) {
            aa = this.c;
            bb = this.a;
        } else if (pt.equals(this.a)) {
            aa = this.b;
            bb = this.c;
        } else {
            return this;
        }
        if (pt instanceof AMIntersectionPoint) {
            Point u = ((AMIntersectionPoint)pt).getU();
            Point v = ((AMIntersectionPoint)pt).getV();
            Point p = ((AMIntersectionPoint)pt).getP();
            Point q = ((AMIntersectionPoint)pt).getQ();
            AreaOfTriangle supq = new AreaOfTriangle(u, p, q);
            AreaOfTriangle gv = new AreaOfTriangle(aa, bb, v);
            Product term1 = new Product(supq, gv);
            AreaOfTriangle svpq = new AreaOfTriangle(v, p, q);
            AreaOfTriangle gu = new AreaOfTriangle(aa, bb, u);
            Product term2 = new Product(svpq, gu);
            Difference numerator = new Difference(term1, term2);
            AreaOfTriangle supv = new AreaOfTriangle(u, p, v);
            AreaOfTriangle spvq = new AreaOfTriangle(p, v, q);
            Sum denominator = new Sum(supv, spvq);
            return new Fraction(numerator, denominator);
        }
        if (pt instanceof AMFootPoint) {
            Point p = ((AMFootPoint)pt).getP();
            Point u = ((AMFootPoint)pt).getU();
            Point v = ((AMFootPoint)pt).getV();
            PythagorasDifference ppuv = new PythagorasDifference(p, u, v);
            AreaOfTriangle gv = new AreaOfTriangle(aa, bb, v);
            Product term1 = new Product(ppuv, gv);
            PythagorasDifference ppvu = new PythagorasDifference(p, v, u);
            AreaOfTriangle gu = new AreaOfTriangle(aa, bb, u);
            Product term2 = new Product(ppvu, gu);
            Sum numerator = new Sum(term1, term2);
            PythagorasDifference denominator = new PythagorasDifference(u, v, u);
            return new Fraction(numerator, denominator);
        }
        if (pt instanceof PRatioPoint) {
            Point w = ((PRatioPoint)pt).getW();
            Point u = ((PRatioPoint)pt).getU();
            Point v = ((PRatioPoint)pt).getV();
            AMExpression r = ((PRatioPoint)pt).getR();
            AreaOfTriangle gw = new AreaOfTriangle(aa, bb, w);
            AreaOfTriangle gu = new AreaOfTriangle(aa, bb, u);
            AreaOfTriangle gv = new AreaOfTriangle(aa, bb, v);
            Difference difference = new Difference(gv, gu);
            Product product = new Product(r, difference);
            return new Sum(gw, product);
        }
        if (pt instanceof TRatioPoint) {
            Point p = ((TRatioPoint)pt).getU();
            Point q = ((TRatioPoint)pt).getV();
            AMExpression r = ((TRatioPoint)pt).getR();
            AreaOfTriangle sabp = new AreaOfTriangle(aa, bb, p);
            PythagorasDifference ppab = new PythagorasDifference(p, aa, bb);
            PythagorasDifference pqab = new PythagorasDifference(q, aa, bb);
            Difference ppaqb = new Difference(ppab, pqab);
            Fraction coeff = new Fraction(r, new BasicNumber(4));
            Product product = new Product(coeff, ppaqb);
            return new Difference(sabp, product);
        }
        if (pt instanceof FreePoint) {
            System.out.println("Trying to eliminate the free point" + pt.getGeoObjectLabel());
            return null;
        }
        System.out.println("The point " + pt.getGeoObjectLabel() + "has not been generated using the area method");
        return null;
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        return this;
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        return this;
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        Product firstTerm = new Product(new Difference(AreaOfTriangle.getY(this.b), AreaOfTriangle.getY(this.c)), AreaOfTriangle.getX(this.a));
        Product secondTerm = new Product(new Difference(AreaOfTriangle.getY(this.c), AreaOfTriangle.getY(this.a)), AreaOfTriangle.getX(this.b));
        Product thirdTerm = new Product(new Difference(AreaOfTriangle.getY(this.a), AreaOfTriangle.getY(this.b)), AreaOfTriangle.getX(this.c));
        Sum numerator = new Sum(firstTerm, new Sum(secondTerm, thirdTerm));
        return new Fraction(numerator, souv);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        if (replacementMap.containsKey(this.a)) {
            return new AreaOfTriangle(replacementMap.get(this.a), this.b, this.c).replace(replacementMap);
        }
        if (replacementMap.containsKey(this.b)) {
            return new AreaOfTriangle(this.a, replacementMap.get(this.b), this.c).replace(replacementMap);
        }
        if (replacementMap.containsKey(this.c)) {
            return new AreaOfTriangle(this.a, this.b, replacementMap.get(this.c)).replace(replacementMap);
        }
        return this;
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        return new SumOfProducts(new BigProduct(this));
    }
}

