/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.GeometricQuantity;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BigProduct
extends AMExpression {
    public static final String VERSION_NUM = "1.00";
    protected BasicNumber coeff = new BasicNumber(1);
    protected HashMap<GeometricQuantity, Integer> factors;

    public BasicNumber getCoeff() {
        return this.coeff;
    }

    public int getCoeffValue() {
        return this.coeff.value();
    }

    public HashMap<GeometricQuantity, Integer> getFactors() {
        return this.factors;
    }

    public void setCoeff(BasicNumber coeff) {
        this.coeff = coeff;
    }

    public BigProduct(GeometricQuantity factor) {
        this.factors = new HashMap();
        this.factors.put(factor, new Integer(1));
    }

    public BigProduct(BasicNumber coeff) {
        this.factors = new HashMap();
        this.coeff = coeff;
    }

    public BigProduct(BigProduct product, GeometricQuantity factor) {
        this.coeff = product.getCoeff();
        this.factors = new HashMap<GeometricQuantity, Integer>(product.getFactors());
        if (this.factors.containsKey(factor)) {
            this.factors.put(factor, new Integer(this.factors.get(factor) + 1));
        } else {
            this.factors.put(factor, new Integer(1));
        }
    }

    public BigProduct(BigProduct product, GeometricQuantity factor, int exponent) {
        this.coeff = product.getCoeff();
        this.factors = new HashMap<GeometricQuantity, Integer>(product.getFactors());
        if (this.factors.containsKey(factor)) {
            this.factors.put(factor, new Integer(this.factors.get(factor) + exponent));
        } else {
            this.factors.put(factor, new Integer(exponent));
        }
    }

    public BigProduct(BigProduct product, BasicNumber coeff) {
        this.factors = new HashMap<GeometricQuantity, Integer>(product.getFactors());
        this.coeff = (BasicNumber)new Product(product.getCoeff(), coeff).simplify();
    }

    public BigProduct(HashMap<GeometricQuantity, Integer> terms) {
        this.factors = new HashMap<GeometricQuantity, Integer>(terms);
    }

    public BigProduct(BigProduct product1, BigProduct product2) {
        this.coeff = (BasicNumber)new Product(product1.getCoeff(), product2.getCoeff()).simplify();
        this.factors = new HashMap<GeometricQuantity, Integer>(product1.getFactors());
        Set<Map.Entry<GeometricQuantity, Integer>> entries = product2.getFactors().entrySet();
        for (Map.Entry<GeometricQuantity, Integer> e : entries) {
            GeometricQuantity factor = e.getKey();
            int exponent = e.getValue();
            if (this.factors.containsKey(factor)) {
                int previousExponent = this.factors.get(factor);
                this.factors.put(factor, new Integer(previousExponent + exponent));
                continue;
            }
            this.factors.put(factor, new Integer(exponent));
        }
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("(");
        s.append(this.coeff.print());
        Set<Map.Entry<GeometricQuantity, Integer>> entries = this.factors.entrySet();
        for (Map.Entry<GeometricQuantity, Integer> e : entries) {
            s.append("\u00d7" + e.getKey().print());
            int value = e.getValue();
            if (value == 1) continue;
            s.append("^" + value);
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof BigProduct)) {
            return false;
        }
        BigProduct product = (BigProduct)expr;
        return this.coeff.equals(product.getCoeff()) && this.factors.equals(product.getFactors());
    }

    @Override
    public HashSet<Point> getPoints() {
        Set<Map.Entry<GeometricQuantity, Integer>> entries = this.factors.entrySet();
        HashSet<Point> points = new HashSet<Point>();
        for (Map.Entry<GeometricQuantity, Integer> e : entries) {
            points.addAll(e.getKey().getPoints());
        }
        return points;
    }

    @Override
    public boolean containsOnlyFreePoints() {
        Set<Map.Entry<GeometricQuantity, Integer>> entries = this.factors.entrySet();
        for (Map.Entry<GeometricQuantity, Integer> e : entries) {
            if (e.getKey().containsOnlyFreePoints()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.factors.size();
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        Set<Map.Entry<GeometricQuantity, Integer>> entries = this.factors.entrySet();
        HashMap<GeometricQuantity, Integer> newMap = new HashMap<GeometricQuantity, Integer>();
        for (Map.Entry<GeometricQuantity, Integer> e : entries) {
            newMap.put((GeometricQuantity)e.getKey().uniformize(knownCollinearPoints), e.getValue());
        }
        return new BigProduct(new BigProduct(newMap), this.coeff);
    }

    @Override
    public AMExpression simplifyInOneStep() {
        if (this.coeff.value() == 0) {
            return new BasicNumber(0);
        }
        return this;
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) throws UnknownStatementException {
        OpenGeoProver.settings.getLogger().error("Method eliminate should not be called on big product instances.");
        return null;
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        return this;
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        return this;
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        AMExpression product = this.coeff;
        Set<Map.Entry<GeometricQuantity, Integer>> entries = this.factors.entrySet();
        for (Map.Entry<GeometricQuantity, Integer> e : entries) {
            int power = e.getValue();
            GeometricQuantity factor = e.getKey();
            for (int i = 0; i < power; ++i) {
                product = new Product(factor.toIndependantVariables(prover), product);
            }
        }
        return product;
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        Set<Map.Entry<GeometricQuantity, Integer>> entries = this.factors.entrySet();
        HashMap<GeometricQuantity, Integer> newMap = new HashMap<GeometricQuantity, Integer>();
        for (Map.Entry<GeometricQuantity, Integer> e : entries) {
            newMap.put((GeometricQuantity)e.getKey().replace(replacementMap), e.getValue());
        }
        return new BigProduct(new BigProduct(newMap), this.coeff);
    }

    public boolean hasSameFactors(BigProduct product) {
        boolean found;
        Set<Map.Entry<GeometricQuantity, Integer>> entries1 = product.getFactors().entrySet();
        Set<Map.Entry<GeometricQuantity, Integer>> entries2 = this.factors.entrySet();
        for (Map.Entry<GeometricQuantity, Integer> e : entries1) {
            found = false;
            for (Map.Entry<GeometricQuantity, Integer> e2 : entries2) {
                if (!((Object)e2).equals(e)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        for (Map.Entry<GeometricQuantity, Integer> e2 : entries2) {
            found = false;
            for (Map.Entry<GeometricQuantity, Integer> e : entries1) {
                if (!((Object)e).equals(e2)) continue;
                found = true;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        return new SumOfProducts(this);
    }
}

