/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AdditiveInverse;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.Fraction;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.Sum;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.HashMap;
import java.util.HashSet;

public class Difference
extends AMExpression {
    public static final String VERSION_NUM = "1.00";
    protected AMExpression term1;
    protected AMExpression term2;

    public AMExpression getTerm1() {
        return this.term1;
    }

    public AMExpression getTerm2() {
        return this.term2;
    }

    @Override
    public HashSet<Point> getPoints() {
        HashSet<Point> points = new HashSet<Point>();
        points.addAll(this.term1.getPoints());
        points.addAll(this.term2.getPoints());
        return points;
    }

    public Difference(AMExpression term1, AMExpression term2) {
        this.term1 = term1;
        this.term2 = term2;
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("(");
        s.append(this.term1.print());
        s.append("-");
        s.append(this.term2.print());
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof Difference)) {
            return false;
        }
        Difference diff = (Difference)expr;
        return this.term1.equals(diff.getTerm1()) && this.term2.equals(diff.getTerm2());
    }

    @Override
    public boolean containsOnlyFreePoints() {
        return this.term1.containsOnlyFreePoints() && this.term2.containsOnlyFreePoints();
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        return new Difference(this.term1.uniformize(knownCollinearPoints), this.term2.uniformize(knownCollinearPoints));
    }

    @Override
    public AMExpression simplifyInOneStep() {
        AMExpression t1 = this.term1.simplifyInOneStep();
        AMExpression t2 = this.term2.simplifyInOneStep();
        if (t2.isZero()) {
            return t1;
        }
        if (t1.isZero()) {
            return new AdditiveInverse(t2);
        }
        if (t1 instanceof BasicNumber && t2 instanceof BasicNumber) {
            return new BasicNumber(((BasicNumber)t1).value() - ((BasicNumber)t2).value());
        }
        if (t1.equals(t2)) {
            return new BasicNumber(0);
        }
        if (t2 instanceof AdditiveInverse) {
            return new Sum(t1, ((AdditiveInverse)t2).expr);
        }
        return new Difference(t1, t2);
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) throws UnknownStatementException {
        return new Difference(this.term1.eliminate(pt, prover), this.term2.eliminate(pt, prover));
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        AMExpression expr1 = this.term1.reduceToSingleFraction();
        AMExpression expr2 = this.term2.reduceToSingleFraction();
        if (expr1 instanceof Fraction) {
            AMExpression num1 = ((Fraction)expr1).getNumerator();
            AMExpression den1 = ((Fraction)expr1).getDenominator();
            if (expr2 instanceof Fraction) {
                AMExpression num2 = ((Fraction)expr2).getNumerator();
                AMExpression den2 = ((Fraction)expr2).getDenominator();
                if (den1.equals(den2)) {
                    return new Fraction(new Difference(num1, num2), den1);
                }
                Difference numerator = new Difference(new Product(num1, den2), new Product(num2, den1));
                Product denominator = new Product(den1, den2);
                return new Fraction(numerator, denominator);
            }
            return new Fraction(new Difference(num1, new Product(expr2, den1)), den1);
        }
        if (expr2 instanceof Fraction) {
            AMExpression num2 = ((Fraction)expr2).getNumerator();
            AMExpression den2 = ((Fraction)expr2).getDenominator();
            return new Fraction(new Difference(new Product(expr1, den2), num2), den2);
        }
        return new Difference(expr1, expr2);
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        AMExpression firstTerm = this.term1.reduceToRightAssociativeFormInOneStep();
        AMExpression secondTerm = this.term2.reduceToRightAssociativeFormInOneStep();
        return new Sum(firstTerm, new Product(new BasicNumber(-1), secondTerm));
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        return new Difference(this.term1.toIndependantVariables(prover), this.term2.toIndependantVariables(prover));
    }

    @Override
    public int size() {
        return 1 + this.term1.size() + this.term2.size();
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        return new Difference(this.term1.replace(replacementMap), this.term2.replace(replacementMap));
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        return new Sum(this.term1, new Product(new BasicNumber(-1), this.term2)).toSumOfProducts();
    }
}

