/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AdditiveInverse;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.HashMap;
import java.util.HashSet;

public class Fraction
extends AMExpression {
    public static final String VERSION_NUM = "1.00";
    protected AMExpression numerator;
    protected AMExpression denominator;

    public AMExpression getNumerator() {
        return this.numerator;
    }

    public AMExpression getDenominator() {
        return this.denominator;
    }

    @Override
    public HashSet<Point> getPoints() {
        HashSet<Point> points = new HashSet<Point>();
        points.addAll(this.numerator.getPoints());
        points.addAll(this.denominator.getPoints());
        return points;
    }

    public Fraction(AMExpression numerator, AMExpression denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Fraction(int numerator, int denominator) {
        this.numerator = new BasicNumber(numerator);
        this.denominator = new BasicNumber(denominator);
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("(");
        s.append(this.numerator.print());
        s.append("/");
        s.append(this.denominator.print());
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof Fraction)) {
            return false;
        }
        Fraction frac = (Fraction)expr;
        return this.numerator.equals(frac.getNumerator()) && this.denominator.equals(frac.getDenominator());
    }

    @Override
    public boolean containsOnlyFreePoints() {
        return this.numerator.containsOnlyFreePoints() && this.denominator.containsOnlyFreePoints();
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        return new Fraction(this.numerator.uniformize(knownCollinearPoints), this.denominator.uniformize(knownCollinearPoints));
    }

    @Override
    public AMExpression simplifyInOneStep() {
        AMExpression n = this.numerator.simplifyInOneStep();
        AMExpression d = this.denominator.simplifyInOneStep();
        if (n.isZero()) {
            return new BasicNumber(0);
        }
        if (d.isZero()) {
            System.out.println("Division by zero in expression : " + this.print());
            return null;
        }
        if (n.equals(d)) {
            return new BasicNumber(1);
        }
        if (d.equals(new BasicNumber(1))) {
            return n;
        }
        if (n instanceof AdditiveInverse) {
            if (d instanceof AdditiveInverse) {
                return new Fraction(((AdditiveInverse)n).getExpr(), ((AdditiveInverse)d).getExpr());
            }
            return new AdditiveInverse(new Fraction(((AdditiveInverse)n).getExpr(), d));
        }
        if (d instanceof AdditiveInverse) {
            return new AdditiveInverse(new Fraction(n, ((AdditiveInverse)d).getExpr()));
        }
        if (n instanceof Product) {
            Product product = (Product)n;
            AMExpression factor1 = product.getFactor1().simplifyInOneStep();
            AMExpression factor2 = product.getFactor2().simplifyInOneStep();
            if (factor1.equals(d)) {
                return factor2;
            }
            if (factor2.equals(d)) {
                return factor1;
            }
        }
        return new Fraction(n, d);
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) throws UnknownStatementException {
        return new Fraction(this.numerator.eliminate(pt, prover), this.denominator.eliminate(pt, prover));
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        AMExpression expr1 = this.numerator.reduceToSingleFraction();
        AMExpression expr2 = this.denominator.reduceToSingleFraction();
        if (expr1 instanceof Fraction) {
            AMExpression num1 = ((Fraction)expr1).getNumerator();
            AMExpression den1 = ((Fraction)expr1).getDenominator();
            if (expr2 instanceof Fraction) {
                AMExpression num2 = ((Fraction)expr2).getNumerator();
                AMExpression den2 = ((Fraction)expr2).getDenominator();
                if (den1.equals(den2)) {
                    return new Fraction(num1, num2);
                }
                return new Fraction(new Product(num1, num2), new Product(den1, den2));
            }
            return new Fraction(num1, new Product(den1, expr2));
        }
        if (expr2 instanceof Fraction) {
            AMExpression num2 = ((Fraction)expr2).getNumerator();
            AMExpression den2 = ((Fraction)expr2).getDenominator();
            return new Fraction(new Product(expr1, den2), num2);
        }
        return new Fraction(expr1, expr2);
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        System.out.println("Calling reductToRightAssociativeForm() on an expression which contains fractions : " + this.print());
        return null;
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        return new Fraction(this.numerator.toIndependantVariables(prover), this.denominator.toIndependantVariables(prover));
    }

    @Override
    public int size() {
        return 1 + this.numerator.size() + this.denominator.size();
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        return new Fraction(this.numerator.replace(replacementMap), this.denominator.replace(replacementMap));
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        System.out.println("Calling toSumOfProducts() on an expression which contains fractions : " + this.print());
        return null;
    }
}

