/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AdditiveInverse;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.BigProduct;
import com.ogprover.pp.tp.expressions.Fraction;
import com.ogprover.pp.tp.expressions.Sum;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.HashMap;
import java.util.HashSet;

public class Product
extends AMExpression {
    public static final String VERSION_NUM = "1.00";
    protected AMExpression factor1;
    protected AMExpression factor2;

    public AMExpression getFactor1() {
        return this.factor1;
    }

    public AMExpression getFactor2() {
        return this.factor2;
    }

    @Override
    public HashSet<Point> getPoints() {
        HashSet<Point> points = new HashSet<Point>();
        points.addAll(this.factor1.getPoints());
        points.addAll(this.factor2.getPoints());
        return points;
    }

    public Product(AMExpression factor1, AMExpression factor2) {
        this.factor1 = factor1;
        this.factor2 = factor2;
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("(");
        s.append(this.factor1.print());
        s.append("\u00d7");
        s.append(this.factor2.print());
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof Product)) {
            return false;
        }
        Product prod = (Product)expr;
        return this.factor1.equals(prod.getFactor1()) && this.factor2.equals(prod.getFactor2());
    }

    @Override
    public boolean containsOnlyFreePoints() {
        return this.factor1.containsOnlyFreePoints() && this.factor2.containsOnlyFreePoints();
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        return new Product(this.factor1.uniformize(knownCollinearPoints), this.factor2.uniformize(knownCollinearPoints));
    }

    @Override
    public AMExpression simplifyInOneStep() {
        AMExpression denominator;
        int value;
        AMExpression f1 = this.factor1.simplifyInOneStep();
        AMExpression f2 = this.factor2.simplifyInOneStep();
        if (f1 instanceof BasicNumber) {
            if (f2 instanceof BasicNumber) {
                return new BasicNumber(((BasicNumber)f1).value() * ((BasicNumber)f2).value());
            }
            value = ((BasicNumber)f1).value();
            if (value == 0) {
                return new BasicNumber(0);
            }
            if (value == 1) {
                return f2;
            }
            if (value < 0) {
                return new AdditiveInverse(new Product(new BasicNumber(-value), f2));
            }
        }
        if (f2 instanceof BasicNumber) {
            value = ((BasicNumber)f2).value();
            if (value == 0) {
                return new BasicNumber(0);
            }
            if (value == 1) {
                return f1;
            }
            if (value < 0) {
                return new AdditiveInverse(new Product(new BasicNumber(-value), f1));
            }
        }
        if (f1 instanceof AdditiveInverse) {
            if (f2 instanceof AdditiveInverse) {
                return new Product(((AdditiveInverse)f1).getExpr(), ((AdditiveInverse)f2).getExpr());
            }
            return new AdditiveInverse(new Product(((AdditiveInverse)f1).getExpr(), f2));
        }
        if (f2 instanceof AdditiveInverse) {
            return new AdditiveInverse(new Product(((AdditiveInverse)f2).getExpr(), f1));
        }
        if (f1 instanceof Fraction) {
            AMExpression numerator = ((Fraction)f1).getNumerator();
            denominator = ((Fraction)f1).getDenominator();
            if (numerator.equals(new BasicNumber(1)) && denominator.equals(f2)) {
                return new BasicNumber(1);
            }
        }
        if (f2 instanceof Fraction) {
            AMExpression numerator = ((Fraction)f2).getNumerator();
            denominator = ((Fraction)f2).getDenominator();
            if (numerator.equals(new BasicNumber(1)) && denominator.equals(f1)) {
                return new BasicNumber(1);
            }
        }
        return new Product(f1, f2);
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) throws UnknownStatementException {
        return new Product(this.factor1.eliminate(pt, prover), this.factor2.eliminate(pt, prover));
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        AMExpression expr1 = this.factor1.reduceToSingleFraction();
        AMExpression expr2 = this.factor2.reduceToSingleFraction();
        if (expr1 instanceof Fraction) {
            AMExpression num1 = ((Fraction)expr1).getNumerator();
            AMExpression den1 = ((Fraction)expr1).getDenominator();
            if (expr2 instanceof Fraction) {
                AMExpression num2 = ((Fraction)expr2).getNumerator();
                AMExpression den2 = ((Fraction)expr2).getDenominator();
                return new Fraction(new Product(num1, num2), new Product(den1, den2));
            }
            return new Fraction(new Product(num1, expr2), den1);
        }
        if (expr2 instanceof Fraction) {
            AMExpression num2 = ((Fraction)expr2).getNumerator();
            AMExpression den2 = ((Fraction)expr2).getDenominator();
            return new Fraction(new Product(num2, expr1), den2);
        }
        return new Product(expr1, expr2);
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        AMExpression b;
        AMExpression a;
        AMExpression firstFactor = this.factor1.reduceToRightAssociativeFormInOneStep();
        AMExpression secondFactor = this.factor2.reduceToRightAssociativeFormInOneStep();
        if (secondFactor instanceof Sum) {
            AMExpression firstTerm = ((Sum)secondFactor).getTerm1();
            AMExpression secondTerm = ((Sum)secondFactor).getTerm2();
            return new Sum(new Product(firstFactor, firstTerm), new Product(firstFactor, secondTerm));
        }
        if (firstFactor instanceof Sum) {
            AMExpression firstTerm = ((Sum)firstFactor).getTerm1();
            AMExpression secondTerm = ((Sum)firstFactor).getTerm2();
            return new Sum(new Product(secondFactor, firstTerm), new Product(secondFactor, secondTerm));
        }
        if (firstFactor instanceof Product) {
            AMExpression a2 = ((Product)firstFactor).getFactor1();
            AMExpression b2 = ((Product)firstFactor).getFactor2();
            return new Product(a2, new Product(b2, secondFactor));
        }
        if (firstFactor instanceof BasicNumber) {
            if (secondFactor instanceof BasicNumber) {
                return new BasicNumber(((BasicNumber)firstFactor).value() * ((BasicNumber)secondFactor).value());
            }
            if (secondFactor instanceof Product) {
                a = ((Product)secondFactor).getFactor1();
                b = ((Product)secondFactor).getFactor2();
                if (a instanceof BasicNumber) {
                    int product = ((BasicNumber)firstFactor).value() * ((BasicNumber)a).value();
                    return new Product(new BasicNumber(product), b);
                }
            }
        }
        if (secondFactor instanceof BasicNumber) {
            return new Product(secondFactor, firstFactor);
        }
        if (secondFactor instanceof Product) {
            a = ((Product)secondFactor).getFactor1();
            b = ((Product)secondFactor).getFactor2();
            if (a instanceof BasicNumber) {
                return new Product(a, new Product(firstFactor, b));
            }
        }
        return new Product(firstFactor, secondFactor);
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        return new Product(this.factor1.toIndependantVariables(prover), this.factor2.toIndependantVariables(prover));
    }

    @Override
    public int size() {
        return 1 + this.factor1.size() + this.factor2.size();
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        return new Product(this.factor1.replace(replacementMap), this.factor2.replace(replacementMap));
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        SumOfProducts sum1 = this.factor1.toSumOfProducts();
        SumOfProducts sum2 = this.factor2.toSumOfProducts();
        SumOfProducts sumToReturn = new SumOfProducts();
        HashSet<BigProduct> factors1 = sum1.getTerms();
        HashSet<BigProduct> factors2 = sum2.getTerms();
        for (BigProduct product1 : factors1) {
            for (BigProduct product2 : factors2) {
                sumToReturn.addTerm(new BigProduct(product1, product2));
            }
        }
        return sumToReturn;
    }
}

