/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.BigProduct;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.Fraction;
import com.ogprover.pp.tp.expressions.GeometricQuantity;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.Sum;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.AMFootPoint;
import com.ogprover.pp.tp.geoconstruction.AMIntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.PRatioPoint;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.TRatioPoint;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.HashMap;
import java.util.HashSet;

public class PythagorasDifference
extends GeometricQuantity {
    public static final String VERSION_NUM = "1.00";
    protected Point a;
    protected Point b;
    protected Point c;

    public Point getA() {
        return this.a;
    }

    public Point getB() {
        return this.b;
    }

    public Point getC() {
        return this.c;
    }

    @Override
    public HashSet<Point> getPoints() {
        HashSet<Point> points = new HashSet<Point>();
        points.add(this.a);
        points.add(this.b);
        points.add(this.c);
        return points;
    }

    public PythagorasDifference(Point a, Point b, Point c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append("P_");
        s.append(this.a.getGeoObjectLabel());
        s.append(this.b.getGeoObjectLabel());
        s.append(this.c.getGeoObjectLabel());
        return s.toString();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof PythagorasDifference)) {
            return false;
        }
        PythagorasDifference diff = (PythagorasDifference)expr;
        return this.a.equals(diff.getA()) && this.b.equals(diff.getB()) && this.c.equals(diff.getC());
    }

    @Override
    public boolean containsOnlyFreePoints() {
        return this.a instanceof FreePoint && this.b instanceof FreePoint && this.c instanceof FreePoint;
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        if (this.a.equals(this.b) || this.b.equals(this.c)) {
            return new BasicNumber(0);
        }
        if (this.c.compare(this.a)) {
            return new PythagorasDifference(this.c, this.b, this.a);
        }
        if (this.c.equals(this.a) && this.b.compare(this.a)) {
            return new PythagorasDifference(this.b, this.a, this.b);
        }
        return this;
    }

    @Override
    public AMExpression simplifyInOneStep() {
        return this;
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) {
        Point aa = null;
        Point bb = null;
        boolean islinear = true;
        if (pt.equals(this.c)) {
            aa = this.a;
            bb = this.b;
        } else if (pt.equals(this.b)) {
            aa = this.a;
            bb = this.c;
            islinear = false;
        } else if (pt.equals(this.a)) {
            aa = this.c;
            bb = this.b;
        } else {
            return this;
        }
        if (islinear) {
            if (pt instanceof AMIntersectionPoint) {
                Point u = ((AMIntersectionPoint)pt).getU();
                Point v = ((AMIntersectionPoint)pt).getV();
                Point p = ((AMIntersectionPoint)pt).getP();
                Point q = ((AMIntersectionPoint)pt).getQ();
                PythagorasDifference supq = new PythagorasDifference(u, p, q);
                PythagorasDifference gv = new PythagorasDifference(aa, bb, v);
                Product term1 = new Product(supq, gv);
                PythagorasDifference svpq = new PythagorasDifference(v, p, q);
                PythagorasDifference gu = new PythagorasDifference(aa, bb, u);
                Product term2 = new Product(svpq, gu);
                Difference numerator = new Difference(term1, term2);
                PythagorasDifference supv = new PythagorasDifference(u, p, v);
                PythagorasDifference spvq = new PythagorasDifference(p, v, q);
                Sum denominator = new Sum(supv, spvq);
                return new Fraction(numerator, denominator);
            }
            if (pt instanceof AMFootPoint) {
                Point p = ((AMFootPoint)pt).getP();
                Point u = ((AMFootPoint)pt).getU();
                Point v = ((AMFootPoint)pt).getV();
                PythagorasDifference ppuv = new PythagorasDifference(p, u, v);
                PythagorasDifference gv = new PythagorasDifference(aa, bb, v);
                Product term1 = new Product(ppuv, gv);
                PythagorasDifference ppvu = new PythagorasDifference(p, v, u);
                PythagorasDifference gu = new PythagorasDifference(aa, bb, u);
                Product term2 = new Product(ppvu, gu);
                Sum numerator = new Sum(term1, term2);
                PythagorasDifference denominator = new PythagorasDifference(u, v, u);
                return new Fraction(numerator, denominator);
            }
            if (pt instanceof PRatioPoint) {
                Point w = ((PRatioPoint)pt).getW();
                Point u = ((PRatioPoint)pt).getU();
                Point v = ((PRatioPoint)pt).getV();
                AMExpression r = ((PRatioPoint)pt).getR();
                PythagorasDifference gw = new PythagorasDifference(aa, bb, w);
                PythagorasDifference gu = new PythagorasDifference(aa, bb, u);
                PythagorasDifference gv = new PythagorasDifference(aa, bb, v);
                Difference difference = new Difference(gv, gu);
                Product product = new Product(r, difference);
                return new Sum(gw, product);
            }
            if (pt instanceof TRatioPoint) {
                Point p = ((TRatioPoint)pt).getU();
                Point q = ((TRatioPoint)pt).getV();
                AMExpression r = ((TRatioPoint)pt).getR();
                PythagorasDifference pabp = new PythagorasDifference(aa, bb, p);
                PythagorasDifference spaq = new PythagorasDifference(p, aa, q);
                PythagorasDifference saqb = new PythagorasDifference(aa, q, bb);
                Sum spaqb = new Sum(spaq, saqb);
                Product coeff = new Product(r, new BasicNumber(4));
                Product product = new Product(coeff, spaqb);
                return new Difference(pabp, product);
            }
        } else {
            if (pt instanceof AMIntersectionPoint) {
                Point u = ((AMIntersectionPoint)pt).getU();
                Point v = ((AMIntersectionPoint)pt).getV();
                Point p = ((AMIntersectionPoint)pt).getP();
                Point q = ((AMIntersectionPoint)pt).getQ();
                PythagorasDifference spuv = new PythagorasDifference(p, u, v);
                PythagorasDifference spuq = new PythagorasDifference(p, u, q);
                PythagorasDifference suqv = new PythagorasDifference(u, q, v);
                Sum spuqv = new Sum(spuq, suqv);
                PythagorasDifference paqb = new PythagorasDifference(aa, q, bb);
                PythagorasDifference sqvu = new PythagorasDifference(q, v, u);
                PythagorasDifference papb = new PythagorasDifference(aa, p, bb);
                PythagorasDifference ppqp = new PythagorasDifference(p, q, p);
                Fraction frac1 = new Fraction(spuv, spuqv);
                Fraction frac2 = new Fraction(sqvu, spuqv);
                Product term1 = new Product(frac1, paqb);
                Product term2 = new Product(frac2, papb);
                Product term3 = new Product(new Product(frac1, frac2), ppqp);
                return new Difference(new Sum(term1, term2), term3);
            }
            if (pt instanceof AMFootPoint) {
                Point p = ((AMFootPoint)pt).getP();
                Point u = ((AMFootPoint)pt).getU();
                Point v = ((AMFootPoint)pt).getV();
                PythagorasDifference ppuv = new PythagorasDifference(p, u, v);
                PythagorasDifference puvu = new PythagorasDifference(u, v, u);
                PythagorasDifference ppvu = new PythagorasDifference(p, v, u);
                PythagorasDifference pavb = new PythagorasDifference(aa, v, bb);
                PythagorasDifference paub = new PythagorasDifference(aa, u, bb);
                Product term1 = new Product(new Fraction(ppuv, puvu), pavb);
                Product term2 = new Product(new Fraction(ppvu, puvu), paub);
                Fraction term3 = new Fraction(new Product(ppuv, ppvu), puvu);
                return new Sum(term1, new Difference(term2, term3));
            }
            if (pt instanceof PRatioPoint) {
                Point w = ((PRatioPoint)pt).getW();
                Point u = ((PRatioPoint)pt).getU();
                Point v = ((PRatioPoint)pt).getV();
                AMExpression r = ((PRatioPoint)pt).getR();
                PythagorasDifference pawb = new PythagorasDifference(aa, w, bb);
                PythagorasDifference pavb = new PythagorasDifference(aa, v, bb);
                PythagorasDifference paub = new PythagorasDifference(aa, u, bb);
                PythagorasDifference pwuv = new PythagorasDifference(w, u, v);
                PythagorasDifference puvu = new PythagorasDifference(u, v, u);
                Sum bloc1 = new Sum(new Difference(pavb, paub), new Product(new BasicNumber(2), pwuv));
                Product term1 = new Product(r, bloc1);
                Product coeff = new Product(r, new Difference(new BasicNumber(1), r));
                Product term2 = new Product(coeff, puvu);
                return new Sum(pawb, new Difference(term1, term2));
            }
            if (pt instanceof TRatioPoint) {
                Point p = ((TRatioPoint)pt).getU();
                Point q = ((TRatioPoint)pt).getV();
                AMExpression r = ((TRatioPoint)pt).getR();
                PythagorasDifference papb = new PythagorasDifference(aa, p, bb);
                PythagorasDifference ppqp = new PythagorasDifference(p, q, p);
                AreaOfTriangle sapq = new AreaOfTriangle(aa, p, q);
                AreaOfTriangle sbpq = new AreaOfTriangle(bb, p, q);
                Product term1 = new Product(new Product(r, r), ppqp);
                Product term2 = new Product(new Product(new BasicNumber(4), r), new Sum(sapq, sbpq));
                return new Sum(papb, new Difference(term1, term2));
            }
        }
        if (pt instanceof FreePoint) {
            System.out.println("Trying to eliminate the free point" + pt.getGeoObjectLabel());
            return null;
        }
        System.out.println("Th point " + pt.getGeoObjectLabel() + "has not been generated using the area method");
        return null;
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        return this;
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        return this;
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        Product term1 = new Product(PythagorasDifference.getY(this.a), PythagorasDifference.getY(this.c));
        Product term2 = new Product(new BasicNumber(-1), new Product(PythagorasDifference.getY(this.a), PythagorasDifference.getY(this.b)));
        Product term3 = new Product(PythagorasDifference.getY(this.b), PythagorasDifference.getY(this.b));
        Product term4 = new Product(new BasicNumber(-1), new Product(PythagorasDifference.getY(this.b), PythagorasDifference.getY(this.c)));
        Product term5 = new Product(new BasicNumber(-1), new Product(PythagorasDifference.getX(this.a), PythagorasDifference.getX(this.b)));
        Product term6 = new Product(PythagorasDifference.getX(this.a), PythagorasDifference.getX(this.c));
        Product term7 = new Product(PythagorasDifference.getX(this.b), PythagorasDifference.getX(this.b));
        Product term8 = new Product(new BasicNumber(-1), new Product(PythagorasDifference.getX(this.b), PythagorasDifference.getX(this.c)));
        Sum firstPart = new Sum(term1, new Sum(term2, new Sum(term3, term4)));
        Sum secondPart = new Sum(term5, new Sum(term6, new Sum(term7, term8)));
        Sum numerator = new Sum(firstPart, secondPart);
        Product denominator = new Product(souv, souv);
        return new Product(new BasicNumber(4), new Fraction(numerator, denominator));
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        if (replacementMap.containsKey(this.a)) {
            return new PythagorasDifference(replacementMap.get(this.a), this.b, this.c).replace(replacementMap);
        }
        if (replacementMap.containsKey(this.b)) {
            return new PythagorasDifference(this.a, replacementMap.get(this.b), this.c).replace(replacementMap);
        }
        if (replacementMap.containsKey(this.c)) {
            return new PythagorasDifference(this.a, this.b, replacementMap.get(this.c)).replace(replacementMap);
        }
        return this;
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        return new SumOfProducts(new BigProduct(this));
    }
}

