/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.AdditiveInverse;
import com.ogprover.pp.tp.expressions.AreaOfTriangle;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.BigProduct;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.Fraction;
import com.ogprover.pp.tp.expressions.GeometricQuantity;
import com.ogprover.pp.tp.expressions.Product;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.expressions.Sum;
import com.ogprover.pp.tp.expressions.SumOfProducts;
import com.ogprover.pp.tp.geoconstruction.AMFootPoint;
import com.ogprover.pp.tp.geoconstruction.AMIntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.PRatioPoint;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.TRatioPoint;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.CollinearPoints;
import com.ogprover.pp.tp.thmstatement.ThmStatement;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class RatioOfCollinearSegments
extends GeometricQuantity {
    public static final String VERSION_NUM = "1.00";
    protected Point a;
    protected Point b;
    protected Point c;
    protected Point d;

    public Point getA() {
        return this.a;
    }

    public Point getB() {
        return this.b;
    }

    public Point getC() {
        return this.c;
    }

    public Point getD() {
        return this.d;
    }

    @Override
    public HashSet<Point> getPoints() {
        HashSet<Point> points = new HashSet<Point>();
        points.add(this.a);
        points.add(this.b);
        points.add(this.c);
        points.add(this.d);
        return points;
    }

    public RatioOfCollinearSegments(Point a, Point b, Point c, Point d) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
    }

    @Override
    public String print() {
        StringBuilder s = new StringBuilder();
        s.append(this.a.getGeoObjectLabel());
        s.append(this.b.getGeoObjectLabel());
        s.append("/");
        s.append(this.c.getGeoObjectLabel());
        s.append(this.d.getGeoObjectLabel());
        return s.toString();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof RatioOfCollinearSegments)) {
            return false;
        }
        RatioOfCollinearSegments ratio = (RatioOfCollinearSegments)expr;
        return this.a.equals(ratio.getA()) && this.b.equals(ratio.getB()) && this.c.equals(ratio.getC()) && this.d.equals(ratio.getD());
    }

    @Override
    public boolean containsOnlyFreePoints() {
        return this.a instanceof FreePoint && this.b instanceof FreePoint && this.c instanceof FreePoint && this.d instanceof FreePoint;
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        if (this.a.equals(this.b)) {
            return new BasicNumber(0);
        }
        if (this.a.equals(this.c) && this.b.equals(this.d)) {
            return new BasicNumber(1);
        }
        if (this.a.equals(this.d) && this.b.equals(this.c)) {
            return new BasicNumber(-1);
        }
        if (this.a.compare(this.b)) {
            if (this.c.compare(this.d)) {
                return this;
            }
            return new AdditiveInverse(new RatioOfCollinearSegments(this.a, this.b, this.d, this.c));
        }
        if (this.c.compare(this.d)) {
            return new AdditiveInverse(new RatioOfCollinearSegments(this.b, this.a, this.c, this.d));
        }
        return new RatioOfCollinearSegments(this.b, this.a, this.d, this.c);
    }

    @Override
    public AMExpression simplifyInOneStep() {
        return this;
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) throws UnknownStatementException {
        if (!(this.a.equals(pt) || this.b.equals(pt) || this.c.equals(pt) || this.d.equals(pt))) {
            return this;
        }
        if (this.a.equals(this.b)) {
            return new BasicNumber(0);
        }
        if (this.b.equals(pt) && this.b.equals(this.c)) {
            return new AdditiveInverse(new RatioOfCollinearSegments(this.a, this.b, this.d, this.c)).eliminate(pt, prover);
        }
        if (this.a.equals(pt) && this.a.equals(this.d)) {
            return new AdditiveInverse(new RatioOfCollinearSegments(this.b, this.a, this.c, this.d)).eliminate(pt, prover);
        }
        if (this.a.equals(pt) && this.a.equals(this.c)) {
            return new AdditiveInverse(new RatioOfCollinearSegments(this.b, this.a, this.d, this.c)).eliminate(pt, prover);
        }
        if (this.a.equals(pt)) {
            return new AdditiveInverse(new RatioOfCollinearSegments(this.b, this.a, this.c, this.d)).eliminate(pt, prover);
        }
        if (this.c.equals(pt)) {
            return new Fraction(new BasicNumber(1), new RatioOfCollinearSegments(this.d, this.c, this.b, this.a)).eliminate(pt, prover);
        }
        if (this.b.equals(pt) && this.b.equals(this.d)) {
            if (pt instanceof AMIntersectionPoint) {
                Point u = ((AMIntersectionPoint)pt).getU();
                Point v = ((AMIntersectionPoint)pt).getV();
                Point p = ((AMIntersectionPoint)pt).getP();
                Point q = ((AMIntersectionPoint)pt).getQ();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(this.a);
                points.add(u);
                points.add(v);
                CollinearPoints statementToVerify = new CollinearPoints(points);
                AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
                AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
                int retCode = verifier.prove();
                if (retCode == 1) {
                    AreaOfTriangle sapq = new AreaOfTriangle(this.a, p, q);
                    AreaOfTriangle scpq = new AreaOfTriangle(this.c, p, q);
                    return new Fraction(sapq, scpq);
                }
                if (retCode == 0) {
                    AreaOfTriangle sauv = new AreaOfTriangle(this.a, u, v);
                    AreaOfTriangle scuv = new AreaOfTriangle(this.c, u, v);
                    return new Fraction(sauv, scuv);
                }
                throw new UnknownStatementException("Elimination of the point " + pt.getGeoObjectLabel() + " in the ratio " + this.print());
            }
            if (pt instanceof AMFootPoint) {
                Point p = ((AMFootPoint)pt).getP();
                Point u = ((AMFootPoint)pt).getU();
                Point v = ((AMFootPoint)pt).getV();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(this.a);
                points.add(u);
                points.add(v);
                CollinearPoints statementToVerify = new CollinearPoints(points);
                AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
                AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
                int retCode = verifier.prove();
                if (retCode == 1) {
                    PythagorasDifference ppuv = new PythagorasDifference(p, u, v);
                    PythagorasDifference ppcv = new PythagorasDifference(p, this.c, v);
                    PythagorasDifference pacv = new PythagorasDifference(this.a, this.c, v);
                    Difference ppcav = new Difference(ppcv, pacv);
                    PythagorasDifference ppvu = new PythagorasDifference(p, v, u);
                    PythagorasDifference ppcu = new PythagorasDifference(p, this.c, u);
                    PythagorasDifference pacu = new PythagorasDifference(this.a, this.c, u);
                    Difference ppcau = new Difference(ppcu, pacu);
                    Sum numerator = new Sum(new Product(ppuv, ppcav), new Product(ppvu, ppcau));
                    PythagorasDifference pcvc = new PythagorasDifference(this.c, v, this.c);
                    Product term1 = new Product(ppuv, pcvc);
                    PythagorasDifference pcuc = new PythagorasDifference(this.c, u, this.c);
                    Product term2 = new Product(ppvu, pcuc);
                    Product term3 = new Product(ppuv, ppvu);
                    Sum denominator = new Sum(term1, new Sum(term2, term3));
                    return new Fraction(numerator, denominator);
                }
                if (retCode == 0) {
                    AreaOfTriangle sauv = new AreaOfTriangle(this.a, u, v);
                    AreaOfTriangle scuv = new AreaOfTriangle(this.c, u, v);
                    return new Fraction(sauv, scuv);
                }
                throw new UnknownStatementException("Elimination of the point " + pt.getGeoObjectLabel() + " in the ratio " + this.print());
            }
            if (pt instanceof PRatioPoint) {
                Point r = ((PRatioPoint)pt).getW();
                Point p = ((PRatioPoint)pt).getU();
                Point q = ((PRatioPoint)pt).getV();
                AMExpression coeff = ((PRatioPoint)pt).getR();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(this.a);
                points.add(r);
                points.add(pt);
                CollinearPoints statementToVerify = new CollinearPoints(points);
                AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
                AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
                int retCode = verifier.prove();
                if (retCode == 1) {
                    RatioOfCollinearSegments ratioarpq = new RatioOfCollinearSegments(this.a, r, p, q);
                    RatioOfCollinearSegments ratiocrpq = new RatioOfCollinearSegments(this.c, r, p, q);
                    return new Fraction(new Sum(ratioarpq, coeff), new Sum(ratiocrpq, coeff));
                }
                if (retCode == 0) {
                    AreaOfTriangle sapr = new AreaOfTriangle(this.a, p, r);
                    AreaOfTriangle sarq = new AreaOfTriangle(this.a, r, q);
                    AreaOfTriangle scpr = new AreaOfTriangle(this.c, p, r);
                    AreaOfTriangle scrq = new AreaOfTriangle(this.c, r, q);
                    return new Fraction(new Sum(sapr, sarq), new Sum(scpr, scrq));
                }
                throw new UnknownStatementException("Elimination of the point " + pt.getGeoObjectLabel() + " in the ratio " + this.print());
            }
            if (pt instanceof TRatioPoint) {
                Point p = ((TRatioPoint)pt).getU();
                Point q = ((TRatioPoint)pt).getV();
                AMExpression r = ((TRatioPoint)pt).getR();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(this.a);
                points.add(p);
                points.add(pt);
                CollinearPoints statementToVerify = new CollinearPoints(points);
                AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
                AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
                int retCode = verifier.prove();
                if (retCode == 1) {
                    Fraction coeff = new Fraction(r, new BasicNumber(4));
                    AreaOfTriangle sapq = new AreaOfTriangle(this.a, p, q);
                    PythagorasDifference ppqp = new PythagorasDifference(p, q, p);
                    Difference numerator = new Difference(sapq, new Product(coeff, ppqp));
                    AreaOfTriangle scpq = new AreaOfTriangle(this.c, p, q);
                    Difference denominator = new Difference(scpq, new Product(coeff, ppqp));
                    return new Fraction(numerator, denominator);
                }
                if (retCode == 0) {
                    PythagorasDifference papq = new PythagorasDifference(this.a, p, q);
                    PythagorasDifference pcpq = new PythagorasDifference(this.a, p, q);
                    return new Fraction(papq, pcpq);
                }
                throw new UnknownStatementException("Elimination of the point " + pt.getGeoObjectLabel() + " in the ratio " + this.print());
            }
        }
        if (this.d.equals(pt)) {
            return new Fraction(new BasicNumber(1), new RatioOfCollinearSegments(this.c, this.d, this.a, this.b)).eliminate(pt, prover);
        }
        if (this.b.equals(pt)) {
            if (pt instanceof AMIntersectionPoint) {
                Point u = ((AMIntersectionPoint)pt).getU();
                Point v = ((AMIntersectionPoint)pt).getV();
                Point p = ((AMIntersectionPoint)pt).getP();
                Point q = ((AMIntersectionPoint)pt).getQ();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(this.a);
                points.add(u);
                points.add(v);
                CollinearPoints statementToVerify = new CollinearPoints(points);
                AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
                AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
                int retCode = verifier.prove();
                if (retCode == 1) {
                    AreaOfTriangle sapq = new AreaOfTriangle(this.a, p, q);
                    AreaOfTriangle scpd = new AreaOfTriangle(this.c, p, this.d);
                    AreaOfTriangle scdq = new AreaOfTriangle(this.c, this.d, q);
                    return new Fraction(sapq, new Sum(scpd, scdq));
                }
                if (retCode == 0) {
                    AreaOfTriangle sauv = new AreaOfTriangle(this.a, u, v);
                    AreaOfTriangle scud = new AreaOfTriangle(this.c, u, this.d);
                    AreaOfTriangle scdv = new AreaOfTriangle(this.c, this.d, v);
                    return new Fraction(sauv, new Sum(scud, scdv));
                }
                throw new UnknownStatementException("Elimination of the point " + pt.getGeoObjectLabel() + " in the ratio " + this.print());
            }
            if (pt instanceof AMFootPoint) {
                Point p = ((AMFootPoint)pt).getP();
                Point u = ((AMFootPoint)pt).getU();
                Point v = ((AMFootPoint)pt).getV();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(this.a);
                points.add(u);
                points.add(v);
                CollinearPoints statementToVerify = new CollinearPoints(points);
                AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
                AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
                int retCode = verifier.prove();
                if (retCode == 1) {
                    PythagorasDifference ppcd = new PythagorasDifference(p, this.c, this.d);
                    PythagorasDifference pacd = new PythagorasDifference(this.a, this.c, this.d);
                    PythagorasDifference pcdc = new PythagorasDifference(this.c, this.d, this.c);
                    return new Fraction(new Difference(ppcd, pacd), pcdc);
                }
                if (retCode == 0) {
                    AreaOfTriangle sauv = new AreaOfTriangle(this.a, u, v);
                    AreaOfTriangle scud = new AreaOfTriangle(this.c, u, this.d);
                    AreaOfTriangle scdv = new AreaOfTriangle(this.c, this.d, v);
                    return new Fraction(sauv, new Sum(scud, scdv));
                }
                throw new UnknownStatementException("Elimination of the point " + pt.getGeoObjectLabel() + " in the ratio " + this.print());
            }
            if (pt instanceof PRatioPoint) {
                Point r = ((PRatioPoint)pt).getW();
                Point p = ((PRatioPoint)pt).getU();
                Point q = ((PRatioPoint)pt).getV();
                AMExpression coeff = ((PRatioPoint)pt).getR();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(this.a);
                points.add(r);
                points.add(pt);
                CollinearPoints statementToVerify = new CollinearPoints(points);
                AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
                AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
                int retCode = verifier.prove();
                if (retCode == 1) {
                    RatioOfCollinearSegments ratioarpq = new RatioOfCollinearSegments(this.a, r, p, q);
                    RatioOfCollinearSegments ratiocdpq = new RatioOfCollinearSegments(this.c, this.d, p, q);
                    return new Fraction(new Sum(ratioarpq, coeff), ratiocdpq);
                }
                if (retCode == 0) {
                    AreaOfTriangle sapr = new AreaOfTriangle(this.a, p, r);
                    AreaOfTriangle sarq = new AreaOfTriangle(this.a, r, q);
                    AreaOfTriangle scpd = new AreaOfTriangle(this.c, p, this.d);
                    AreaOfTriangle scdq = new AreaOfTriangle(this.c, this.d, q);
                    return new Fraction(new Sum(sapr, sarq), new Sum(scpd, scdq));
                }
                throw new UnknownStatementException("Elimination of the point " + pt.getGeoObjectLabel() + " in the ratio " + this.print());
            }
            if (pt instanceof TRatioPoint) {
                Point p = ((TRatioPoint)pt).getU();
                Point q = ((TRatioPoint)pt).getV();
                AMExpression r = ((TRatioPoint)pt).getR();
                ArrayList<Point> points = new ArrayList<Point>();
                points.add(this.a);
                points.add(p);
                points.add(pt);
                CollinearPoints statementToVerify = new CollinearPoints(points);
                AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
                AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
                int retCode = verifier.prove();
                if (retCode == 1) {
                    Fraction coeff = new Fraction(r, new BasicNumber(4));
                    AreaOfTriangle sapq = new AreaOfTriangle(this.a, p, q);
                    PythagorasDifference ppqp = new PythagorasDifference(p, q, p);
                    AreaOfTriangle scpd = new AreaOfTriangle(this.c, p, this.d);
                    AreaOfTriangle scdq = new AreaOfTriangle(this.c, this.d, q);
                    Difference numerator = new Difference(sapq, new Product(coeff, ppqp));
                    Sum denominator = new Sum(scpd, scdq);
                    return new Fraction(numerator, denominator);
                }
                if (retCode == 0) {
                    PythagorasDifference papq = new PythagorasDifference(this.a, p, q);
                    PythagorasDifference pcpq = new PythagorasDifference(this.c, p, q);
                    PythagorasDifference pdpq = new PythagorasDifference(this.d, p, q);
                    return new Fraction(papq, new Difference(pcpq, pdpq));
                }
                throw new UnknownStatementException("Elimination of the point " + pt.getGeoObjectLabel() + " in the ratio " + this.print());
            }
        }
        OpenGeoProver.settings.getLogger().error("Unexpected form of fraction : " + this.print() + " where the point to eliminate is " + pt.getGeoObjectLabel());
        return null;
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        return this;
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        return this;
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(this.a);
        points.add(this.c);
        points.add(this.d);
        CollinearPoints statementToVerify = new CollinearPoints(points);
        AreaMethodTheoremStatement areaMethodStatement = ((ThmStatement)statementToVerify).getAreaMethodStatement();
        AreaMethodProver verifier = new AreaMethodProver(areaMethodStatement, prover.getConstructions(), prover.getNDGConditions());
        int retCode = verifier.prove();
        if (retCode == 1) {
            Product xcya = new Product(RatioOfCollinearSegments.getX(this.c), RatioOfCollinearSegments.getY(this.a));
            Product xcyb = new Product(RatioOfCollinearSegments.getX(this.c), RatioOfCollinearSegments.getY(this.b));
            Product yaxb = new Product(RatioOfCollinearSegments.getY(this.a), RatioOfCollinearSegments.getX(this.b));
            Product ybxa = new Product(RatioOfCollinearSegments.getY(this.b), RatioOfCollinearSegments.getX(this.a));
            Product ycxa = new Product(RatioOfCollinearSegments.getY(this.c), RatioOfCollinearSegments.getX(this.a));
            Product ycxb = new Product(RatioOfCollinearSegments.getY(this.c), RatioOfCollinearSegments.getX(this.b));
            Product xcyd = new Product(RatioOfCollinearSegments.getX(this.c), RatioOfCollinearSegments.getY(this.d));
            Product yaxd = new Product(RatioOfCollinearSegments.getY(this.a), RatioOfCollinearSegments.getX(this.d));
            Product ycxd = new Product(RatioOfCollinearSegments.getY(this.c), RatioOfCollinearSegments.getX(this.d));
            Product xayd = new Product(RatioOfCollinearSegments.getX(this.a), RatioOfCollinearSegments.getY(this.d));
            Difference numeratorPart1 = new Difference(xcya, new Sum(xcyb, yaxb));
            Sum numeratorPart2 = new Sum(new Difference(ybxa, ycxa), ycxb);
            Sum numerator = new Sum(numeratorPart1, numeratorPart2);
            Difference denominatorPart1 = new Difference(xcya, new Sum(xcyd, yaxd));
            Sum denominatorPart2 = new Sum(ycxd, new Difference(xayd, ycxa));
            Sum denominator = new Sum(denominatorPart1, denominatorPart2);
            return new Fraction(numerator, denominator);
        }
        if (retCode == 0) {
            Product xbya = new Product(RatioOfCollinearSegments.getX(this.b), RatioOfCollinearSegments.getY(this.a));
            Product xayb = new Product(RatioOfCollinearSegments.getX(this.a), RatioOfCollinearSegments.getY(this.b));
            Product xdyc = new Product(RatioOfCollinearSegments.getX(this.d), RatioOfCollinearSegments.getY(this.c));
            Product xcyd = new Product(RatioOfCollinearSegments.getX(this.c), RatioOfCollinearSegments.getY(this.d));
            Difference numerator = new Difference(xbya, xayb);
            Difference denominator = new Difference(xdyc, xcyd);
            return new Fraction(numerator, denominator);
        }
        throw new UnknownStatementException("Reducing to independant variables of : " + this.print());
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        if (replacementMap.containsKey(this.a)) {
            return new RatioOfCollinearSegments(replacementMap.get(this.a), this.b, this.c, this.d).replace(replacementMap);
        }
        if (replacementMap.containsKey(this.b)) {
            return new RatioOfCollinearSegments(this.a, replacementMap.get(this.b), this.c, this.d).replace(replacementMap);
        }
        if (replacementMap.containsKey(this.c)) {
            return new RatioOfCollinearSegments(this.a, this.b, replacementMap.get(this.c), this.d).replace(replacementMap);
        }
        if (replacementMap.containsKey(this.d)) {
            return new RatioOfCollinearSegments(this.a, this.b, this.c, replacementMap.get(this.d)).replace(replacementMap);
        }
        return this;
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        return new SumOfProducts(new BigProduct(this));
    }
}

