/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.expressions;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.BasicNumber;
import com.ogprover.pp.tp.expressions.BigProduct;
import com.ogprover.pp.tp.expressions.Sum;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.thmprover.AreaMethodProver;
import java.util.HashMap;
import java.util.HashSet;

public class SumOfProducts
extends AMExpression {
    public static final String VERSION_NUM = "1.00";
    protected HashSet<BigProduct> terms = new HashSet();

    public SumOfProducts() {
    }

    public SumOfProducts(BigProduct term) {
        this.terms.add(term);
    }

    public SumOfProducts(HashSet<BigProduct> terms) {
        this.terms.addAll(terms);
    }

    public SumOfProducts(HashSet<BigProduct> terms, BigProduct term) {
        this.terms.addAll(terms);
        this.addTerm(term);
    }

    public SumOfProducts(HashSet<BigProduct> terms1, HashSet<BigProduct> terms2) {
        if (terms1.size() < terms2.size()) {
            HashSet<BigProduct> copy = terms1;
            terms1 = terms2;
            terms2 = copy;
        }
        this.terms.addAll(terms1);
        for (BigProduct term : terms2) {
            this.addTerm(term);
        }
    }

    public HashSet<BigProduct> getTerms() {
        return this.terms;
    }

    @Override
    public String print() {
        if (this.terms.isEmpty()) {
            return "0";
        }
        StringBuilder s = new StringBuilder();
        boolean premier = true;
        s.append("(");
        for (BigProduct p : this.terms) {
            if (!premier) {
                s.append("+");
            } else {
                premier = false;
            }
            s.append(p.print());
        }
        s.append(")");
        return s.toString();
    }

    @Override
    public boolean equals(Object expr) {
        if (!(expr instanceof SumOfProducts)) {
            return false;
        }
        SumOfProducts sum = (SumOfProducts)expr;
        return this.terms.equals(sum.getTerms());
    }

    @Override
    public HashSet<Point> getPoints() {
        HashSet<Point> points = new HashSet<Point>();
        for (BigProduct p : this.terms) {
            points.addAll(p.getPoints());
        }
        return points;
    }

    @Override
    public boolean containsOnlyFreePoints() {
        for (BigProduct p : this.terms) {
            if (p.containsOnlyFreePoints()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        int sum = 0;
        for (BigProduct p : this.terms) {
            sum += p.size();
        }
        return sum;
    }

    @Override
    public AMExpression uniformize(HashSet<HashSet<Point>> knownCollinearPoints) {
        HashSet<BigProduct> newTerms = new HashSet<BigProduct>();
        for (BigProduct p : this.terms) {
            newTerms.add((BigProduct)p.uniformize(knownCollinearPoints));
        }
        return new SumOfProducts(newTerms);
    }

    @Override
    public AMExpression simplifyInOneStep() {
        HashSet<BigProduct> newTerms = new HashSet<BigProduct>(this.terms);
        for (BigProduct next : this.terms) {
            if (!next.getCoeff().isZero()) continue;
            newTerms.remove(next);
        }
        return new SumOfProducts(newTerms);
    }

    @Override
    public AMExpression eliminate(Point pt, AreaMethodProver prover) throws UnknownStatementException {
        OpenGeoProver.settings.getLogger().error("Method eliminate should not be called on sum of product instances.");
        return null;
    }

    @Override
    public AMExpression reduceToSingleFraction() {
        return this;
    }

    @Override
    public AMExpression reduceToRightAssociativeFormInOneStep() {
        return this;
    }

    @Override
    public AMExpression toIndependantVariables(AreaMethodProver prover) throws UnknownStatementException {
        AMExpression sum = new BasicNumber(0);
        for (BigProduct p : this.terms) {
            sum = new Sum(p.toIndependantVariables(prover), sum);
        }
        return sum;
    }

    @Override
    public AMExpression replace(HashMap<Point, Point> replacementMap) {
        HashSet<BigProduct> newTerms = new HashSet<BigProduct>();
        for (BigProduct p : this.terms) {
            newTerms.add((BigProduct)p.replace(replacementMap));
        }
        return new SumOfProducts(newTerms);
    }

    public void addTerm(BigProduct product) {
        boolean productFound = false;
        HashSet<BigProduct> newSet = new HashSet<BigProduct>();
        for (BigProduct p : this.terms) {
            if (p.hasSameFactors(product)) {
                productFound = true;
                BigProduct newProduct = new BigProduct(product.getFactors());
                newProduct.setCoeff((BasicNumber)new Sum(p.getCoeff(), product.getCoeff()).simplify());
                newSet.add(newProduct);
                continue;
            }
            newSet.add(p);
        }
        if (!productFound) {
            newSet.add(product);
        }
        this.terms = newSet;
    }

    @Override
    public SumOfProducts toSumOfProducts() {
        return this;
    }
}

