/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.Point;
import java.util.HashMap;

public class AMFootPoint
extends Point {
    public static final String VERSION_NUM = "1.00";
    protected Point p;
    protected Point u;
    protected Point v;

    @Override
    public int getConstructionType() {
        return 9;
    }

    public Point getP() {
        return this.p;
    }

    public Point getU() {
        return this.u;
    }

    public Point getV() {
        return this.v;
    }

    public AMFootPoint(String pointLabel, Point p, Point u, Point v) {
        this.geoObjectLabel = pointLabel;
        this.p = p;
        this.u = u;
        this.v = v;
    }

    @Override
    public Point clone() {
        AMFootPoint p = new AMFootPoint(this.geoObjectLabel, this.p, this.u, this.v);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public int transformToAlgebraicForm() {
        return 0;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Foot ");
        sb.append(this.geoObjectLabel);
        sb.append(" of the point ");
        sb.append(this.p.geoObjectLabel);
        sb.append(" on the line (");
        sb.append(this.u.geoObjectLabel);
        sb.append(this.v.geoObjectLabel);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.p.getGeoObjectLabel(), this.u.getGeoObjectLabel(), this.v.getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        Point p2 = this.p;
        Point u2 = this.u;
        Point v2 = this.v;
        if (replacementMap.containsKey(this.p)) {
            p2 = replacementMap.get(this.p);
        }
        if (replacementMap.containsKey(this.u)) {
            u2 = replacementMap.get(this.u);
        }
        if (replacementMap.containsKey(this.v)) {
            v2 = replacementMap.get(this.v);
        }
        return new AMFootPoint(this.geoObjectLabel, p2, u2, v2);
    }
}

