/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;

public class AMIntersectionPoint
extends IntersectionPoint {
    public static final String VERSION_NUM = "1.00";
    protected Point u;
    protected Point v;
    protected Point p;
    protected Point q;

    @Override
    public int getConstructionType() {
        return 21;
    }

    public Point getU() {
        return this.u;
    }

    public Point getV() {
        return this.v;
    }

    public Point getP() {
        return this.p;
    }

    public Point getQ() {
        return this.q;
    }

    public AMIntersectionPoint(String pointLabel, Point u, Point v, Point p, Point q) {
        super(pointLabel, new LineThroughTwoPoints("TODO", u, v), new LineThroughTwoPoints("TODO", p, q));
        this.u = u;
        this.v = v;
        this.p = p;
        this.q = q;
    }

    @Override
    public Point clone() {
        AMIntersectionPoint pp = new AMIntersectionPoint(this.geoObjectLabel, this.u, this.v, this.p, this.q);
        if (this.getX() != null) {
            pp.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            pp.setY((UXVariable)this.getY().clone());
        }
        pp.setInstanceType(this.instanceType);
        pp.setPointState(this.pointState);
        pp.setConsProtocol(this.consProtocol);
        pp.setIndex(this.index);
        return pp;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            if (this.u == null || this.v == null || this.p == null || this.q == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Intersection point " + this.getGeoObjectLabel() + " can't be constructed since some base points' set is not constructed");
                return false;
            }
            if (this.u.getIndex() < 0 || this.u.getIndex() >= this.index || this.v.getIndex() < 0 || this.v.getIndex() >= this.index || this.p.getIndex() < 0 || this.p.getIndex() >= this.index || this.q.getIndex() < 0 || this.q.getIndex() >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Intersection point " + this.getGeoObjectLabel() + " can't be constructed since some base points' set is not yet constructed or not added to theorem protocol");
                return false;
            }
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
        return true;
    }

    @Override
    public int transformToAlgebraicForm() {
        return -4;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Intersection point ");
        sb.append(this.geoObjectLabel);
        sb.append(" of line (");
        sb.append(this.u.geoObjectLabel);
        sb.append(this.v.geoObjectLabel);
        sb.append(") and line (");
        sb.append(this.p.geoObjectLabel);
        sb.append(this.q.geoObjectLabel);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.u.getGeoObjectLabel(), this.v.getGeoObjectLabel(), this.p.getGeoObjectLabel(), this.q.getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        Point p2 = this.p;
        Point q2 = this.q;
        Point u2 = this.u;
        Point v2 = this.v;
        if (replacementMap.containsKey(this.p)) {
            p2 = replacementMap.get(this.p);
        }
        if (replacementMap.containsKey(this.q)) {
            q2 = replacementMap.get(this.q);
        }
        if (replacementMap.containsKey(this.u)) {
            u2 = replacementMap.get(this.u);
        }
        if (replacementMap.containsKey(this.v)) {
            v2 = replacementMap.get(this.v);
        }
        return new AMIntersectionPoint(this.geoObjectLabel, p2, q2, u2, v2);
    }
}

