/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.polynomials.XTerm;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SpecialConstantAngle;
import com.ogprover.pp.tp.ndgcondition.AlgebraicNDGCondition;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;

public class AngleOf60Deg
extends GeoConstruction
implements SpecialConstantAngle {
    public static final String VERSION_NUM = "1.00";
    private Point parametricPoint;
    public static String parametricPointLabel = "A";
    public static SymbolicPolynomial conditionForAngleOf60Deg = null;

    @Override
    public void setParametricPoint(Point point) {
        this.parametricPoint = point;
    }

    @Override
    public Point getParametricPoint() {
        return this.parametricPoint;
    }

    public AngleOf60Deg(String angleLabel) {
        this.geoObjectLabel = angleLabel;
        this.parametricPoint = new FreePoint(parametricPointLabel + angleLabel);
    }

    @Override
    public int getConstructionType() {
        return 70;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Angle ");
        sb.append(this.geoObjectLabel);
        sb.append(" of 60 degrees");
        return sb.toString();
    }

    private void instantiateParametricPoint() throws IOException {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        Point point = this.parametricPoint;
        point.setX(new UXVariable(1, this.consProtocol.getXIndex()));
        point.setY(new UXVariable(0, 0L));
        this.consProtocol.incrementXIndex();
        if (point.getPointState() == 0) {
            point.setPointState(1);
        } else {
            point.setPointState(2);
        }
        output.openItem();
        output.writePlainText("Parametric point");
        output.writePointCoordinatesAssignment(point);
        output.closeItem();
    }

    @Override
    public int transformToAlgebraicForm() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        try {
            output.openSubSection("Transformation of angle " + this.geoObjectLabel + " of 60 degrees: ", true);
            output.openEnum("itemize");
            this.instantiateParametricPoint();
            HashMap<String, Point> pointsMap = new HashMap<String, Point>();
            pointsMap.put(parametricPointLabel, this.parametricPoint);
            XPolynomial condition = OGPTP.instantiateCondition(conditionForAngleOf60Deg, pointsMap);
            this.consProtocol.getAlgebraicGeoTheorem().getHypotheses().addXPoly(condition);
            output.openItem();
            output.writePlainText("Polynomial ");
            output.writePolynomial(condition);
            output.writePlainText(" added to system of hypotheses.");
            output.closeItem();
            output.closeEnum("itemize");
            output.closeSubSection();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }

    @Override
    public void processNDGCondition(AlgebraicNDGCondition ndgCond) {
        XTerm xtA = new XTerm(1.0);
        xtA.addPower(new Power(this.parametricPoint.getX().clone(), 1));
        XPolynomial xpA = new XPolynomial();
        xpA.addTerm(xtA);
        XPolynomial ndgPoly = ndgCond.getPolynomial();
        if (ndgPoly.equals(xpA)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Angle ");
            sb.append(this.geoObjectLabel);
            sb.append(" is not zero angle");
            ndgCond.setBestDescription(sb.toString());
        }
    }

    @Override
    public String[] getInputLabels() {
        return null;
    }

    static {
        if (conditionForAngleOf60Deg == null) {
            SymbolicVariable xA = new SymbolicVariable(2, parametricPointLabel);
            conditionForAngleOf60Deg = new SymbolicPolynomial();
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA, 2));
            conditionForAngleOf60Deg.addTerm(t);
            t = new SymbolicTerm(-3.0);
            conditionForAngleOf60Deg.addTerm(t);
        }
    }
}

