/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.GeneralizedAngleTangent;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Angle;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class AngleRay
extends Line {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String OLabel = "O";
    private static final String ALabel = "A";
    private static final String O1Label = "O1";
    private static final String A1Label = "A1";
    private static final String B1Label = "B1";
    private Angle congAngle;
    private Point firstRayPoint;
    private static SymbolicPolynomial conditionForAngRay = null;

    @Override
    public int getConstructionType() {
        return 47;
    }

    public void setCongAngle(Angle angle) {
        this.congAngle = angle;
    }

    public Angle getCongAngle() {
        return this.congAngle;
    }

    public void setFirstRayPoint(Point firstRayPoint) {
        this.firstRayPoint = firstRayPoint;
    }

    public Point getFirstRayPoint() {
        return this.firstRayPoint;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForAngRay;
    }

    public AngleRay(String lineLabel, Point firstRayPoint, Point vertex, Point firstRayPointCongAng, Point vertexCongAng, Point secondRayPointCongAng) {
        this.geoObjectLabel = lineLabel;
        this.points = new Vector();
        if (vertex != null) {
            this.points.add(vertex);
        }
        this.congAngle = new Angle(firstRayPointCongAng, vertexCongAng, secondRayPointCongAng);
        this.firstRayPoint = firstRayPoint;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            Point vertex = (Point)this.points.get(0);
            if (vertex == null || this.firstRayPoint == null || this.congAngle == null || this.congAngle.getFirstRayPoint() == null || this.congAngle.getVertex() == null || this.congAngle.getSecondRayPoint() == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle ray " + this.getGeoObjectLabel() + " because not all necessary points have been constructed.");
                return false;
            }
            int indexO = vertex.getIndex();
            int indexA = this.firstRayPoint.getIndex();
            int indexO1 = this.congAngle.getVertex().getIndex();
            int indexA1 = this.congAngle.getFirstRayPoint().getIndex();
            int indexB1 = this.congAngle.getSecondRayPoint().getIndex();
            if (indexO < 0 || indexA < 0 || indexO1 < 0 || indexA1 < 0 || indexB1 < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle ray " + this.getGeoObjectLabel() + " because some of necessary points is not added to theorem protocol.");
                return false;
            }
            if (indexO >= this.index || indexA >= this.index || indexO1 >= this.index || indexA1 >= this.index || indexB1 >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle ray " + this.getGeoObjectLabel() + " because some of necessary points is not yet constructed.");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        super.findBestPointsForInstantation(manager);
        if (manager.isErrorFlag()) {
            logger.error("Failed in findBestPointsForInstantation() method from superclass");
            return -1;
        }
        if (manager.getPoint().getPointState() == 3) {
            return 0;
        }
        manager.getPoint().setPointState(4);
        manager.setCondition(this.getCondition());
        Point P = manager.getPoint();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(OLabel, (Point)this.points.get(0));
        pointsMap.put(ALabel, this.firstRayPoint);
        pointsMap.put(O1Label, this.congAngle.getVertex());
        pointsMap.put(A1Label, this.congAngle.getFirstRayPoint());
        pointsMap.put(B1Label, this.congAngle.getSecondRayPoint());
        manager.processPointsAndCondition(pointsMap);
        if (manager.isErrorFlag()) {
            logger.error("findBestPointsForInstantation() method failed in processing condition for angle ray");
            return -1;
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(ALabel, this.firstRayPoint);
        pointsMap.put(OLabel, (Point)this.points.get(0));
        pointsMap.put(A1Label, this.congAngle.getFirstRayPoint());
        pointsMap.put(O1Label, this.congAngle.getVertex());
        pointsMap.put(B1Label, this.congAngle.getSecondRayPoint());
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = super.getAllPossibleConditionsWithMappings();
        ArrayList allMappings = new ArrayList();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, this.firstRayPoint);
        pointsMap.put(OLabel, (Point)this.points.get(0));
        pointsMap.put(A1Label, this.congAngle.getFirstRayPoint());
        pointsMap.put(O1Label, this.congAngle.getVertex());
        pointsMap.put(B1Label, this.congAngle.getSecondRayPoint());
        allMappings.add(pointsMap);
        retMap.put((SymbolicPolynomial)this.getCondition().clone(), allMappings);
        return retMap;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Angle ray ");
        sb.append(this.geoObjectLabel);
        sb.append(" of angle with vertex ");
        sb.append(((Point)this.points.get(0)).getGeoObjectLabel());
        sb.append(" and point ");
        sb.append(this.firstRayPoint.getGeoObjectLabel());
        sb.append(" from first ray, which is congruent to angle ");
        sb.append(this.congAngle.getDescription());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.firstRayPoint.getGeoObjectLabel(), ((Point)this.points.get(0)).getGeoObjectLabel(), this.congAngle.getFirstRayPoint().getGeoObjectLabel(), this.congAngle.getVertex().getGeoObjectLabel(), this.congAngle.getSecondRayPoint().getGeoObjectLabel()};
        return inputLabels;
    }

    static {
        if (conditionForAngRay == null) {
            conditionForAngRay = GeneralizedAngleTangent.getConditionForEqualsConvexAngles();
            conditionForAngRay = GeneralizedAngleTangent.substitutePointLabelsForTwoAngles(conditionForAngRay, A1Label, O1Label, B1Label, ALabel, OLabel, M0Label);
        }
    }
}

