/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.GeneralizedAngleTangent;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.AngleOf60Deg;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Angle;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class AngleRayOfThirdAngleTo60Deg
extends Line {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String OLabel = "O";
    private static final String ALabel = "A";
    private static final String O1Label = "O1";
    private static final String A1Label = "A1";
    private static final String B1Label = "B1";
    private static final String O2Label = "O2";
    private static final String A2Label = "A2";
    private static final String B2Label = "B2";
    private Angle firstAngle;
    private Angle secondAngle;
    private Point firstRayPoint;
    private AngleOf60Deg angle60Deg;

    @Override
    public int getConstructionType() {
        return 50;
    }

    public void setFirstAngle(Angle angle) {
        this.firstAngle = angle;
    }

    public Angle getFirstAngle() {
        return this.firstAngle;
    }

    public void setSecondAngle(Angle angle) {
        this.secondAngle = angle;
    }

    public Angle getSecondAngle() {
        return this.secondAngle;
    }

    public void setFirstRayPoint(Point firstRayPoint) {
        this.firstRayPoint = firstRayPoint;
    }

    public Point getFirstRayPoint() {
        return this.firstRayPoint;
    }

    public void setAngle60Deg(AngleOf60Deg angle60Deg) {
        this.angle60Deg = angle60Deg;
    }

    public AngleOf60Deg getAngle60Deg() {
        return this.angle60Deg;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        ArrayList<SymbolicPolynomial> tan = GeneralizedAngleTangent.getSubstitutedConditionForTangentOfSumOfThreeAngles(A1Label, O1Label, B1Label, A2Label, O2Label, B2Label, ALabel, OLabel, M0Label);
        SymbolicPolynomial conditionForAngRayOfThirdAngle = tan.get(0);
        SymbolicTerm angTerm = new SymbolicTerm(1.0);
        angTerm.addPower(new Power(new SymbolicVariable(2, this.angle60Deg.getParametricPoint().getGeoObjectLabel()), 1));
        conditionForAngRayOfThirdAngle.subtractPolynomial(tan.get(1).multiplyByTerm(angTerm));
        return conditionForAngRayOfThirdAngle;
    }

    public AngleRayOfThirdAngleTo60Deg(String lineLabel, Point firstRayPoint, Point vertex, Point firstRayPointFirstAng, Point vertexFirstAng, Point secondRayPointFirstAng, Point firstRayPointSecondAng, Point vertexSecondAng, Point secondRayPointSecondAng, AngleOf60Deg angle60Deg) {
        this.geoObjectLabel = lineLabel;
        this.points = new Vector();
        if (vertex != null) {
            this.points.add(vertex);
        }
        this.firstAngle = new Angle(firstRayPointFirstAng, vertexFirstAng, secondRayPointFirstAng);
        this.secondAngle = new Angle(firstRayPointSecondAng, vertexSecondAng, secondRayPointSecondAng);
        this.firstRayPoint = firstRayPoint;
        this.angle60Deg = angle60Deg;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            Point vertex = (Point)this.points.get(0);
            if (vertex == null || this.firstRayPoint == null || this.firstAngle == null || this.secondAngle == null || this.angle60Deg == null || this.firstAngle.getFirstRayPoint() == null || this.firstAngle.getVertex() == null || this.firstAngle.getSecondRayPoint() == null || this.secondAngle.getFirstRayPoint() == null || this.secondAngle.getVertex() == null || this.secondAngle.getSecondRayPoint() == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle ray " + this.getGeoObjectLabel() + " because not all necessary points have been constructed.");
                return false;
            }
            int indexO = vertex.getIndex();
            int indexA = this.firstRayPoint.getIndex();
            int indexO1 = this.firstAngle.getVertex().getIndex();
            int indexA1 = this.firstAngle.getFirstRayPoint().getIndex();
            int indexB1 = this.firstAngle.getSecondRayPoint().getIndex();
            int indexO2 = this.secondAngle.getVertex().getIndex();
            int indexA2 = this.secondAngle.getFirstRayPoint().getIndex();
            int indexB2 = this.secondAngle.getSecondRayPoint().getIndex();
            int indexang = this.angle60Deg.getIndex();
            if (indexO < 0 || indexA < 0 || indexO1 < 0 || indexA1 < 0 || indexB1 < 0 || indexO2 < 0 || indexA2 < 0 || indexB2 < 0 || indexang < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle ray " + this.getGeoObjectLabel() + " because some of necessary points is not added to theorem protocol.");
                return false;
            }
            if (indexO >= this.index || indexA >= this.index || indexO1 >= this.index || indexA1 >= this.index || indexB1 >= this.index || indexO2 >= this.index || indexA2 >= this.index || indexB2 >= this.index || indexang >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle ray " + this.getGeoObjectLabel() + " because some of necessary points is not yet constructed.");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        super.findBestPointsForInstantation(manager);
        if (manager.isErrorFlag()) {
            logger.error("Failed in findBestPointsForInstantation() method from superclass");
            return -1;
        }
        if (manager.getPoint().getPointState() == 3) {
            return 0;
        }
        manager.getPoint().setPointState(4);
        manager.setCondition(this.getCondition());
        Point P = manager.getPoint();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(OLabel, (Point)this.points.get(0));
        pointsMap.put(ALabel, this.firstRayPoint);
        pointsMap.put(O1Label, this.firstAngle.getVertex());
        pointsMap.put(A1Label, this.firstAngle.getFirstRayPoint());
        pointsMap.put(B1Label, this.firstAngle.getSecondRayPoint());
        pointsMap.put(O2Label, this.secondAngle.getVertex());
        pointsMap.put(A2Label, this.secondAngle.getFirstRayPoint());
        pointsMap.put(B2Label, this.secondAngle.getSecondRayPoint());
        pointsMap.put(this.angle60Deg.getParametricPoint().getGeoObjectLabel(), this.angle60Deg.getParametricPoint());
        manager.processPointsAndCondition(pointsMap);
        if (manager.isErrorFlag()) {
            logger.error("findBestPointsForInstantation() method failed in processing condition for angle ray");
            return -1;
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(OLabel, (Point)this.points.get(0));
        pointsMap.put(ALabel, this.firstRayPoint);
        pointsMap.put(O1Label, this.firstAngle.getVertex());
        pointsMap.put(A1Label, this.firstAngle.getFirstRayPoint());
        pointsMap.put(B1Label, this.firstAngle.getSecondRayPoint());
        pointsMap.put(O2Label, this.secondAngle.getVertex());
        pointsMap.put(A2Label, this.secondAngle.getFirstRayPoint());
        pointsMap.put(B2Label, this.secondAngle.getSecondRayPoint());
        pointsMap.put(this.angle60Deg.getParametricPoint().getGeoObjectLabel(), this.angle60Deg.getParametricPoint());
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = super.getAllPossibleConditionsWithMappings();
        ArrayList allMappings = new ArrayList();
        HashMap<String, Object> pointsMap = new HashMap<String, Object>();
        pointsMap.put(OLabel, this.points.get(0));
        pointsMap.put(ALabel, this.firstRayPoint);
        pointsMap.put(O1Label, this.firstAngle.getVertex());
        pointsMap.put(A1Label, this.firstAngle.getFirstRayPoint());
        pointsMap.put(B1Label, this.firstAngle.getSecondRayPoint());
        pointsMap.put(O2Label, this.secondAngle.getVertex());
        pointsMap.put(A2Label, this.secondAngle.getFirstRayPoint());
        pointsMap.put(B2Label, this.secondAngle.getSecondRayPoint());
        pointsMap.put(this.angle60Deg.getParametricPoint().getGeoObjectLabel(), this.angle60Deg.getParametricPoint());
        allMappings.add(pointsMap);
        retMap.put((SymbolicPolynomial)this.getCondition().clone(), allMappings);
        return retMap;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Angle ray ");
        sb.append(this.geoObjectLabel);
        sb.append(" of angle with vertex ");
        sb.append(((Point)this.points.get(0)).getGeoObjectLabel());
        sb.append(" and point ");
        sb.append(this.firstRayPoint.getGeoObjectLabel());
        sb.append(" from first ray, which is third angle to 60 degrees for angles ");
        sb.append(this.firstAngle.getDescription());
        sb.append(" and ");
        sb.append(this.secondAngle.getDescription());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.firstRayPoint.getGeoObjectLabel(), ((Point)this.points.get(0)).getGeoObjectLabel(), this.firstAngle.getFirstRayPoint().getGeoObjectLabel(), this.firstAngle.getVertex().getGeoObjectLabel(), this.firstAngle.getSecondRayPoint().getGeoObjectLabel(), this.secondAngle.getFirstRayPoint().getGeoObjectLabel(), this.secondAngle.getVertex().getGeoObjectLabel(), this.secondAngle.getSecondRayPoint().getGeoObjectLabel()};
        return inputLabels;
    }
}

