/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.GeneralizedAngleTangent;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Angle;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class AngleTrisector
extends Line {
    public static final String VERSION_NUM = "1.00";
    private static final String M0Label = "0";
    private static final String OLabel = "O";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private Angle angle;

    @Override
    public int getConstructionType() {
        return 48;
    }

    public void setAngle(Angle angle) {
        this.angle = angle;
    }

    public Angle getAngle() {
        return this.angle;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return GeneralizedAngleTangent.substitutePointLabelsForTwoAngles(GeneralizedAngleTangent.getConditionForTripleAngle(), ALabel, OLabel, BLabel, ALabel, OLabel, M0Label);
    }

    public AngleTrisector(String lineLabel, Point firstRayPoint, Point vertex, Point secondRayPoint) {
        this.geoObjectLabel = lineLabel;
        this.points = new Vector();
        if (vertex != null) {
            this.points.add(vertex);
        }
        this.angle = new Angle(firstRayPoint, vertex, secondRayPoint);
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            Point vertex = (Point)this.points.get(0);
            if (vertex == null || this.angle.getFirstRayPoint() == null || this.angle.getSecondRayPoint() == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle trisector " + this.getGeoObjectLabel() + " because its vertex or point from some ray are not constructed");
                return false;
            }
            int indexV = vertex.getIndex();
            int index1 = this.angle.getFirstRayPoint().getIndex();
            int index2 = this.angle.getSecondRayPoint().getIndex();
            if (indexV < 0 || index1 < 0 || index2 < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle trisector " + this.getGeoObjectLabel() + " because its vertex or point from some ray are not added to theorem protocol");
                return false;
            }
            if (indexV >= this.index || index1 >= this.index || index2 >= this.index) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Cannot construct angle trisector " + this.getGeoObjectLabel() + " because its vertex or point from some ray are not yet constructed");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        super.findBestPointsForInstantation(manager);
        if (manager.isErrorFlag()) {
            logger.error("Failed in findBestPointsForInstantation() method from superclass");
            return -1;
        }
        if (manager.getPoint().getPointState() == 3) {
            return 0;
        }
        manager.getPoint().setPointState(4);
        manager.setCondition(this.getCondition());
        Point P = manager.getPoint();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(OLabel, this.angle.getVertex());
        pointsMap.put(ALabel, this.angle.getFirstRayPoint());
        pointsMap.put(BLabel, this.angle.getSecondRayPoint());
        manager.processPointsAndCondition(pointsMap);
        if (manager.isErrorFlag()) {
            logger.error("findBestPointsForInstantation() method failed in processing condition for angle trisector");
            return -1;
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        pointsMap.put(ALabel, this.angle.getFirstRayPoint());
        pointsMap.put(OLabel, this.angle.getVertex());
        pointsMap.put(BLabel, this.angle.getSecondRayPoint());
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = super.getAllPossibleConditionsWithMappings();
        ArrayList allMappings = new ArrayList();
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(OLabel, this.angle.getVertex());
        pointsMap.put(ALabel, this.angle.getFirstRayPoint());
        pointsMap.put(BLabel, this.angle.getSecondRayPoint());
        allMappings.add(pointsMap);
        retMap.put((SymbolicPolynomial)this.getCondition().clone(), allMappings);
        return retMap;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Angle trisector ");
        sb.append(this.geoObjectLabel);
        sb.append(" of angle ");
        sb.append(this.angle.getDescription());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.angle.getFirstRayPoint().getGeoObjectLabel(), this.angle.getVertex().getGeoObjectLabel(), this.angle.getSecondRayPoint().getGeoObjectLabel()};
        return inputLabels;
    }
}

