/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.ConicSection;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.PerpendicularBisector;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.ShortcutConstruction;
import java.util.Vector;

public class CenterOfCircle
extends ShortcutConstruction {
    public static final String VERSION_NUM = "1.00";
    private Circle circle;

    @Override
    public Point getPoint() {
        Point circleCenter = this.circle.getCenter();
        if (circleCenter != null) {
            return circleCenter;
        }
        return (Point)this.shortcutListOfConstructions.get(this.shortcutListOfConstructions.size() - 1);
    }

    @Override
    public Line getLine() {
        return null;
    }

    @Override
    public Circle getCircle() {
        return null;
    }

    @Override
    public ConicSection getConic() {
        return null;
    }

    public CenterOfCircle(String pointLabel, Circle circle) {
        this.circle = circle;
        this.shortcutListOfConstructions = new Vector();
        if (circle.getCenter() != null) {
            return;
        }
        Vector<Point> circlePoints = circle.getPoints();
        if (circlePoints.size() < 3) {
            OpenGeoProver.settings.getLogger().error("Unable to construct center of circle " + circle.getGeoObjectLabel() + " because it doesn't have three points.");
            return;
        }
        Point A = circlePoints.get(0);
        Point B = circlePoints.get(1);
        Point C = circlePoints.get(2);
        PerpendicularBisector mAB = new PerpendicularBisector("centerOfCirclePerpBisectorAB" + Math.round(Math.random() * 1000.0), A, B);
        this.shortcutListOfConstructions.add(mAB);
        PerpendicularBisector mBC = new PerpendicularBisector("centerOfCirclePerpBisectorBC" + Math.round(Math.random() * 1000.0), B, C);
        this.shortcutListOfConstructions.add(mBC);
        IntersectionPoint centerP = new IntersectionPoint(pointLabel, mAB, mBC);
        this.shortcutListOfConstructions.add(centerP);
        circle.setCenter(centerP);
    }

    @Override
    public String getConstructionDesc() {
        return "Center of circle";
    }
}

