/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SelfConditionalPoint;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class CentralSymmetricPoint
extends SelfConditionalPoint {
    public static final String VERSION_NUM = "1.00";
    private static SymbolicPolynomial xConditionForCentralSymmetricPoint;
    private static SymbolicPolynomial yConditionForCentralSymmetricPoint;
    private static final String M0Label = "0";
    private static final String ALabel = "A";
    private static final String SLabel = "S";
    private Point originalPoint = null;
    private Point center = null;

    public void setOriginalPoint(Point originalPoint) {
        this.originalPoint = originalPoint;
    }

    public Point getOriginalPoint() {
        return this.originalPoint;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public Point getCenter() {
        return this.center;
    }

    @Override
    public int getConstructionType() {
        return 4;
    }

    @Override
    public SymbolicPolynomial getXCondition() {
        return xConditionForCentralSymmetricPoint;
    }

    @Override
    public SymbolicPolynomial getYCondition() {
        return yConditionForCentralSymmetricPoint;
    }

    public CentralSymmetricPoint(String pointLabel, Point originalPoint, Point center) {
        this.geoObjectLabel = pointLabel;
        this.originalPoint = originalPoint;
        this.center = center;
    }

    @Override
    public Point clone() {
        CentralSymmetricPoint p = new CentralSymmetricPoint(this.geoObjectLabel, this.originalPoint, this.center);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            if (this.originalPoint == null || this.center == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Central symmetric point " + this.getGeoObjectLabel() + " can't be constructed since original point or center is not constructed");
                return false;
            }
            int indexOP = this.originalPoint.getIndex();
            int indexC = this.center.getIndex();
            if (indexOP < 0 || indexC < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Central symmetric point " + this.getGeoObjectLabel() + " can't be constructed since original pont or center is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexOP && this.index > indexC;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Central symmetric point " + this.getGeoObjectLabel() + " can't be constructed since original pont or center is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cental symmetric point ");
        sb.append(this.geoObjectLabel);
        sb.append(" of point ");
        sb.append(this.originalPoint.getGeoObjectLabel());
        sb.append(" with respect to center of symmetry ");
        sb.append(this.center.getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.originalPoint.getGeoObjectLabel(), this.center.getGeoObjectLabel()};
        return inputLabels;
    }

    @Override
    public Map<String, Point> getPointsForInstantiation() {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, this);
        pointsMap.put(ALabel, this.originalPoint);
        pointsMap.put(SLabel, this.center);
        return pointsMap;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        OpenGeoProver.settings.getLogger().error("This method should not be called on this class.");
        return null;
    }

    static {
        SymbolicTerm t;
        xConditionForCentralSymmetricPoint = null;
        yConditionForCentralSymmetricPoint = null;
        if (xConditionForCentralSymmetricPoint == null) {
            xConditionForCentralSymmetricPoint = new SymbolicPolynomial();
            SymbolicVariable x0 = new SymbolicVariable(2, M0Label);
            SymbolicVariable xA = new SymbolicVariable(2, ALabel);
            SymbolicVariable xS = new SymbolicVariable(2, SLabel);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(xS, 1));
            xConditionForCentralSymmetricPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 1));
            xConditionForCentralSymmetricPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(x0, 1));
            xConditionForCentralSymmetricPoint.addTerm(t);
        }
        if (yConditionForCentralSymmetricPoint == null) {
            yConditionForCentralSymmetricPoint = new SymbolicPolynomial();
            SymbolicVariable y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable yS = new SymbolicVariable(3, SLabel);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(yS, 1));
            yConditionForCentralSymmetricPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA, 1));
            yConditionForCentralSymmetricPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(y0, 1));
            yConditionForCentralSymmetricPoint.addTerm(t);
        }
    }
}

