/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.GeneralizedAngleTangent;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndRadius;
import com.ogprover.pp.tp.geoconstruction.CircleWithDiameter;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.SetOfPoints;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public abstract class Circle
extends GeoConstruction
implements SetOfPoints {
    public static final String VERSION_NUM = "1.00";
    protected static final String M0Label = "0";
    protected static final String ALabel = "A";
    protected static final String BLabel = "B";
    protected static final String CLabel = "C";
    protected static final String OLabel = "O";
    protected Vector<Point> points = new Vector();
    protected Point center = null;
    public static SymbolicPolynomial conditionForCircleWithCenterAndPoint;
    public static SymbolicPolynomial conditionForCircleWithCenterAndRadius;
    public static SymbolicPolynomial conditionForCircleWithDiameter;
    public static SymbolicPolynomial conditionForCircumscribedCircle;

    public void setPoints(Vector<Point> points) {
        this.points = points;
    }

    @Override
    public Vector<Point> getPoints() {
        return this.points;
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public Point getCenter() {
        return this.center;
    }

    public XPolynomial instantiateCondition(Map<String, Point> pointsMap) {
        return OGPTP.instantiateCondition(this.getCondition(), pointsMap);
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        Point pointA;
        int iA;
        int jA;
        ILogger logger = OpenGeoProver.settings.getLogger();
        manager.prepareForFirstInstantiation();
        if (manager.isErrorFlag()) {
            logger.error("Failed in preparation method");
            return -1;
        }
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        Point P = manager.getPoint();
        if (this.center != null && this.center.getIndex() < P.getIndex()) {
            pointsMap.put(M0Label, P);
            pointsMap.put(OLabel, this.center);
            if (this instanceof CircleWithCenterAndRadius) {
                CircleWithCenterAndRadius crCircle = (CircleWithCenterAndRadius)this;
                manager.setCondition(conditionForCircleWithCenterAndRadius);
                pointsMap.put(ALabel, crCircle.getRadius().getFirstEndPoint());
                pointsMap.put(BLabel, crCircle.getRadius().getSecondEndPoint());
                manager.processPointsAndCondition(pointsMap);
                if (manager.isErrorFlag()) {
                    logger.error("Failed in processing specific condition for circle with given center and radius.");
                    return -1;
                }
                if (manager.getPoint().getPointState() == 3) {
                    return 0;
                }
                manager.getPoint().setPointState(4);
            }
            manager.setCondition(conditionForCircleWithCenterAndPoint);
            jA = this.points.size();
            for (iA = 0; iA < jA; ++iA) {
                pointA = this.points.get(iA);
                if (pointA.getIndex() >= P.getIndex()) continue;
                pointsMap.put(ALabel, pointA.clone());
                manager.processPointsAndCondition(pointsMap);
                if (manager.isErrorFlag()) {
                    logger.error("Failed in processing specific condition for circle with given center and one its point.");
                    return -1;
                }
                if (manager.getPoint().getPointState() != 3) continue;
                return 0;
            }
        }
        manager.getPoint().setPointState(4);
        manager.setCondition(conditionForCircumscribedCircle);
        P = manager.getPoint();
        pointsMap.put(M0Label, P);
        jA = this.points.size();
        for (iA = 0; iA < jA; ++iA) {
            pointA = this.points.get(iA);
            if (pointA.getIndex() >= P.getIndex()) continue;
            int jB = this.points.size();
            for (int iB = 0; iB < jB; ++iB) {
                Point pointB = this.points.get(iB);
                if (pointB.getIndex() >= P.getIndex() || pointB.getIndex() == pointA.getIndex()) continue;
                int jC = this.points.size();
                for (int iC = 0; iC < jC; ++iC) {
                    Point pointC = this.points.get(iC);
                    if (pointC.getIndex() >= P.getIndex() || pointC.getIndex() == pointA.getIndex() || pointC.getIndex() == pointB.getIndex()) continue;
                    pointsMap.put(ALabel, pointA);
                    pointsMap.put(BLabel, pointB);
                    pointsMap.put(CLabel, pointC);
                    manager.processPointsAndCondition(pointsMap);
                    if (manager.isErrorFlag()) {
                        logger.error("Failed in processing specific polynomial for circle with three points on it.");
                        return -1;
                    }
                    if (manager.getPoint().getPointState() != 3) continue;
                    return 0;
                }
            }
        }
        P = manager.getPoint();
        P.setPointState(4);
        pointsMap.put(M0Label, P);
        if (this instanceof CircleWithDiameter) {
            CircleWithDiameter dCircle = (CircleWithDiameter)this;
            manager.setCondition(conditionForCircleWithDiameter);
            pointsMap.put(ALabel, dCircle.getDiameter().getFirstEndPoint());
            pointsMap.put(BLabel, dCircle.getDiameter().getSecondEndPoint());
            manager.processPointsAndCondition(pointsMap);
            if (manager.isErrorFlag()) {
                logger.error("Failed in processing specific condition for circle with given diameter.");
                return -1;
            }
            if (manager.getPoint().getPointState() == 3) {
                return 0;
            }
            manager.getPoint().setPointState(4);
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(M0Label, P);
        if (this.getConstructionType() == 60) {
            pointsMap.put(OLabel, this.center);
            pointsMap.put(ALabel, this.points.get(0));
        } else if (this.getConstructionType() == 61) {
            pointsMap.put(OLabel, this.center);
            pointsMap.put(ALabel, ((CircleWithCenterAndRadius)this).getRadius().getFirstEndPoint());
            pointsMap.put(BLabel, ((CircleWithCenterAndRadius)this).getRadius().getSecondEndPoint());
        } else if (this.getConstructionType() == 62) {
            pointsMap.put(ALabel, ((CircleWithDiameter)this).getDiameter().getFirstEndPoint());
            pointsMap.put(BLabel, ((CircleWithDiameter)this).getDiameter().getSecondEndPoint());
        } else if (this.getConstructionType() == 63) {
            pointsMap.put(ALabel, this.points.get(0));
            pointsMap.put(BLabel, this.points.get(1));
            pointsMap.put(CLabel, this.points.get(2));
        }
        return this.instantiateCondition(pointsMap);
    }

    @Override
    public void addPointToSet(Point P) {
        this.points.add(P);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        HashMap<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = new HashMap<SymbolicPolynomial, ArrayList<Map<String, Point>>>();
        ArrayList allMappings = null;
        HashMap<String, Point> pointsMap = null;
        if (this instanceof CircleWithCenterAndRadius) {
            allMappings = new ArrayList();
            pointsMap = new HashMap<String, Point>();
            pointsMap.put(OLabel, this.center);
            pointsMap.put(ALabel, ((CircleWithCenterAndRadius)this).getRadius().getFirstEndPoint());
            pointsMap.put(BLabel, ((CircleWithCenterAndRadius)this).getRadius().getSecondEndPoint());
            allMappings.add(pointsMap);
            retMap.put((SymbolicPolynomial)conditionForCircleWithCenterAndRadius.clone(), allMappings);
        }
        if (this.points.size() > 0) {
            if (this.center != null) {
                allMappings = new ArrayList();
                for (Point A : this.points) {
                    pointsMap = new HashMap();
                    pointsMap.put(OLabel, this.center);
                    pointsMap.put(ALabel, A);
                    allMappings.add(pointsMap);
                }
                retMap.put((SymbolicPolynomial)conditionForCircleWithCenterAndPoint.clone(), allMappings);
            }
            if (this.points.size() >= 3) {
                allMappings = new ArrayList();
                for (Point A : this.points) {
                    for (Point B : this.points) {
                        if (B.getGeoObjectLabel().equals(A.getGeoObjectLabel())) continue;
                        for (Point C : this.points) {
                            if (C.getGeoObjectLabel().equals(A.getGeoObjectLabel()) || C.getGeoObjectLabel().equals(B.getGeoObjectLabel())) continue;
                            pointsMap = new HashMap();
                            pointsMap.put(ALabel, A);
                            pointsMap.put(BLabel, B);
                            pointsMap.put(CLabel, C);
                            allMappings.add(pointsMap);
                        }
                    }
                }
                retMap.put((SymbolicPolynomial)conditionForCircumscribedCircle.clone(), allMappings);
            }
            if (this instanceof CircleWithDiameter) {
                allMappings = new ArrayList();
                pointsMap = new HashMap();
                pointsMap.put(ALabel, ((CircleWithDiameter)this).getDiameter().getFirstEndPoint());
                pointsMap.put(BLabel, ((CircleWithDiameter)this).getDiameter().getSecondEndPoint());
                allMappings.add(pointsMap);
                retMap.put((SymbolicPolynomial)conditionForCircleWithDiameter.clone(), allMappings);
            }
        }
        return retMap;
    }

    static {
        SymbolicTerm t;
        SymbolicVariable yA;
        SymbolicVariable xA;
        SymbolicVariable yO;
        SymbolicVariable xO;
        SymbolicVariable y0;
        SymbolicVariable x0;
        conditionForCircleWithCenterAndPoint = null;
        conditionForCircleWithCenterAndRadius = null;
        conditionForCircleWithDiameter = null;
        conditionForCircumscribedCircle = null;
        if (conditionForCircleWithCenterAndPoint == null) {
            conditionForCircleWithCenterAndPoint = new SymbolicPolynomial();
            x0 = new SymbolicVariable(2, M0Label);
            y0 = new SymbolicVariable(3, M0Label);
            xO = new SymbolicVariable(2, OLabel);
            yO = new SymbolicVariable(3, OLabel);
            xA = new SymbolicVariable(2, ALabel);
            yA = new SymbolicVariable(3, ALabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(x0, 2));
            conditionForCircleWithCenterAndPoint.addTerm(t);
            t = new SymbolicTerm(-2.0);
            t.addPower(new Power(x0, 1));
            t.addPower(new Power(xO, 1));
            conditionForCircleWithCenterAndPoint.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(y0, 2));
            conditionForCircleWithCenterAndPoint.addTerm(t);
            t = new SymbolicTerm(-2.0);
            t.addPower(new Power(y0, 1));
            t.addPower(new Power(yO, 1));
            conditionForCircleWithCenterAndPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA, 2));
            conditionForCircleWithCenterAndPoint.addTerm(t);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(xA, 1));
            t.addPower(new Power(xO, 1));
            conditionForCircleWithCenterAndPoint.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA, 2));
            conditionForCircleWithCenterAndPoint.addTerm(t);
            t = new SymbolicTerm(2.0);
            t.addPower(new Power(yA, 1));
            t.addPower(new Power(yO, 1));
            conditionForCircleWithCenterAndPoint.addTerm(t);
        }
        if (conditionForCircleWithCenterAndRadius == null) {
            conditionForCircleWithCenterAndRadius = new SymbolicPolynomial();
            x0 = new SymbolicVariable(2, M0Label);
            y0 = new SymbolicVariable(3, M0Label);
            xO = new SymbolicVariable(2, OLabel);
            yO = new SymbolicVariable(3, OLabel);
            xA = new SymbolicVariable(2, ALabel);
            yA = new SymbolicVariable(3, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            SymbolicTerm t2 = new SymbolicTerm(1.0);
            t2.addPower(new Power(x0, 2));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(-2.0);
            t2.addPower(new Power(x0, 1));
            t2.addPower(new Power(xO, 1));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(1.0);
            t2.addPower(new Power(xO, 2));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(1.0);
            t2.addPower(new Power(y0, 2));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(-2.0);
            t2.addPower(new Power(y0, 1));
            t2.addPower(new Power(yO, 1));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(1.0);
            t2.addPower(new Power(yO, 2));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(-1.0);
            t2.addPower(new Power(xA, 2));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(2.0);
            t2.addPower(new Power(xA, 1));
            t2.addPower(new Power(xB, 1));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(-1.0);
            t2.addPower(new Power(xB, 2));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(-1.0);
            t2.addPower(new Power(yA, 2));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(2.0);
            t2.addPower(new Power(yA, 1));
            t2.addPower(new Power(yB, 1));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
            t2 = new SymbolicTerm(-1.0);
            t2.addPower(new Power(yB, 2));
            conditionForCircleWithCenterAndRadius.addTerm(t2);
        }
        if (conditionForCircleWithDiameter == null) {
            conditionForCircleWithDiameter = new SymbolicPolynomial();
            x0 = new SymbolicVariable(2, M0Label);
            y0 = new SymbolicVariable(3, M0Label);
            SymbolicVariable xA2 = new SymbolicVariable(2, ALabel);
            SymbolicVariable yA2 = new SymbolicVariable(3, ALabel);
            SymbolicVariable xB = new SymbolicVariable(2, BLabel);
            SymbolicVariable yB = new SymbolicVariable(3, BLabel);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(x0, 2));
            conditionForCircleWithDiameter.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xA2, 1));
            t.addPower(new Power(x0, 1));
            conditionForCircleWithDiameter.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(x0, 1));
            conditionForCircleWithDiameter.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xA2, 1));
            t.addPower(new Power(xB, 1));
            conditionForCircleWithDiameter.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(y0, 2));
            conditionForCircleWithDiameter.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yA2, 1));
            t.addPower(new Power(y0, 1));
            conditionForCircleWithDiameter.addTerm(t);
            t = new SymbolicTerm(-1.0);
            t.addPower(new Power(yB, 1));
            t.addPower(new Power(y0, 1));
            conditionForCircleWithDiameter.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(yA2, 1));
            t.addPower(new Power(yB, 1));
            conditionForCircleWithDiameter.addTerm(t);
        }
        if (conditionForCircumscribedCircle == null) {
            conditionForCircumscribedCircle = GeneralizedAngleTangent.getConditionForEqualsConvexAngles();
            conditionForCircumscribedCircle = GeneralizedAngleTangent.substitutePointLabelsForTwoAngles(conditionForCircumscribedCircle, ALabel, CLabel, BLabel, ALabel, M0Label, BLabel);
        }
    }
}

