/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.Vector;

public class CircleWithCenterAndPoint
extends Circle {
    public static final String VERSION_NUM = "1.00";

    @Override
    public int getConstructionType() {
        return 60;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForCircleWithCenterAndPoint;
    }

    public CircleWithCenterAndPoint(String circleLabel, Point center, Point pointA) {
        this.geoObjectLabel = circleLabel;
        this.points = new Vector();
        if (pointA != null) {
            this.points.add(pointA);
        }
        if (center != null) {
            this.center = center;
        }
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            Point pointA = (Point)this.points.get(0);
            Point center = this.center;
            if (pointA == null || center == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not constructed");
                return false;
            }
            int indexA = pointA.getIndex();
            int indexCenter = center.getIndex();
            if (indexA < 0 || indexCenter < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexCenter;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Circle ");
        sb.append(this.geoObjectLabel);
        sb.append(" with center ");
        sb.append(this.center.getGeoObjectLabel());
        sb.append(" and one point ");
        sb.append(((Point)this.points.get(0)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.center.getGeoObjectLabel(), ((Point)this.points.get(0)).getGeoObjectLabel()};
        return inputLabels;
    }
}

