/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.Vector;

public class CircleWithCenterAndRadius
extends Circle {
    public static final String VERSION_NUM = "1.00";
    private Segment radius = null;

    public void setRadius(Segment radius) {
        this.radius = radius;
    }

    public Segment getRadius() {
        return this.radius;
    }

    @Override
    public int getConstructionType() {
        return 61;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForCircleWithCenterAndRadius;
    }

    public CircleWithCenterAndRadius(String circleLabel, Point center, Point pointA, Point pointB) {
        this.geoObjectLabel = circleLabel;
        this.points = new Vector();
        if (pointA != null && pointB != null) {
            this.radius = new Segment(pointA, pointB);
        }
        if (center != null) {
            this.center = center;
        }
        if (pointA != null && this.center != null && pointA.getGeoObjectLabel().equals(this.center.getGeoObjectLabel())) {
            this.points.add(pointB);
        }
        if (pointB != null && this.center != null && pointB.getGeoObjectLabel().equals(this.center.getGeoObjectLabel())) {
            this.points.add(pointA);
        }
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            Point pointA = this.radius.getFirstEndPoint();
            Point pointB = this.radius.getSecondEndPoint();
            Point center = this.center;
            if (pointA == null || pointB == null || center == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not constructed");
                return false;
            }
            int indexA = pointA.getIndex();
            int indexB = pointB.getIndex();
            int indexCenter = center.getIndex();
            if (indexA < 0 || indexB < 0 || indexCenter < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexB && this.index > indexCenter;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Circle ");
        sb.append(this.geoObjectLabel);
        sb.append(" with center ");
        sb.append(this.center.getGeoObjectLabel());
        sb.append(" and radius ");
        sb.append(this.radius.getDescription());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.center.getGeoObjectLabel(), this.radius.getFirstEndPoint().getGeoObjectLabel(), this.radius.getSecondEndPoint().getGeoObjectLabel()};
        return inputLabels;
    }
}

