/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoobject.Segment;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.Vector;

public class CircleWithDiameter
extends Circle {
    public static final String VERSION_NUM = "1.00";
    private Segment diameter = null;

    public void setDiameter(Segment diameter) {
        this.diameter = diameter;
    }

    public Segment getDiameter() {
        return this.diameter;
    }

    @Override
    public int getConstructionType() {
        return 62;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForCircleWithDiameter;
    }

    public CircleWithDiameter(String circleLabel, Point pointA, Point pointB) {
        this.geoObjectLabel = circleLabel;
        this.points = new Vector();
        if (pointA != null && pointB != null) {
            this.diameter = new Segment(pointA, pointB);
            this.points.add(pointA);
            this.points.add(pointB);
        }
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            Point pointA = this.diameter.getFirstEndPoint();
            Point pointB = this.diameter.getSecondEndPoint();
            if (pointA == null || pointB == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not constructed");
                return false;
            }
            int indexA = pointA.getIndex();
            int indexB = pointB.getIndex();
            if (indexA < 0 || indexB < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexB;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not yet constructed");
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Circle ");
        sb.append(this.geoObjectLabel);
        sb.append(" with diameter ");
        sb.append(this.diameter.getDescription());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.diameter.getFirstEndPoint().getGeoObjectLabel(), this.diameter.getSecondEndPoint().getGeoObjectLabel()};
        return inputLabels;
    }
}

