/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.Vector;

public class CircumscribedCircle
extends Circle {
    public static final String VERSION_NUM = "1.00";

    @Override
    public int getConstructionType() {
        return 63;
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForCircumscribedCircle;
    }

    public CircumscribedCircle(String circleLabel, Point pointA, Point pointB, Point pointC) {
        this.geoObjectLabel = circleLabel;
        this.points = new Vector();
        if (pointA != null) {
            this.points.add(pointA);
        }
        if (pointB != null) {
            this.points.add(pointB);
        }
        if (pointC != null) {
            this.points.add(pointC);
        }
        this.center = null;
    }

    @Override
    public boolean isValidConstructionStep() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (!super.isValidConstructionStep()) {
            return false;
        }
        try {
            boolean valid;
            Point pointA = (Point)this.points.get(0);
            Point pointB = (Point)this.points.get(1);
            Point pointC = (Point)this.points.get(2);
            if (pointA == null || pointB == null || pointC == null) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not constructed");
                return false;
            }
            int indexA = pointA.getIndex();
            int indexB = pointB.getIndex();
            int indexC = pointC.getIndex();
            if (indexA < 0 || indexB < 0 || indexC < 0) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not added to theorem protocol");
                return false;
            }
            boolean bl = valid = this.index > indexA && this.index > indexB && this.index > indexC;
            if (!valid) {
                output.openItemWithDesc("Error: ");
                output.closeItemWithDesc("Circle " + this.getGeoObjectLabel() + " can't be constructed because some of necessary points is not yet constructed");
                return false;
            }
            return valid;
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return false;
        }
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Circumscribed circle ");
        sb.append(this.geoObjectLabel);
        sb.append(" around triangle ");
        sb.append(((Point)this.points.get(0)).getGeoObjectLabel());
        sb.append(((Point)this.points.get(1)).getGeoObjectLabel());
        sb.append(((Point)this.points.get(2)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{((Point)this.points.get(0)).getGeoObjectLabel(), ((Point)this.points.get(1)).getGeoObjectLabel(), ((Point)this.points.get(2)).getGeoObjectLabel()};
        return inputLabels;
    }
}

