/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.geoconstruction.ConicSection;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.ParametricSet;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.ndgcondition.AlgebraicNDGCondition;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ConicSectionWithFivePoints
extends ParametricSet
implements ConicSection {
    public static final String VERSION_NUM = "1.00";
    private Vector<Point> points;
    public static SymbolicPolynomial conditionForConicSectionWithFivePoints = null;

    public void setPoints(Vector<Point> points) {
        this.points = points;
    }

    @Override
    public Vector<Point> getPoints() {
        return this.points;
    }

    public ConicSectionWithFivePoints(String conicLabel, Point A, Point B, Point C, Point D, Point E) {
        this.geoObjectLabel = conicLabel;
        this.points = new Vector();
        this.points.add(A);
        this.points.add(B);
        this.points.add(C);
        this.points.add(D);
        this.points.add(E);
        this.parametricPoints = new Vector();
        this.parametricPoints.add(new FreePoint("B" + conicLabel));
        this.parametricPoints.add(new FreePoint("C" + conicLabel));
        this.parametricPoints.add(new FreePoint("D" + conicLabel));
        this.parametricPoints.add(new FreePoint("E" + conicLabel));
        this.parametricPoints.add(new FreePoint("F" + conicLabel));
    }

    @Override
    public int findBestPointsForInstantation(PointSetRelationshipManager manager) {
        ILogger logger = OpenGeoProver.settings.getLogger();
        manager.prepareForFirstInstantiation();
        if (manager.isErrorFlag()) {
            logger.error("Failed in preparation method");
            return -1;
        }
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        Point P = manager.getPoint();
        pointsMap.put("0", P);
        manager.setCondition(this.getCondition());
        pointsMap.put("B", (Point)this.parametricPoints.get(0));
        pointsMap.put("C", (Point)this.parametricPoints.get(1));
        pointsMap.put("D", (Point)this.parametricPoints.get(2));
        pointsMap.put("E", (Point)this.parametricPoints.get(3));
        pointsMap.put("F", (Point)this.parametricPoints.get(4));
        manager.processPointsAndCondition(pointsMap);
        if (manager.isErrorFlag()) {
            logger.error("Failed in processing specific polynomial for circle with three points on it.");
            return -1;
        }
        return 0;
    }

    @Override
    public XPolynomial instantiateConditionFromBasicElements(Point P) {
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put("0", P);
        pointsMap.put("B", (Point)this.parametricPoints.get(0));
        pointsMap.put("C", (Point)this.parametricPoints.get(1));
        pointsMap.put("D", (Point)this.parametricPoints.get(2));
        pointsMap.put("E", (Point)this.parametricPoints.get(3));
        pointsMap.put("F", (Point)this.parametricPoints.get(4));
        return OGPTP.instantiateCondition(this.getCondition(), pointsMap);
    }

    @Override
    public Map<SymbolicPolynomial, ArrayList<Map<String, Point>>> getAllPossibleConditionsWithMappings() {
        HashMap<SymbolicPolynomial, ArrayList<Map<String, Point>>> retMap = new HashMap<SymbolicPolynomial, ArrayList<Map<String, Point>>>();
        ArrayList allMappings = new ArrayList();
        HashMap pointsMap = new HashMap();
        pointsMap.put("B", this.parametricPoints.get(0));
        pointsMap.put("C", this.parametricPoints.get(1));
        pointsMap.put("D", this.parametricPoints.get(2));
        pointsMap.put("E", this.parametricPoints.get(3));
        pointsMap.put("F", this.parametricPoints.get(4));
        allMappings.add(pointsMap);
        retMap.put((SymbolicPolynomial)this.getCondition().clone(), allMappings);
        return retMap;
    }

    @Override
    public void addPointToSet(Point P) {
        this.points.add(P);
    }

    @Override
    public SymbolicPolynomial getCondition() {
        return conditionForConicSectionWithFivePoints;
    }

    @Override
    public int getConstructionType() {
        return 65;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("General Conic Section ");
        sb.append(this.geoObjectLabel);
        sb.append(" which contains points ");
        sb.append(this.points.get(0).getGeoObjectLabel());
        sb.append(", ");
        sb.append(this.points.get(1).getGeoObjectLabel());
        sb.append(", ");
        sb.append(this.points.get(2).getGeoObjectLabel());
        sb.append(", ");
        sb.append(this.points.get(3).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(this.points.get(4).getGeoObjectLabel());
        return sb.toString();
    }

    private void instantiateParametricPoint(int pointIndex) throws IOException {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        Point point = (Point)this.parametricPoints.get(pointIndex);
        point.setX(new UXVariable(1, this.consProtocol.getXIndex()));
        point.setY(new UXVariable(0, 0L));
        this.consProtocol.incrementXIndex();
        if (point.getPointState() == 0) {
            point.setPointState(1);
        } else {
            point.setPointState(2);
        }
        output.openItem();
        output.writePointCoordinatesAssignment(point);
        output.closeItem();
    }

    private void generatePolynomialForPointFromConicSection(int pointIndex) throws IOException {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        Point point = this.points.get(pointIndex);
        XPolynomial polyCond = this.instantiateConditionFromBasicElements(point);
        this.consProtocol.getAlgebraicGeoTheorem().getHypotheses().addXPoly(polyCond);
        output.openItem();
        StringBuilder sb = new StringBuilder();
        sb.append("Polynomial condition for point ");
        sb.append(point.getGeoObjectLabel());
        sb.append(" to belong to conic section ");
        sb.append(this.getGeoObjectLabel());
        sb.append(" is: ");
        output.writePlainText(sb.toString());
        output.writePolynomial(polyCond);
        output.closeItem();
    }

    @Override
    public int transformToAlgebraicForm() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        try {
            output.openSubSection("Transformation of general conic section " + this.geoObjectLabel + ": ", true);
            output.writePlainText("List of parametric points");
            output.openEnum("itemize");
            this.instantiateParametricPoint(0);
            this.instantiateParametricPoint(1);
            this.instantiateParametricPoint(2);
            this.instantiateParametricPoint(3);
            this.instantiateParametricPoint(4);
            FreePoint X = new FreePoint("X");
            X.setX(new UXVariable(1, 1L));
            X.setY(new UXVariable(1, 2L));
            XPolynomial equation = this.instantiateConditionFromBasicElements(X);
            output.openItem();
            output.writePlainText("Condition for point ");
            output.writePointWithCoordinates(X);
            output.writePlainText(" to belong to this conic section is following equation: ");
            output.writePolynomial(equation);
            output.closeItem();
            this.generatePolynomialForPointFromConicSection(0);
            this.generatePolynomialForPointFromConicSection(1);
            this.generatePolynomialForPointFromConicSection(2);
            this.generatePolynomialForPointFromConicSection(3);
            this.generatePolynomialForPointFromConicSection(4);
            output.closeEnum("itemize");
            output.closeSubSection();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }

    @Override
    public void processNDGCondition(AlgebraicNDGCondition ndgCond) {
    }

    @Override
    public String[] getInputLabels() {
        String[] inputLabels = new String[]{this.points.get(0).getGeoObjectLabel(), this.points.get(1).getGeoObjectLabel(), this.points.get(2).getGeoObjectLabel(), this.points.get(3).getGeoObjectLabel(), this.points.get(4).getGeoObjectLabel()};
        return inputLabels;
    }

    static {
        if (conditionForConicSectionWithFivePoints == null) {
            SymbolicVariable x0 = new SymbolicVariable(2, "0");
            SymbolicVariable y0 = new SymbolicVariable(3, "0");
            SymbolicVariable xB = new SymbolicVariable(2, "B");
            SymbolicVariable xC = new SymbolicVariable(2, "C");
            SymbolicVariable xD = new SymbolicVariable(2, "D");
            SymbolicVariable xE = new SymbolicVariable(2, "E");
            conditionForConicSectionWithFivePoints = new SymbolicPolynomial();
            SymbolicTerm t = new SymbolicTerm(1.0);
            t.addPower(new Power(x0, 2));
            conditionForConicSectionWithFivePoints.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xB, 1));
            t.addPower(new Power(x0, 1));
            t.addPower(new Power(y0, 1));
            conditionForConicSectionWithFivePoints.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xC, 1));
            t.addPower(new Power(y0, 2));
            conditionForConicSectionWithFivePoints.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xD, 1));
            t.addPower(new Power(x0, 1));
            conditionForConicSectionWithFivePoints.addTerm(t);
            t = new SymbolicTerm(1.0);
            t.addPower(new Power(xE, 1));
            t.addPower(new Power(y0, 1));
            conditionForConicSectionWithFivePoints.addTerm(t);
            t = new SymbolicTerm(1.0);
            SymbolicVariable xF = new SymbolicVariable(2, "F");
            t.addPower(new Power(xF, 1));
            conditionForConicSectionWithFivePoints.addTerm(t);
        }
    }
}

