/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.geoconstruction;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;
import java.util.HashMap;

public class FreePoint
extends Point {
    public static final String VERSION_NUM = "1.00";

    @Override
    public int getConstructionType() {
        return 0;
    }

    public FreePoint(String pointLabel) {
        this.geoObjectLabel = pointLabel;
    }

    @Override
    public Point clone() {
        FreePoint p = new FreePoint(this.geoObjectLabel);
        if (this.getX() != null) {
            p.setX((UXVariable)this.getX().clone());
        }
        if (this.getY() != null) {
            p.setY((UXVariable)this.getY().clone());
        }
        p.setInstanceType(this.instanceType);
        p.setPointState(this.pointState);
        p.setConsProtocol(this.consProtocol);
        p.setIndex(this.index);
        return p;
    }

    @Override
    public boolean isValidConstructionStep() {
        return super.isValidConstructionStep();
    }

    @Override
    public int transformToAlgebraicForm() {
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        try {
            output.openSubSection("Transformation of point " + this.geoObjectLabel + ": ", true);
            output.openEnum("itemize");
            this.consProtocol.instantiatePoint(this, 0);
            output.openItem();
            output.writePointCoordinatesAssignment(this);
            output.closeItem();
            output.closeEnum("itemize");
            output.closeSubSection();
        }
        catch (IOException e) {
            logger.error("Failed to write to output file(s).");
            output.close();
            return -1;
        }
        return 0;
    }

    @Override
    public String getConstructionDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Free point ");
        sb.append(this.geoObjectLabel);
        return sb.toString();
    }

    @Override
    public String[] getInputLabels() {
        return null;
    }

    @Override
    public Point replace(HashMap<Point, Point> replacementMap) {
        return this;
    }
}

